#include "ft.h"


extern long **currseq;      /* in pprove.c */
extern int use;


/* bskeleton(q) returns the address of a base formula which is the 
   propositional skeleton of the base formula q. The formula is constructed
   on the main stack. */

basefmla bskeleton(q)
     basefmla q;
{
  long i=q[0];
  basefmla r1,r2;
  switch((int)i)
    {
    case ALL: return bskeleton((basefmla)q[3]);
    case SOME: return bskeleton((basefmla)q[2]);
    case FALSUM: return q;
    case AND:
      {
	r1=bskeleton((basefmla)q[1]);
	r2=bskeleton((basefmla)q[2]);
	sp[0]=AND;
	sp[1]=(long)r1;
	sp[2]=(long)r2;
	sp+=3;
	return sp-3;
      }
    case OR:
      {
	r1=bskeleton((basefmla)q[1]);
	r2=bskeleton((basefmla)q[2]);
	sp[0]=OR;
	sp[1]=(long)r1;
	sp[2]=(long)r2;
	sp+=3;
	return sp-3;
      }
    case IMP:
      {
	r1=bskeleton((basefmla)q[2]);
	r2=bskeleton((basefmla)q[3]);
	sp[0]=IMP;
	sp[1]=0L;
	sp[2]=(long)r1;
	sp[3]=(long)r2;
	sp+=4;
	return sp-4;
      }
    case IFF:
      {
	r1=bskeleton((basefmla)q[2]);
	r2=bskeleton((basefmla)q[3]);
	sp[0]=IFF;
	sp[1]=0L;
	sp[2]=(long)r1;
	sp[3]=(long)r2;
	sp+=4;
	return sp-4;
      }
    default:
      {
	sp[0]=i;
	sp[1]=0L;
	sp+=2;
	return sp-2;
      }
    }
}


/* skeleton(q) returns the propositional skeleton of the base formula of
   the formula q. */

basefmla skeleton(q)
     formula q;
{
  basefmla bskeleton();
  return bskeleton((basefmla)q[0]);
}


/* uskeletons(qant,qa,qd) returns a list containing the
propositional skeletons of the formulas in the list qant and the
active formulas in the 3-lists qa,qd. The list is built on the main
stack. */

list uskeletons(qant,qa,qd)
     list qant,qa,qd;          /* ANT, UNIVSA and UNIVSD from some frame */
{
  basefmla skeleton();
  long *rsp;
  if (qa)                   /* formula, contraction, next */
    {
      if (qa[1]==0L)
	return uskeletons(qant,(list)qa[2],qd);
      rsp=sp;
      sp+=2;
      rsp[0]=(long)skeleton((formula)qa[0]);
      rsp[1]=(long)uskeletons(qant,(list)qa[2],qd);
      return rsp;
    }
  if (qant)  /* regular list */
    {
      rsp=sp;
      sp+=2;
      rsp[0]=(long)skeleton((formula)qant[0]);
      rsp[1]=(long)uskeletons((list)qant[1],(list)NULL,qd);
      return rsp;
    }
  if (qd==(list)NULL)
    return (list)NULL;
  rsp=sp;
  sp+=2;
  rsp[0]=(long)skeleton((formula)qd[0]);
  rsp[1]=(long)uskeletons((list)NULL,(list)NULL,(list)qd[2]);
  return rsp;
}


/* iskeletons(qi,qf) returns a list of propositional skeletons of the
   active formulas in the 3-lists qi,qf. */

list iskeletons(qi,qf)      /* IMPS and IFFS from some frame */
     list qi,qf;
{
  long *rsp;
  basefmla skeleton();
  if (qi)              /* formula, contraction, next */
    {
      if (qi[1]==0L)
	return iskeletons((list)qi[2],qf);
      rsp=sp;
      sp+=2;
      rsp[0]=(long)skeleton((formula)qi[0]);
      rsp[1]=(long)iskeletons((list)qi[2],qf);
      return rsp;
    }
  if (qf==(list)NULL)
    return (list)NULL;
  if (qf[1]==0L)
    return iskeletons((list)NULL,(list)qf[2]);
  rsp=sp;
  sp+=2;
  rsp[0]=(long)skeleton((formula)qf[0]);
  rsp[1]=(long)iskeletons((list)NULL,(list)qf[2]);
  return rsp;
}

/* askeletons(q) returns a list of propositional skeletons of the atomic
   formulas in the list q. */

list askeletons(q)         /* ATOMS from some frame */
     list q;
{
  long *rsp;
  if (q==(list)NULL)
    return (list)NULL;
  rsp=sp;
  sp+=2;
  rsp[0]=(long)skeleton((formula)q[0]);
  rsp[1]=(long)askeletons((list)q[1]);
  return rsp;
}


  
/* pframemake(q) returns a propositional frame made up from the propositional
   skeletons of the active formulas in the frame q. It is presupposed that
   q has empty ANT. */ /* This presupposition has been removed to enable
   prop checking at top level. */

frame pframemake(q)
     frame q;
{
  long *rsp=sp;
  sp+=8;
  rsp[0]=(long)uskeletons((list)ANT(q),(list)UNIVSA(q),(list)UNIVSD(q));
                                                             /* ANTP */
  rsp[1]=(long)skeleton((formula)CONS(q));                   /* CONSP */
  rsp[2]=(long)iskeletons((list)IMPS(q),(list)IFFS(q));      /* IMPSP */
  rsp[3]=(long)askeletons((list)ATOMS(q));                   /* ATOMSP */
  rsp[4]=NULL;                                               /* TRANSP */
  rsp[5]=NULL;                                               /* ORFLAGP */
  rsp[6]=NULL;                                               /* IMPFLAG */ 
  return rsp;
}


/* propcheck(q) returns true iff the sequent represented by the frame q
   has a valid propositional skeleton. */

propcheck(q)
     frame q;
{
  long ausave=anduse;
  long ousave=oruse;
  long *spsave=sp;
  int stat;
  currseq=(long **)pframemake(q);
  if (anduse||oruse)
    use=1;
  else
    use=0;
  stat=redant();
  anduse=ausave;
  oruse=ousave;
  sp=(long *)spsave;
  return stat;
}
