#include "ft.h"


/************************ top level sifting ******************************/




/* isold() returns true iff the current bindings of the input variables
   are an instance of a saved set of bindings. The old bindings are
   stored in variable order in the savelist, latest answer first. */


isold()
{
  list r1,r2,q;
  register long i;
  long *spsave=sp;
#ifdef DEBUG
  if (trace) mess("\nisold");
#endif
  r1=savelist;
  taginvars();
  while(r1)
    {
      r2=r1;
      q=(list)NULL;
      for(i=0L;i<infree[0];i++)
        {
	  if (doinst3(invar(i),(term)r2[0],&q)==0)
	    break;
	  r2=(list)r2[1];
	  if (i==infree[0]-1)
	    {
	      unbind(q);
	      untaginvars();
	      sp=spsave;
	      return 1;
	    }
        }
      for(i=0L;i<infree[0];i++)
	r1=(list)r1[1];  /* next stored solution */
      unbind(q);
    }
  untaginvars();
  sp=spsave;
  return 0;
}


taginvars()
{
  long i;
  long k=infree[0];
  for(i=0;i<k;i++)
    tagvars(invar(i));
}


untaginvars()
{
  long i;
  long k=infree[0];
  for(i=0;i<k;i++)
    untagvars(invar(i));
}


/* saveanswer() appends copies of the current values of the free input
   variables to the savelist. */
   

saveanswer()
{
  long i,j;
  list q;
  long *sp4s;
  term copyto4();
  long *spsave=sp;
#ifdef DEBUG
  if (trace) mess("\nsaveanswer");
#endif
  q=(list)NULL;
  for(i=infree[0];i>0;i--)
    {
      sp4s=sp4;
      sp4+=2;
      sp4s[0]=(long)copyto4(invar(i-1),&q);  /* make new cell */
      sp4s[1]=(long)savelist; /* add to savelist */
      savelist=sp4s;
    }
  untagbind(q);
  if ((j=stack4check())<0)
    return j;   /* only checking of stack 4 */
  sp=spsave;
  return 1;
}


untagbind(q)
     list q;
{
  variable r,s;
  while(q)
    {
      r=(variable)q[0];
      s=(variable)r[1];
      s[0]-=BARVAL;  /* untag copy */
      r[1]=NULL;     /* unbind variable */
      q=(list)q[1];
    }
}




/************************ two-premiss sifting ***************************/


/* First there are several routines for extracting variables from
   sequents and pairs of sequents:

   findvars(q)
   conandvars(q)
   antorvars(q)
   useimpvars(q)
   useiffvars(q)
   allimpvars(q)
   alliffvars(q) */




/* findvars(q) returns a list of the number of variables in the
sequent q followed by pointers to those variables - such a list will
be called a "variable list". The list is built on the main stack. */


list findvars(q)
     frame q;
{
  list free=(list)NULL;
  list r;
#ifdef DEBUG
  if (trace) mess("\nfindvars");
#endif
  fextractvars((formula)CONS(q),&free);
  r=(list)ANT(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[1];
    }
  r=(list)ATOMS(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[1];
    }
  r=(list)IMPS(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))  /* ignore formulas with contraction value 0 */
        fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)IFFS(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
        fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)UNIVSA(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
        fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)UNIVSD(q);
  while(r)     /* only formulas with remaining contractions in UNIVSD */
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  removetags(free);
  sp[0]=(long)lgth(free);
  sp[1]=(long)free;
  sp+=2;
  return sp-2;
}


/* conandvars(q) returns a variable list consisting of the variables
   common to the two premisses in an application of =>& to q, i.e. every
   variable in a formula other than the consequent. */

list conandvars(q)
     frame q;
{
  list free=(list)NULL;
  list r;
#ifdef DEBUG
  if (trace) mess("\nconandvars");
#endif
  r=(list)ANT(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[1];
    }
  r=(list)ATOMS(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[1];
    }
  r=(list)IMPS(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
	fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)IFFS(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
	fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)UNIVSA(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
	fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)UNIVSD(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  removetags(free);
  sp[0]=(long)lgth(free);
  sp[1]=(long)free;
  sp+=2;
  return sp-2;
}


/* antorvars(q) returns a variable list consisting of the variables
   common to the two premisses in an application of |=> to q. */


list antorvars(q)
     frame q;
{
  list oldant=(list)ANT(q);
  list r;
  ANT(q)=oldant[1];
  r=findvars(q);     /* every variable except those in the disjunction */
  ANT(q)=(long)oldant;
  return r;
}


/* useimpvars(q,cell) returns a variable list consisting of the variables
   common to the two premisses in an application of ->=> to q. Note
   that if A->nB is the implication, the variables of B are counted
   iff contractions of the implication remain (as determined by cell[1],
   not by n.) Corresponding check in the construction of VARS(p2).*/


list useimpvars(q,cell)
     frame q;
     list cell;
{
  list free=(list)NULL;
  list r;
  formula imp;
  basefmla impbase;
  subtab impsub;
#ifdef DEBUG
  if (trace) mess("\nuseimpvars");
#endif
  imp=(formula)cell[0];
  impbase=(basefmla)imp[0];   /* IMP n A B */
  impsub=(subtab)imp[1];
  if (cell[1]>1)
    fextractvars2((basefmla)impbase[3],impsub,&free);
  r=(list)ANT(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[1];
    }
  r=(list)ATOMS(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[1];
    }
  r=(list)IMPS(q);
  while(r)
    {
      if (r!=cell&&r[1]&&(r[1]>-BARVAL))
        fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)IFFS(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
        fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)UNIVSA(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
        fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)UNIVSD(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  removetags(free);
  sp[0]=(long)lgth(free);
  sp[1]=(long)free;
  sp+=2;
  return sp-2;
}


/* useiffvars(q) returns a variable list consisting of the variables
   common to the two premisses in an application of <->=> to q. Note
   that if A<->nB is the equivalence, the variables in A and B are always
   counted, even if no  contractions remain in the left premiss, the
   reason for this being that the left premiss is written with A|B as
   consequent.  */


list useiffvars(q)
     frame q;
{
  list conandvars();
#ifdef DEBUG
  if (trace) mess("\nuseiffvars");
#endif
  return conandvars(q);
}



/* allimpvars(q,cell,rbase,rsub) counts the common variables in an application
   of allimp compaction. Here it is the contraction value assigned to
   the implication that determines whether or not we count the variables
   in the consequent of the implication. */


list allimpvars(q,cell,rbase,rsub)
     frame q;
     list cell;
     basefmla rbase;
     subtab rsub;
{
  list free=(list)NULL;
  list r;
#ifdef DEBUG
  if (trace) mess("\nallimpvars");
#endif
  if (rbase[1]>1)
    fextractvars2((basefmla)rbase[3],rsub,&free);   /* rbase is IMP n C D */
  r=(list)ANT(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[1];
    }
  r=(list)ATOMS(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[1];
    }
  r=(list)IMPS(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
        fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)IFFS(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
        fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)UNIVSA(q);
  while(r)
    {
      if (r!=cell&&r[1]&&(r[1]>-BARVAL))
      fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)UNIVSD(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  removetags(free);
  sp[0]=(long)lgth(free);
  sp[1]=(long)free;
  sp+=2;
  return sp-2;
}



/* alliffvars(q,cell,rbase,rsub) counts the common variables in an application
   of alliff compaction. Again note the use of C|D in the left premiss. */


list alliffvars(q,cell,rbase,rsub)
     frame q;
     list cell;
     basefmla rbase;
     subtab rsub;
{
  list free=(list)NULL;
  list r;
#ifdef DEBUG
  if (trace) mess("\nuseiffvars");
#endif
  fextractvars2(rbase,rsub,&free);   /* rbase is IFF n C D */
  r=(list)ANT(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[1];
    }
  r=(list)ATOMS(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[1];
    }
  r=(list)IMPS(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
        fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)IFFS(q);
  while(r)
    {
      if (r[1]&&(r[1]>-BARVAL))
        fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)UNIVSA(q);
  while(r)
    {
      if (r!=cell&&r[1]&&(r[1]>-BARVAL))
      fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  r=(list)UNIVSD(q);
  while(r)
    {
      fextractvars((formula)r[0],&free);
      r=(list)r[2];
    }
  removetags(free);
  sp[0]=(long)lgth(free);
  sp[1]=(long)free;
  sp+=2;
  return sp-2;
}



/* Next functions for extracting variables from terms and formulas */



/* fextractvars(q,&free) sets free to the result of appending the variables
   in the formula q to free. Repetitions are avoided by tagging variables
   once they have been appended to free. Hence the calling functions must
   untag the variables. */


fextractvars(q,free)
     formula q;
     list *free;
{
  long i;
  basefmla qbase=(basefmla)q[0];
  subtab qsub=(subtab)q[1];
  for(i=0L;i<sublength;i++)
    {
      if (fbvarocc(i,qbase))
	textractvars((term)qsub[i],free);
    }
}

fextractvars2(qbase,qsub,free)
     basefmla qbase;
     subtab qsub;
     list *free;
{
  long i;
  for(i=0L;i<sublength;i++)
    {
      if (fbvarocc(i,qbase))
	textractvars((term)qsub[i],free);
    }
}


/* fbvarocc(i,q) returns true if the base formula q contains
   a free occurrence of the syntactic variable i. */


fbvarocc(i,q)
     long i;
     basefmla q;
{
  long j;
  switch((int)q[0])
    {
    case FALSUM:
      return 0;
    case ALL:
      return  (q[2]!=i && fbvarocc(i,(basefmla)q[3]));
    case SOME:
      return (q[1]!=i && fbvarocc(i,(basefmla)q[2]));
    case AND:
      return (fbvarocc(i,(basefmla)q[1]) || fbvarocc(i,(basefmla)q[2]));
    case OR:
      return (fbvarocc(i,(basefmla)q[1]) || fbvarocc(i,(basefmla)q[2]));
    case IMP:
      return (fbvarocc(i,(basefmla)q[2]) || fbvarocc(i,(basefmla)q[3]));
    case IFF:
      return (fbvarocc(i,(basefmla)q[2]) || fbvarocc(i,(basefmla)q[3]));
    default:
      for(j=q[1];j>0;j--)
	if (tbvarocc(i,(baseterm)q[j+1]))
	  return 1;
      return 0;
    }
}



/* textractvars(q,&free) sets free to the result of appending the variables
   in the term q to free. Extracted variables are tagged, tagged variables
   are ignored. */

textractvars(q,free)
     term q;
     list *free;
{
  baseterm qbase;
  subtab qsub;
  long i;
  term getvalvar();
  if (var(q))
    q=getvalvar(q);
  if (param(q))
    return;
  if (var(q))
    {
      if (q[0]>BARVAL) /* this variable has already been extracted */
	return;
      q[0]+=BARVAL;
      sp[0]=(long)q;
      sp[1]=(long)*free;
      *free=sp;
      sp+=2;
      return;
    }
  qbase=(baseterm)q[1];
  qsub=(subtab)q[2];
  for(i=0L;i<sublength;i++)
    if(tbvarocc(i,qbase))
      textractvars((term)qsub[i],free);
}

/************************************************************************/



removetags(free)
     list free;   /* list of variables, but not variable list */
{
  register variable r;
  while(free)
    {
      r=(variable)free[0];
      r[0]-=BARVAL;
      free=(list)free[1];
    }
}


addtags(p)
     list p;    /* unlike in removetags(), p is a variable list */
{
  register variable r;
  p=(list)p[1];
  while(p)
    {
      r=(variable)p[0];
      r[0]+=BARVAL;
      p=(list)p[1];
    }
}


/* savesolution(p) saves a copy of the current bindings of the variables
   in the frame p on the save stack SAVE(p), by appending it to STORE(p).
   If there isn't room to save the bindings, SPOINT is set to zero.
   Note: the save stack must have been set up before savesolution() is
   called. */


savesolution(p)
     frame p;
{
  list q,r,t,revapp2();
  long *spsave=sp;
  long *getblock();
#ifdef DEBUG
  if (trace) mess("\nsavesolution");
#endif
  if (SPOINT(p)==NULL)   /* no more room on the save stack */
    return;
  q=(list)NULL;
  r=(list)VARS(p);
  r=(list)r[1];   /* skip initial length */
  t=(list)NULL;
  while(r)
    {
      if (copysol((variable)r[0],p,&q,&t)<0)
	{
	  SPOINT(p)=NULL;   /* indicating that no more can be stored */
	  if (tellme&4) mess(":");
	  untagbind(q);
	  sp=spsave;
	  return;
	}
      r=(list)r[1];
    }
  STORE(p)=(long)revapp2(t,(list)STORE(p));
  untagbind(q);
  sp=spsave;
}


/* nobound(r) returns true iff all variables in the variable list r are
   unbound. */

nobound(r)
     list r;   /* number of vars followed by variables */
{
  register list s=r;
  register variable q;
  if (s[0]==0) return 1;
  s=(list)s[1];
  while(s)
    {
      q=(variable)s[0];
      if (q[1])
	return 0;
      s=(list)s[1];
    }
  return 1;
}


/* marktrue(q) marks the latest solution of q as a success. */

marktrue(q)
     frame q;
{
  list s=(list)SPOINT(q);
#ifdef DEBUG
  if (trace) mess("\nmarktrue");
#endif
  s[0]=SUCCESS;
  s[1]=STORE(q);
  STORE(q)=(long)s;
  SPOINT(q)=(long)(s+2);
}

markfalse(q)
     frame q;
{
  list s=(list)SPOINT(q);
#ifdef DEBUG
  if (trace) mess("\nmarkfalse");
#endif
  s[0]=FAILURE;
  s[1]=STORE(q);
  STORE(q)=(long)s;
  SPOINT(q)=(long)(s+2);
}

twoold(p1,p2)
     frame p1,p2;
{
  list r,vars,vars2,varlist,q,s;
  long *spsave=sp;
  long i,numvars;
#ifdef DEBUG
  if (trace) mess("\ntwoold");
#endif
  r=(list)STORE(p1);
  if ((r==(list)NULL)||SFLAG(p1))  /* there are no saved solutions of p1 */
    return 0;
  vars=(list)VARS(p1);
  vars2=(list)VARS(p2);
  if ((numvars=vars[0])==0L)
    {
      if (tellme&8)
	mess(";");
      return 1;
    }
  vars=(list)vars[1];
  tagoldvars(p1);
  while(r)
    {
      if (r[0]==SUCCESS)
	{
	  r=(list)r[1];
	  q=(list)NULL;
	  s=r;
	  varlist=vars;
	  while(varlist)
	    {
	      if (doinst3((variable)varlist[0],(term)s[0],&q)==0)
		break;
	      varlist=(list)varlist[1];
	      s=(list)s[1];
	    }
	  if (varlist==(list)NULL)   /* instance */
	    {
	      unbind(q);
	      untagoldvars(p1);
	      sp=spsave;
	      if (tellme&8)
		mess(";");
	      return 1;
	    }
	  for(i=numvars;i;i--)
	    r=(list)r[1];           /* next stored solution */
	  unbind(q);
	  continue;
	}
      /* stored failure case */
      r=(list)r[1];
      q=(list)NULL;
      s=r;
      varlist=vars;
      while(varlist)
	{
	  if (varlistmemb((variable)varlist[0],vars2))
	    {
	      if (doinst3((variable)varlist[0],(term)s[0],&q)==0)
		break;
	    }
	  varlist=(list)varlist[1];
	  s=(list)s[1];
	}
      if (varlist==(list)NULL)
	{
	  unbind(q);
	  untagoldvars(p1);
	  sp=spsave;
	  if (tellme&8)
	    mess(";");
	  return 1;
	}
      for(i=numvars;i;i--)
	r=(list)r[1];
      unbind(q);
    }
  untagoldvars(p1);
  sp=spsave;
  return 0;
}



tagoldvars(q)
     frame q;
{
  variable s;
  list r=(list)VARS(q);
  r=(list)r[1];
  while(r)
    {
      s=(variable)r[0];
      tagvars(s);
      r=(list)r[1];
    }
}

untagoldvars(q)
     frame q;
{
  variable s;
  list r=(list)VARS(q);
  r=(list)r[1];
  while(r)
    {
      s=(variable)r[0];
      untagvars(s);
      r=(list)r[1];
    }
}

      

/* revapp2(s,t) destructively reverse-appends the 2-list s to t */


list revapp2(s,t)
     list s,t;
{
  register list r=t;
  register list u;
  while(s)
    {
      u=(list)s[1];
      s[1]=(long)r;
      r=(list)s;
      s=u;
    }
  return r;
}


lgth(q)
     list q;
{
  register list r=q;
  register int n=0;
  while(r)
    {
      n++;
      r=(list)r[1];
    }
  return n;
}


varlistmemb(v,vl)
     variable v;
     list vl;       /* variable list */
{
  vl=(list)vl[1];   /* skip initial # */
  while(vl)
    {
      if (v==(variable)vl[0])
	return 1;
      vl=(list)vl[1];
    }
  return 0;
}


/* addvars(q,p) returns a variable list (i.e. #vars followed by vars)
   consisting of the new variables in the formula q added
   to the variable list p. New cell on the main stack. */

list addvars(q,p)
     formula q;
     list p;
{
  list r;
  addtags(p);
  r=(list)p[1];
  fextractvars(q,&r);
  removetags(r);
  sp[0]=(long)lgth(r);
  sp[1]=(long)r;
  sp+=2;
  return sp-2;
}


