

#define SETFILE
#include "ft.h"


/* checkvalue() must be checked if the table is changed */

  
struct { char *name;
         int value; }
     sysvars[]= {
       {"ucon",1},
       {"icon",1},
       {"iffcon",1},
       {"ustep",1},
       {"istep",1},
       {"iffstep",1},
       {"allall",1},
       {"allimp",1},
       {"alliff",1},
       {"someor",1},
       {"somesome",1},
       {"oror",1},
       {"orsome",1},
       {"orlock",1},
       {"somelock",1},
       {"andgather",0},  /* only prop */
       {"orgather",0},   /* only prop */
       {"anduse",1},     /* only prop */
       {"oruse",1},      /* only prop */
       {"allinv",0},
       {"ifftrans",0},
       {"timeout",0},
       {"forever",0},
       {"echo",1},
       {"tellme",6},
       {"syntax",0},
       {"eq",0},        /* only prop */
       {"minimal",0},   /* only prop */
       {"topsift",1},
       {"twosift",1},
       {"stuse",0},
       {"szsave",1000},
       {"implock",1},
       {"pcheck",0},
#ifdef DEBUG
       {"trace",0},
       {"dflag",0},
#endif
       {"dummy",-1} };

int savevars[]={
1,   /* ucon     0       */
1,   /* icon     1       */
1,   /* iffcon   2       */
1,   /* ustep    3       */
1,   /* istep    4       */
1,   /* iffstep  5       */
1,   /* allall   6       */
1,   /* allimp   7       */
1,   /* alliff   8       */
1,   /* someor   9       */
1,   /* somesome 10      */
1,   /* oror     11      */
1,   /* orsome   12      */
1,   /* orlock   13      */
1,   /* somelock 14      */
0,   /* andgather15      */
0,   /* orgather 16      */
1,   /* anduse   17      */
1,   /* oruse    18      */
0,   /* allinv   19      */
0,   /* ifftrans 20      */
0,   /* timeout  21      */
0,   /* forever  22      */
1,   /* echo     23      */
6,   /* tellme   24      */
0,   /* syntax   25      */
0,   /* eq       26      */
0,   /* minimal  27      */
1,   /* topsift  28      */
1,   /* twosift  29      */
0,   /* stuse    30      */
1000, /* szsave  31      */
1,    /* implock 32      */
0,    /* pcheck  33      */
#ifdef DEBUG
0,   /* trace    34      */      
0,   /* dflag    35      */
#endif
};



doset(p)
     char *p;
{
  int i;
  if(p[0]=='\0')
    {
      showset();
      return 0;
    }
  while(i=oneset(p))
    {
      if (i<0) return i; /* BADSYNTAX or VARERR */
      if (p[i-1]==','&&p[i]=='\0')
	{
	  push((long)(p+i));
	  return BADSYNTAX;     /* kludge */
	}
      p+=i;
    }
  return 0;
}


doreset(p)
     char *p;
{
  if (*p!='\0')
    {
      push((long)p);
      return BADSYNTAX;
    }
  resetvars();
  resetstacks();
  resetblocks();
  return 1;
}


resetvars()
{
  int count;
  for(count=0;sysvars[count].value>-1;count++)
    sysvars[count].value=savevars[count];
}


showset()
{
  int count=0;
  printf("\n");
  while(sysvars[count].value >-1)
    {
      printf("\n%-12s%d",sysvars[count].name,sysvars[count].value);
      count++;
    }
  printf("\n");
}



/* oneset(p) returns BADSYNTAX or VARERR, or offset (to \0 or char after ,)
   or 0 if *p is 0. */

oneset(p)
     char *p;
{
  long count=0;
  int j,m;
  long getnum(),k;
  if(*p=='\0') return 0;
  while(sysvars[count].value>-1)
    {
      if(j=heads(sysvars[count].name,p))
	{
	  k=getnum(p+j,&m);
          if(m==0)
	    {
	      push((long)(p+j));
	      return BADSYNTAX;
	    }
          if(checkvalue(count,k)<0)
	    {
	      push((long)count);
	      return VARERR;
	    }
          if(p[m+j]!='\0' && p[m+j] != ',')
	    {
	      push((long)(p+m+j));
	      return BADSYNTAX;
	    }
          sysvars[count].value=k;
	  if (count==31)        /* szsave */
	    resetblocks();
	  if (count==27&&k==1)  /* turning on minimal */
	    sysvars[17].value=0;  /* turn off anduse */
	  if (count==17&&k==1)  /* turning on anduse */
	    sysvars[27].value=0;  /* turn off minimal */
          if(p[m+j]=='\0') return m+j;
	  return m+j+1;
	}
      count++;
    }
  push((long)p);
  return BADSYNTAX;
}



/* getnum(p,&m) returns a long made up from digits at p, and sets m
   to the offset to the first non-digit. If p does not begin with a
   digit, 0 is returned. */


long getnum(p,m)
     char *p;
     int *m;
{
  int i,j;
  long num;
  i=j=num=0;
  while('0'<=p[i]&& p[i]<='9')
    i++;
  *m=i;
  if (i==0)
    return 0;
  for(j=0;j<i;j++)
    num=10*num+p[j]-'0';
  return num;
}


checkvalue(num,val)
     long num;
     long val;
{
  if (num==3||num==4||num==5||num==21) /* ustep, istep, iffstep, timeout */
    {
      if (0<=val)
	return 0;
      return VARERR;
    }
  if (num==0 || num==1 || num==2) /* ucon, icon, iffcon */
    {
      if (0<val)
	return 0;
      return VARERR;
    }
  if (num==23)  /* echo */
    {
      if (0<=val&&val<=2)
	return 0;
      return VARERR;
    }
  if (num==24) /* tellme has 5 bits */
    {
      if (0<=val&&val<=31)
	return 0;
      return VARERR;
    }
  if (num==31)     /* szsave */
    {
      if (200<=val&&val<=10000)
	return 0;
      return VARERR;
    }
  if (num==33)
    {
      if (0<=val&&val<=1)
	return 0;
      return VARERR;
    }
#ifdef DEBUG
  if (num==34) /* trace */
    {
      if (0<=val&&val<=2)
	return 0;
      return VARERR;
    }
  if (num==35)  /* dflag */
    {
      if (0<=val) return 0;
      return VARERR;
    }
#endif
  if(val==0 || val==1)
    return 0;
  return VARERR;
}


heads(q,p) /* returns offset to next char in p[], or 0 if 
              q[] is not an initial segment of p[] */
     char *q,*p;
{
  int i=0;
  while(q[i]==p[i])
    if (q[++i]=='\0')
      return i;
  return 0;
}



#undef SETFILE

