#include "ft.h"

#define NV (BMAX/2)


/* "prop n formula" transforms the formula into a propositional
   formula over a domain of n individuals, provided the formula does
   not contain free variables, and applies the propositional 
   algorithm. */


doprop(p)
char *p;
{
  int offs,i;
  long num,getnum();
  formula q,r;
  num=getnum(p,&offs);
  if (offs==0)
    {
      push((long)p);
      return BADSYNTAX;
    }
  if (num<=0)
    return BADTRANS;
  p+=offs;
  if ((i=makeformula(p,&q))<0)
    return i;
  if (hasfreevars((subtab)q[1]))
    return UNTRANS;
  translate(num,(basefmla)q[0],&r);
  if (syntax)
    return 1;
  marktime();     /* start timer when we have a propositional formula */
  return pprove(r);
}


hasfreevars(p)
     subtab p;
{
  long j;
  for(j=0;j<sublength;j++)
    {
      if (p[j])
	return 1;
    }
  return 0;
}


dotrans(p)
     char *p;
{
  int offs,i;
  long num,getnum();
  formula q,r;
  num=getnum(p,&offs);
  if (offs==0)
    {
      push((long)p);
      return BADSYNTAX;
    }
  if (num<=0)
    return BADTRANS;
  p+=offs;
  if ((i=makeformula(p,&q))<0)
    return i;
  if (hasfreevars((subtab)q[1]))
    return UNTRANS;
  translate(num,(basefmla)q[0],&r);
  printfmla(r,(subtab)NULL);
  printf("\n");
  return 1;
}



translate(n,q,r)     /* because of substitution, we must copy all formulas */
     basefmla q,*r;
     long n;
{
  switch((int)q[0])
    {
    case ALL:  makeall(n,q,r);break;
    case SOME: makesome(n,q,r);break;
    case AND:  makeand(n,q,r);break;
    case OR:   makeor(n,q,r);break;
    case IMP:  makeimp(n,q,r);break;
    case IFF:  makeiff(n,q,r);break;
    default:   makeatom(q,r);break;
    }
}


makeand(n,q,r)
     basefmla q,*r;
     long n;
{
  formula s1,s2;
  translate(n,(basefmla)q[1],&s1);
  translate(n,(basefmla)q[2],&s2);
  *r=sp;
  push(AND);
  push((long)s1);
  push((long)s2);
}


makeor(n,q,r)
     basefmla q,*r;
     long n;
{
  formula s1,s2;
  translate(n,(basefmla)q[1],&s1);
  translate(n,(basefmla)q[2],&s2);
  *r=sp;
  push(OR);
  push((long)s1);
  push((long)s2);
}


makeimp(n,q,r)
     basefmla q,*r;
     long n;
{
  formula s1,s2;
  translate(n,(basefmla)q[2],&s1);
  translate(n,(basefmla)q[3],&s2);
  *r=sp;
  push(IMP);
  push(0L);   /* contraction ignored */
  push((long)s1);
  push((long)s2);
}


makeiff(n,q,r)
     basefmla q,*r;
     long n;
{
  formula s1,s2;
  translate(n,(basefmla)q[2],&s1);
  translate(n,(basefmla)q[3],&s2);
  *r=sp;
  push(IFF);
  push(0L);   /* contraction ignored */
  push((long)s1);
  push((long)s2);
}


makeatom(q,r)
     basefmla q,*r;
{
  formula copyat();
  *r=copyat(q);
}


basefmla copyat(q)     /* return copy of atomic formula */
     basefmla q;
{
  long args;
  long *spsave=sp;
  baseterm trcopyterm();
  push(q[0]);
  if (q[0]==FALSUM)
    return spsave;
  push(args=q[1]);
  sp+=args;
  for(;args;args--)
    spsave[1+args]=(long)trcopyterm((baseterm)q[1+args]);
  return spsave;
}

/* return copy of base term t, which contains no fvars or params */

baseterm trcopyterm(t)
     baseterm t;
{
  long args;
  long *spsave=sp;
  push(t[0]);
  if (t[0]<=BMAX)   /* this is bvar */
    return spsave;
  push(args=t[1]);
  sp+=args;
  for(;args;args--)
    spsave[1+args]=(long)trcopyterm((baseterm)t[1+args]);
  return spsave;
}



makeall(n,q,r)   /* contraction value q[1] ignored */
     basefmla q,*r;
     long n;
{
  longcon(n,n,q[2],(basefmla)q[3],r);
}


longcon(n,m,x,p,r)
     long n,m,x;
     basefmla p,*r;
{
  basefmla q;
  long *spsave;
  if (m==1L)
    {
      translate(n,p,r);
      sub(NV+1L,x,*r);
      return;
    }
  spsave=sp;
  push(AND);
  sp+=2;
  longcon(n,m-1,x,p,&q);
  spsave[1]=(long)q;
  translate(n,p,&q);
  sub(NV+m,x,q);
  spsave[2]=(long)q;
  *r=spsave;
}


makesome(n,q,r)
     basefmla q,*r;
     long n;
{
  longdis(n,n,q[1],(basefmla)q[2],r);
}


longdis(n,m,x,p,r)
     long n,m,x;
     basefmla p,*r;
{
  basefmla q;
  long *spsave;
  if (m==1L)
    {
      translate(n,p,r);
      sub(NV+1L,x,*r);
      return;
    }
  spsave=sp;
  push(OR);
  sp+=2;
  longdis(n,m-1,x,p,&q);
  spsave[1]=(long)q;
  translate(n,p,&q);
  sub(NV+m,x,q);
  spsave[2]=(long)q;
  *r=spsave;
}


sub(m,x,p)       /* substitute m for bvar x in formula p */
     long m,x;
     basefmla p;
{
  switch((int)p[0])
  {
  case ALL: {sub(m,x,(basefmla)p[3]);return;}
  case SOME: {sub(m,x,(basefmla)p[2]);return;}
  case AND:  {sub(m,x,(basefmla)p[1]);sub(m,x,(basefmla)p[2]);return;}
  case OR:   {sub(m,x,(basefmla)p[1]);sub(m,x,(basefmla)p[2]);return;}
  case IMP:  {sub(m,x,(basefmla)p[2]);sub(m,x,(basefmla)p[3]);return;}
  case IFF:  {sub(m,x,(basefmla)p[2]);sub(m,x,(basefmla)p[3]);return;}
  default:  subatom(m,x,p);
  }
}

subatom(m,x,p)
     long m,x;
     basefmla p;
{
  long args;
  if (p[0]==FALSUM)
    return;
  args=p[1];
  while(args)
    {
      subter(m,x,(baseterm)p[1+args]);
      args--;
    }
}


subter(m,x,t)
     long m,x;
     baseterm t;
{
  long args;
  if (t[0]==x)
    {
      t[0]=m;
      return;
    }
  if (BMAX<t[0])
    {
      args=t[1];
      while(args)
        {
	  subter(m,x,(baseterm)t[1+args]);
	  args--;
	}
    }
}


