#include "ft.h"


/* Various print routines, used i) during debugging in temporary
functions; ii) when answers are presented at toplevel; iii) when tracing
is active. */


extern long *infunc;       /* in formula.c */

leftparen()
{
  putchar('(');
}

rightparen()
{
  putchar(')');
}


printfmla(bfmla,stab)
     basefmla bfmla;
     subtab stab;
{
  long i,args;
  if (bfmla==NULL)
    return;
  i=bfmla[0];
  if (i==IMP)
    {
      leftparen();
      printfmla((basefmla)bfmla[2],stab);
      printf("->");
      if (bfmla[1]>0)
	printf("%ld",bfmla[1]);
      printfmla((basefmla)bfmla[3],stab);
      rightparen();
      return;
    }
  if (i==IFF)
    {
      leftparen();
      printfmla((basefmla)bfmla[2],stab);
      printf("<->");
      if (bfmla[1]>0)
	printf("%ld",bfmla[1]);
      printfmla((basefmla)bfmla[3],stab);
      rightparen();
      return;
    }
  if (i==AND)
    {
      leftparen();
      printfmla((basefmla)bfmla[1],stab);
      putchar('&');
      printfmla((basefmla)bfmla[2],stab);
      rightparen();
      return;
    }
  if (i==OR)
    {
      leftparen();
      printfmla((basefmla)bfmla[1],stab);
      putchar('|');
      printfmla((basefmla)bfmla[2],stab);
      rightparen();
      return;
    }
  if (i==ALL)
    {
      putchar('A');
      if (bfmla[1]>0)
	printf("%ld",bfmla[1]); /* contraction value */
      printf("x%ld",bfmla[2]);
      printfmla((basefmla)bfmla[3],stab);
      return;
    }
  if (i==SOME)
    {
      putchar('E');
      printf("x%ld",bfmla[1]);
      printfmla((basefmla)bfmla[2],stab);
      return;
    }
  if (i==FALSUM)
    {
      printf("falsum");return;
    }
  if (i==EQU)
    {
      printterm((baseterm)bfmla[2],stab);
      putchar('=');
      printterm((baseterm)bfmla[3],stab);
      return;
    }
  printf("p%ld",i-EQU);   /* predicate */
  args=bfmla[1];
  if (args==0)
    return;
  leftparen();
  for(i=0;i<args;i++)
    {
      printterm((baseterm)bfmla[2+i],stab);
      if (i<args-1)
	putchar(',');
    }
  rightparen();
}


printbasefmla(p)
     basefmla p;
{
  printfmla(p,(subtab)NULL);
}

printbaselist(p)
     list p;
{
  while(p)
    {
      putchar('\n');
      printbasefmla((basefmla)p[0]);
      fflush(stdout);
      p=(list)p[1];
    }
}


printterm(bterm,stab)
     baseterm bterm;
     subtab stab;
{
  long i,args,*bvarval;
  term getvalvar();
  i=bterm[0];
  if (i<=BMAX)
    {
      if (stab==NULL||stab[i]==NULL)
        {
	  printf("x%ld",i);
	  return;
        }
     bvarval=(long *)stab[i];  /* var, param, or subterm */
      if (var(bvarval))
	bvarval=getvalvar(bvarval);
      if (var(bvarval))
        {
	  if (stack<bvarval&&bvarval<stack+STACKSIZE-1)
	    {
#ifdef DEBUG
	      if (trace)
  	        printf("*%ld/%ld",(long)(bvarval-infree2+1),bvarval[0]-1);
	      else
#endif
		printf("*%ld",(long)(bvarval-infree2+1));
	    }
	  else
 	    {
#ifdef DEBUG
	      if (trace)  /* show restriction value */
	        printf(
		       "_%ld/%ld",
		       (long)(textbuf+TEXTSIZE-1-bvarval),bvarval[0]-1
		       );
	      else
#endif
	        printf("_%ld",(long)(textbuf+TEXTSIZE-1-bvarval));
	    }
	  return;
	}
       if (param(bvarval))
	 {
	   printf("prm(%ld)",bvarval[1]);
  	   return;
	 }
      printterm((long *)bvarval[1],(long *)bvarval[2]);
      return;
    }
  if (BMAX<i)
    {
      args=bterm[1];
      printfunction((int)(i-BMAX-1)); /* index into function name table */
      if (args==0)
	return;
      printf("(");
      for(i=0;i<args;i++)
	{
	  printterm((long *)bterm[2+i],stab);
  	  if (i<args-1)
	    printf(",");
	}
      printf(")");
      return;
    }
}



printfunction(i)
     int i;
{
  char *funcnames=(char *)infunc;
  while(i)
    {
      while(*funcnames)funcnames++;
      funcnames++;
      i--;
    }
  printf("%s",funcnames);
}


printterm2(q)
     long *q;
{
  printterm((long *)q[0],(long *)q[1]);
  fflush(stdout);
}

printfmla2(q)
     long *q;
{
  printfmla((long *)q[0],(long *)q[1]);
  fflush(stdout);
}


printvars()
{
  long n=infree[0];
  char *p=(char *) (infree+1);
  int j=0;
  int m=0;
  while(n>0)
    {
      putchar('\n');
      while(p[j]) putchar(p[j++]);
      putchar('=');
      printterm4(invar(m));
      j++;
      m++;
      n--;
    }
}



printfmlas(q)
     list q;    /* of formulas */
{
  while(q)
    {
      putchar('\n');
      printfmla2((formula)q[0]);
      fflush(stdout);
      q=(list)q[1];
    }
}


printfmlas3(q)
     list q;
{
  while(q)
    {
      putchar('\n');
      printfmla2((formula)q[0]);
      printf("  %ld",q[1]);   /* current contraction value */
      fflush(stdout);
      q=(list)q[2];
    }
}




printseq(q)
     frame q;
{
  printf("\nANT:");
  printfmlas((list)ANT(q));
  printf("\nATOMS:");
  printfmlas((list)ATOMS(q));
  printf("\nUNIVSA:");
  printfmlas3((list)UNIVSA(q));
  printf("\nUNIVSD:");
  printfmlas3((list)UNIVSD(q));
  printf("\nIMPS:");
  printfmlas3((list)IMPS(q));
  printf("\nIFFS:");
  printfmlas3((list)IFFS(q));
  printf("\nCONS:");
  printfmla2((formula)CONS(q));
  printf("\nFSTACK: %ld",FSTACK(q));
  printf("\nFFSTACK: %ld\n",FFSTACK(q));
}


printvarlist(q)
     list q;
{
  variable bvarval;
  while(q)
    {
      bvarval=(variable)q[0];
      if (stack<bvarval&&bvarval<stack+STACKSIZE-1)
	{
	  printf("*%ld/%ld",(long)(bvarval-infree2+1),bvarval[0]-1);
	  fflush(stdout);
	}
	else
	  {
	    printf("_%ld/%ld",(long)(textbuf+TEXTSIZE-1-bvarval),bvarval[0]-1);
	    fflush(stdout);
	  }
      q=(list)q[1];
    }
}


printterms(q)
     list q;
{
  if (q==(list)NULL) return;
  while(q)
    {
      printf("\n");
      printterm3((term)(q[0]));
      q=(list)q[1];
    }
}


printterm3(s)
     term s;
{
  term getvalvar();
  if (var(s)) s=getvalvar(s);
  if (var(s))
    {
      if (stack<s&&s<stack+STACKSIZE-1)
	printf("\n*%ld",(long)(s-infree2+1));
      else
	printf("\n_%ld",(long)(textbuf+TEXTSIZE-1-s));
      return;
    }
  if (param(s))
    {
      printf("\n");
      printf("prm(%ld)",s[1]);
      return;
    }
  printf("\n");
  printterm2(s+1);
}


printterm4(s)   /* like printterm3 but no initial newline */
     term s;
{
  term getvalvar();
  if (var(s)) s=getvalvar(s);
  if (var(s))
    {
      if (stack<s&&s<stack+STACKSIZE-1)
        printf("*%ld",(long)(s-infree2+1));
      else
	printf("_%ld",(long)(textbuf+TEXTSIZE-1-s));
      return;
    }
  if (param(s))
    {
      printf("prm(%ld)",s[1]);
      return;
    }
  printterm2(s+1);
}


mess(p)
     char *p;
{
  printf(p);fflush(stdout);
}


printstore(p)
     frame p;
{
  list r;
  r=(list)STORE(p);
  while(r)
    {
      if (r[0]==SUCCESS) mess("\nsuccess:");
      else
	{
	  if (r[0]==FAILURE) mess("\nfailure:");
	  else
	    printterm3((term)r[0]);
	  fflush(stdout);
	}
      r=(list)r[1];
    }
}


