#include "ft.h"

/* There is some Unix-dependent stuff in the interrupt handling. It works
   under 4.2BSD and 4.3BSD. When compiled under 4.3BSD, the interrupt
   handlers should have type void. */


FILE *currin=stdin;  /* current input stream                           */
FILE *readstack[10]; /* arbitrary read depth limit 10                  */
int readsp=0;        /* read stack pointer                             */
char filesave[100];  /* used to report location of error when echo==0  */
long timestack[100]; /* used by marktime() and readtime()              */
int timesp=0;        /* time stack pointer                             */
int cflag=0;         /* ^C interrupt flag                              */
int aflag=0;         /* realtime alarm flag                            */



extern int doset();         /* in set.c          */
extern int doquit();        /* in main.c         */
extern int doread();        /* in main.c         */
extern int doclock();       /* in main.c         */
extern int doprop();        /* in prop.c         */
extern int dotrans();       /* in prop.c         */
extern int doreset();       /* in set.c          */
extern int dostack();       /* in stack.c        */
extern int dofstack();      /* in stack.c        */

struct { int length;                /* only used in doitem() */
         char *word;
         int (*routine)();}
       keyw[] ={
	 {3,"set",doset},
	 {4,"quit",doquit},
	 {4,"read",doread},
	 {5,"clock",doclock},
	 {4,"prop",doprop},
	 {5,"trans",dotrans},
	 {5,"reset",doreset},
	 {5,"stack",dostack},
	 {6,"fstack",dofstack},
	 {0,"dummy",doquit}
       };



     

main()
{
  setupstack();   /* set up dynamic memory areas - routines in stack.c       */
  setupfstack();
  setupblocks();
  starttimer();   /* software timer counts down from one million cpu seconds */
  cinstall();     /* interrupt handler just sets cflag                       */
  ainstall();     /* alarm handler just sets aflag                           */
#ifdef DEBUG
  sinstall();     /* special aarrgh message                                  */
  binstall();     /* same for bus error                                      */
  quitinstall();  /* for possible diagnostics                                */
#endif
  writemess();
  mainloop();
}


    /*********************** timer routines *************************/


starttimer() 
{
  static struct itimerval itim={{1000000L,0L},{1000000L,0L}};
  static struct itimerval otim={{0L,0L},{0L,0L}};
  if (setitimer(ITIMER_VIRTUAL,&itim,&otim)<0)
    {
      printf("\nCouldn't set the virtual timer\n");
      exit(0);
    }
}


long readclock() /* returns a long containing the current count in millisec */
{
  struct itimerval tim;
  if (getitimer(ITIMER_VIRTUAL,&tim)<0)
    {
      printf("\nCouldn't read the clock..giving up\n");
      exit(0);
    }
  else
    return tim.it_value.tv_sec*1000+tim.it_value.tv_usec/1000;
}


doclock(p)
     char *p;
{
  long readclock();
  if (p[0]!='\0')
    {
      push((long)p);
      return BADSYNTAX;
    }
  printf("\n%ld\n",1000000000L-readclock());
  return 1;
}


chandler()
{
  cflag=1;
}

ahandler()
{
  aflag=1;
}

shandler()
{
  printf("\nSegmentation violation...aarrgh!\n");
  reportstacks();
  toplevel();
  cleanup();
  mainloop();
}


bhandler()
{
  printf("\nFun time! Bus error.\n");
  reportstacks();
  toplevel();
  cleanup();
  mainloop();
}


qhandler()
{
#ifdef DEBUG
  if (dflag&1)
    trace=2;
  else
#endif
    {
      mess("\nQuit\n");
      exit(0);
    }
}


cinstall()
{
  static struct sigvec handler = {chandler,0,0};
  struct sigvec old;
  if (sigvec(SIGINT,&handler,&old)<0)
    {
      printf("\nCouldn't install ^C-handler.\n");
      exit(0);
    }
}


quitinstall()
{
  static struct sigvec handler = {qhandler,0,0};
  struct sigvec old;
  if (sigvec(SIGQUIT,&handler,&old)<0)
    {
      printf("\nCouldn't install quit-handler.\n");
      exit(0);
    }
}



ainstall()
{
  static struct sigvec handler= {ahandler,0,0};
  struct sigvec old;
  if (sigvec(SIGALRM,&handler,&old)<0)
    {
      printf("\nCouldn't install alarm handler.\n");
      exit(0);
    }
}


sinstall()
{
  static struct sigvec handler = {shandler,0,0};
  struct sigvec old;
  if (sigvec(SIGSEGV,&handler,&old)<0)
    {
      printf("\nCouldn't install segment violation handler.\n");
      exit(0);
    }
}

binstall()
{
  static struct sigvec handler = {bhandler,0,0};
  struct sigvec old;
  if (sigvec(SIGBUS,&handler,&old)<0)
    {
      printf("\nCouldn't install bus errror handler.\n");
      exit(0);
    }
}


setalarm(n) /* set alarm to go off after n real seconds */
     int n;
{
  static struct itimerval itim={{0L,0L},{0L,0L}};
  static struct itimerval otim={{0L,0L},{0L,0L}};
  itim.it_value.tv_sec=(long)n;
  if (setitimer(ITIMER_REAL,&itim,&otim)<0)
    {
      printf("\nCouldn't set the alarm\n");
      exit(0);
    }
}


turnoffalarm()
{
  static struct itimerval itim={{0L,0L},{0L,0L}};
  static struct itimerval otim={{0L,0L},{0L,0L}};
  if (setitimer(ITIMER_REAL,&itim,&otim)<0)
    {
      printf("\nCouldn't turn off the alarm\n");
      exit(0);
    }
  aflag=0;
}



marktime()
{
  long readclock();
  if (timesp==99)
    {
      printf("\nImpossible error: time stack overflow\n");
      exit(0);
    }
  timestack[timesp++]=readclock();
}



long readtime()
{
  long readclock();
  return timestack[--timesp]-readclock();
}




                 /************* mainloop **************/



writemess()
{
  printf("\nft\nAn intuitionistic theorem prover\n");
  printf("Version 1.23\n");
  printf("Swedish Institute of Computer Science 1989\n\n");
}


mainloop() /* get one item of input from currin, process it, 
              repeat until EOF */

{
  int i,j;
  while(1)
    {
      if (currin==stdin)
	writeprompt();
      if ((i=getitem(currin)) > 1) /* i.e. non-empty input */
        {
	  if ((j=doitem((char *)textbuf))<0)
	    errmess(j);
        }
      else
        {
	  if (i<0)
	    eof_complain();
  	  if (i==0 && (currin==stdin || echo))
	    mess("EOF\n");
  	  if (i<=0)
	    popfile();
        }
      cleanup();
    }
}


eof_complain()
{
  printf("\nLast input ignored - abrupt eof.\n");
}

doquit(p)
     char *p;
{
  if (p[0]!='\0')
    {
      push((long)p);
      return BADSYNTAX;
    }
  exit(0);
}


writeprompt()
{
  if (echo!=2)
    printf(">");
}


cleanup()
{
  clearstack();
  cleartext();
  clearfstack();
  textp=(char *)textbuf;
  turnoffalarm();
  cflag=aflag=0; 
}






            /************* input stream handling ************/


cfclose(fp)
     FILE *fp;
{
  if (fclose(fp))
  {
    printf("\nInexplicable fclose error\n");
    exit(0);
  }
}



FILE *readpop()
{
  if (currin != stdin)
    return readstack[--readsp];
  else
    return stdin;
}


readpush(fp)
     FILE *fp;
{
  if (readsp<10)
    {
      readstack[readsp++]=fp;
      return 0;
    }
  else
    return NESTERR;
}


popfile()
{
  FILE *readpop();
  if (currin != stdin)
    cfclose(currin);
  else
    clearerr(stdin);  /* kill keyboard eof */
  if (currin==stdin)
    {
      putchar('\n');
      exit(0);
    }
  currin=readpop();
}


doread(p)
     char *p;
{
  int i=0;
  FILE *fp,*fopen();
  while(p[i]&&i<99)
    {
      filesave[i]=p[i];
      i++;
    }
  filesave[i]='\0';
  if ((fp=fopen(p,"r"))==NULL)
    {
      push((long)p);
      return OPENERR;
    }
  else
    if (readpush(currin)<0)
      {
	cfclose(fp);
	return NESTERR;
      }
    else
      {
	currin=fp;
	return 1;
      }
}



/* getitem(fp) returns 0 if EOF is reached in an orderly way,
   -1 if the file ends prematurely, else the number of characters
   read to textbuf[], including \0. The closing period is not read to the
   buffer. */


getitem(fp)
     FILE *fp;
{
  int c;
  int last=0;
  int comment=0;     /* level of comment nesting */
  char *textget=(char *)textbuf;
  while(1)
    {
      if (cflag)
	{
	  textget[0]='\0';
	  textp=textget+1;
	  cflag=0;
	  return 1;
	}
      if ((c=getce(fp)) == '%')
	while((c=getce(fp)) != '\n' && c != EOF)
	  ;
      if (c=='[') /* comment nesting added */
	{
	  ++comment;
	  while(1)
	    {
	      while((c=getce(fp)) != ']' && c != '[' && c != EOF)
		;
	      if (c==']')
	        {
		  if (--comment==0)
		    break;
		  else
		    continue;
	        }
	      if (c=='[')
	        {
		  ++comment;
		  continue;
	        }
	      break;  /* if c is EOF */
	    }
	  if (c!=EOF) continue;
	}
      if (c=='\t' || c==' ')
	continue;
      if (c=='\n' && textp==textget)  /* don't wait for period in this case */
        {
	  return 1;
        }
      if(c=='\n')
        {
	  if (last=='.')
	  {
	    textp--;
	    *textp='\0';
	    return ++textp-textget;
	  }
	  continue;
	}
      if (c==EOF)
	{
	  if (textp != textget)
	    return -1;
	  else
	    return 0;
	}
      if (c==DEL && textp != textget)
	textp--; /* never happens with keyboard */
      else 
	{
	  *textp=(char)c;
	  ++textp;
	  last=c;
	}
    }
}



getce(fp)
     FILE *fp;
{
  int c=getc(fp);
  if (c!=EOF && ((echo && fp!=stdin)||(echo==2 && fp==stdin)))
    putchar(c);
  return c;
}






                  /*********** error handling ************/




/* There are the following types of error (apart from some unlikely system
   errors linked to exit()):
   

   BADSYNTAX  Syntax error. Complaint. (See complain().)

   OPENERR  Error in attempting to open a file. On the stack: pointer to the
            offending file name.

   VARERR  Error in the value given for a sysvar. Number of sysvar on stack.
   
   NESTERR  Read stack overflow

   ABORT  ^C abort. On the stack: time used by the aborted command, or -1.

   TIMEOUT  Timeout - the only error condition that does not imply return
            to top level.

   INCSYNTAX  Inconsistent syntax in formula. Complaint.

   BADCONT  Non-positive value for contraction. Complaint.

   BADTRANS  Non-positive value for translation.

   UNTRANS Untranslatable formula.

   ALLOCERR Memory allocation error.

   MAINOVER Main stack overflow.

   AUXOVER Auxiliary stack overflow.

   THIRDOVER Formula stack overflow.

   BADSTACK Bad value for stack size.

     */


errmess(n)
int n;
{
if (currin!=stdin && echo==0)
  printf("\nError while reading %s:\n",filesave);
  switch(n)
    {
    case BADSYNTAX: err1(); break;
    case OPENERR: err2(); break;
    case VARERR: err3(); break;
    case NESTERR: err4(); break;
    case ABORT: err5(); break;
    case TIMEOUT: err6(); break;
    case INCSYNTAX: err7(); break;
    case BADCONT: err8(); break;
    case BADTRANS: err9(); break;
    case UNTRANS: err10(); break;
    case ALLOCERR: err11(); break;
    case MAINOVER: err12(); break;
    case AUXOVER: err13(); break;
    case THIRDOVER: err14();break;
    case BADSTACK: err15();break;
    default: errerr(n);
    }
}


errerr(n)
     int n;
{
  printf("\nInternal error %d\n",-n);
  toplevel();
}

toplevel()
{ 
  allfclose();
  currin=stdin;
}

allfclose()
{
  FILE *fp,*readpop();
  if (currin!=stdin)
    cfclose(currin);
  while((fp=readpop())!=stdin)
    cfclose(fp);
}


complain(s)  /* Error in input. It is the responsibility of the routine 
                that pinpoints the error to leave on the stack a pointer
                to the offending character. */
char s[];
{
  long pop();
  char *p,*q;
  p=(char *) pop();
  printf("\n%s\n",s);
  for(q=(char *)textbuf;q<p;q++)
    putchar(*q);
  printf(" *here* %s\n",p);
  toplevel();
}


err1()
{
  complain("Syntax error\n");
}

err2()
{
  long pop();
  printf("\nCouldn't open %s\n",(char *) pop());
  toplevel();
}

err3()
{
  long pop();
  printf("\nUnacceptable value for %s\n",sysvars[(int) pop()].name);
  toplevel();
}

err4()
{
  printf("\nRead too deeply nested\n");
  toplevel();
}

err5()
{
  long j;
  long pop();
  printf("\nAborted\n");
  if ((j=pop())>0)
    printf("time used %ld\n",j);
  cflag=0;
  if (stuse)
    reportstacks();
  toplevel();
}

err6()
{
  if (timeout>1)
    printf("\n%d seconds timeout\n",timeout);
  else
    printf("1 second timeout\n");
  if (stuse) reportstacks();
  aflag=0;
}

err7()
{
  complain("Inconsistent syntax\n");
}

err8()
{
  complain("Bad contraction value\n");
}

err9()
{
  printf("\nBad cardinality for domain\n");
  toplevel();
}

err10()
{
  printf("\nUntranslatable formula\n");
  toplevel();
}

err11()
{
  printf("\nMemory allocation error\n");
  toplevel();
}

err12()
{
  printf("\nMain stack overflow\n");
  toplevel();
}

err13()
{
  printf("\nAuxiliary stack overflow\n");
  toplevel();
}

err14()
{
  printf("\nFormula stack overflow\n");
  toplevel();
}

err15()
{
  printf("\nBad value for stack size\n");
  toplevel();
}





               /************ command execution *************/


/* doitem(p): if the string p[] begins with a recognized command, the
   corresponding routine is given the address of the next character in
   the string as argument. The routine must return an integer, which is
   non-negative if everything went ok, or a negative error number
   otherwise. If p[] is the name of a system variable, the value of that
   variable is printed. Otherwise p[] is assumed to be a formula to be
   proved. (Thus system variables should not be initial substrings of
   commands or conversely.) */



doitem(p)
     char *p;
{
  int i,count;
  count=0;
  while(i=keyw[count].length)
    {
      if (begins(p,i,keyw[count].word))
	return keyw[count].routine(p+i);
      count++;
    }
  count=0;
  while(sysvars[count].value>-1)
    {
      if (i=heads(sysvars[count].name,p))
        {
          if (p[i])
	    {
	      push((long)(p+i));
	      return BADSYNTAX;
	    }
       	  printf("is %d\n",sysvars[count].value);
          return 1;
        }
      count++;
    }
  return doformula(p);
}


begins(p,i,q)
     char p[],q[];
     int i;
{
  int count=0;
  while(count<i)
    {
      if (p[count] != q[count])
	return 0;
      else
	count++;
    }
  return 1;
}


