#include <stdio.h>
#include <sys/time.h>
#include <signal.h>


#define DEBUG

#define BARVAL (1000000L)

  /* The barrier for general implication locking is marked by subtracting
     1000000 from the contraction value of the barred implication to get
     a negative number. If contraction values > 1000000 are to be used,
     BARVAL must be changed. (Ha ho ho ho..)

     BARVAL is also used in various copying and instance checking routines
     in unify.c, sift.c, and prove.c, where variables are temporarily tagged by
     having BARVAL added to their restriction field.

     Thus "tagging" refers to two operations: adding BARVAL to the
     restriction field of variables, and subtracting BARVAL from the
     contraction field of cells in IMPS, IFFS, UNIVSA, UNIVSD. */

     

#define DEL 127

#define FALSUM 1L
#define AND 2L
#define OR 3L
#define IMP 4L
#define IFF 5L

/* this is the order of precedence of connectives. All right-associative. */

#define ALL 6L
#define SOME 7L

#define BMAX 10000L   /* largest syntactic variable */
#define FNMAX 20000L   /* largest function symbol */


#define EQU (BMAX+1)    /* predicate symbols are larger than EQU */

#define FORTH 0         /* used by doseq() */
#define BACK 1

#define SUCCESS 2L
#define FAILURE 3L



#define BADSYNTAX (-1)
#define OPENERR (-2)
#define VARERR (-3)
#define NESTERR (-4)
#define ABORT (-5)
#define TIMEOUT (-6)
#define INCSYNTAX (-7)
#define BADCONT (-8)
#define BADTRANS (-9)
#define UNTRANS (-10)
#define ALLOCERR (-11)
#define MAINOVER (-12)
#define AUXOVER (-13)
#define THIRDOVER (-14)
#define BADSTACK (-15)

#ifndef SETFILE
extern struct { char *name; int value;} sysvars[];  /* in set.c */
#endif

#define ucon (sysvars[0].value)
#define icon (sysvars[1].value)
#define iffcon (sysvars[2].value)
#define ustep (sysvars[3].value)
#define istep (sysvars[4].value)
#define iffstep (sysvars[5].value)
#define allall (sysvars[6].value)
#define allimp (sysvars[7].value)
#define alliff (sysvars[8].value)
#define someor (sysvars[9].value)
#define somesome (sysvars[10].value)
#define oror (sysvars[11].value)
#define orsome (sysvars[12].value)
#define orlock (sysvars[13].value)
#define somelock (sysvars[14].value)
#define andgather (sysvars[15].value)
#define orgather (sysvars[16].value)
#define anduse (sysvars[17].value)
#define oruse (sysvars[18].value)
#define allinv (sysvars[19].value)
#define ifftrans (sysvars[20].value)
#define timeout (sysvars[21].value)
#define forever (sysvars[22].value)
#define echo (sysvars[23].value)
#define tellme (sysvars[24].value)
#define syntax (sysvars[25].value)
#define eq (sysvars[26].value)
#define minimal (sysvars[27].value)
#define topsift (sysvars[28].value)
#define twosift (sysvars[29].value)
#define stuse (sysvars[30].value)
#define szsave (sysvars[31].value)
#define implock (sysvars[32].value)
#define pcheck (sysvars[33].value)
#ifdef DEBUG
#define trace (sysvars[34].value)
#define dflag (sysvars[35].value)
#endif

#define ANT(p) ((p)[0])       /*  List of antecedent formulas               */
#define CONS(p) ((p)[1])      /*  Consequent                                */
#define IMPS(p) ((p)[2])      /*  List of imps                              */
#define IFFS(p) ((p)[3])      /*  List of iffs                              */
#define ATOMS(p) ((p)[4])     /*  List of atoms                             */
#define TRANS(p) ((p)[5])     /*  List of transferred formulas              */
#define ORFLAG(p) ((p)[6])    /*  Orflag                                    */
#define EFLAG(p) ((p)[7])     /*  Eflag                                     */
#define WORKF(p) ((p)[8])     /*  Current formula - info for redo()         */
#define UNIVSA(p) ((p)[9])    /*  List of active universal fmlas            */
#define UNIVSD(p) ((p)[10])   /*  List of dormant universal fmlas           */
#define PRM(p)    ((p)[11])   /*  Next parameter to use                     */
#define REDOFLAG(p) ((p)[12]) /*  Information for redo()                    */
#define PREM1(p) ((p)[13])    /*  First premiss, or list of bindings        */
#define PREM2(p) ((p)[14])    /*  Second premiss, or saved sp3              */
#define FSTACK(p) ((p)[15])   /*  Saved sp                                  */
#define FFSTACK(p) ((p)[16])  /*  Saved fsp                                 */
#define VARS(p) ((p)[17])     /*  List of number of variables + variables   */
#define SAVE(p) ((p)[18])     /*  SAVE stack for storing solutions          */
#define SPOINT(p) ((p)[19])   /*  Stack pointer for SAVE stack              */
#define STORE(p) ((p)[20])    /*  List of saved solutions                   */
#define SFLAG(p) ((p)[21])    /*  Flag used by sift routines                */

#define FRAME 22L

#define var(p) ((p)[0]>0)
#define param(p) ((p)[0]==0)


#define invar(p)  (infree2+2*(p))

/* the p:th free input variable */



#define STACKSIZE (100000)         /* all sizes in longs */ 
#define TEXTSIZE  (50000)
#define FSTACKSIZE (100000)

/* Apart from stack.c, these constants are used by printing routines
   in print.c. */



extern long *sp;       /* in stack.c */
extern long *sp2;
extern long *sp3;
extern long *sp4;
extern long *fsp;
extern long *dsp;
extern long *fstack;
extern long *stack;
extern long textbuf[];
extern char *textp;
extern long *max;
extern long *max3;
extern long *fmax;
extern long stacksz;
extern long fstacksz;


extern long blocksnum;

extern int cflag;     /* in main.c */
extern int aflag;

extern long *infree;  /* in formula.c */
extern long *infree2; 
extern long sublength;


extern long *savelist;   /* in prove.c */


typedef long *formula;  /* points to a pair <&baseformula,&subtable> */
typedef long *term;     /* points to one of the three types of term */
typedef long *basefmla; /* described in formula.c */
typedef long *subterm;  /* points to a pair <&baseterm,&subtable> */
typedef long *subtab;   /* of length sublength; indexing gives substitution */
typedef long *list;     /* sometimes 3-cells */
typedef long *variable; /* a pair <restriction+1,&value> */
typedef long *frame;    /* described above */
typedef long *baseterm; /* described in formula.c */
