;; FRAPPS - user.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; A rather "fancier" version of the simple search procedure in the manual.
;; Only differences are statistics and various options.
;; Should be integrated with the "run-demo" procedure.

(defun user-search ()
  (if *kcl-bug* (read-line))
  ;; This gets around an annoying bug in Kyoto Common Lisp.
  (real-user-search)
  )

(setq *answer-subsume* T)
(setq *weak-subsume* nil)
(setq *subsume-degree* 'full)
(setq *active-fwd-subsume* T)

;; List of global variables used only in these procedures
;; (not part of FRAPPS);; for session management:

(defun list-user-globals ()
  (list (list ;; subsumbtion-related flags:
	 *answer-subsume* *weak-subsume* *subsume-degree* *active-fwd-subsume*
	 *back-subsume* *fwd-subsume*)
	(list generated pairs pops fwd-sub-count)
	))

(defun restore-user-globals (list)
  (let ((sub-flags (first list))
	(counts	(second list)))
       (setq *answer-subsume* (nth 0 sub-flags))
       (setq *weak-subsume* (nth 1 sub-flags))
       (setq *subsume-degree* (nth 2 sub-flags))
       (setq *active-fwd-subsume* (nth 3 sub-flags))
       (setq *back-subsume* (nth 4 sub-flags))
       (setq *fwd-subsume* (nth 5 sub-flags))

       (setq generated (nth 0 counts))
       (setq pairs (nth 1 counts))
       (setq pops (nth 2 counts))
       (setq fwd-sub-count (nth 3 counts))
       ))


(defun real-user-search ()
  (cond
   ((not *queue-on*)
    (format t " ~% These search procedures all use the priority queue.")
    (format t " ~% Set *queue-on* to T and reload the base-set of clauses.")
    (format t "~2%")
    )
   ((not *priority-queue*)
    (format t " ~% The priority queue is empty.")
    )
   (T
    (if *back-subsume* (setq *print-inference-errors* nil))
    ;; so that a message is NOT printed when resolve attempts to use
    ;; a clause deactivated by backwards subsumption.
    (let ((clause-pair 'not-empty)
	  (resolvent-list nil)
	  (current-level 0)
	  (previous-empty *empty-cls-ids*)
	  (previous-answers *answer-cls-ids*)
	  )
	 (do () ((not clause-pair))
	   (cond ((setq clause-pair (pop-priority-queue))
	     (setq resolvent-list 
		    (user-resolve (first clause-pair) (second clause-pair)))

	     ;; count how many resolvents there are:
	     (setq generated (+ generated (length resolvent-list)))

	     ;; delete unwanted resolvents:
	     (setq resolvent-list (user-delete resolvent-list))

	     (cond ((first resolvent-list)
		    (setq pairs (1+ pairs))
		    ;; (setq pairs-stop (1+ pairs-stop))
		    ))

	     (setq pops (1+ pops))

	     ;; The order in which the following is done is VERY important:

	     ;; For example, backwards subsumption has to go BEFORE
	     ;; the resolvents are integrated
	     ;; (otherwise they will all subsume themselves).

	     (dolist (resolvent resolvent-list)
		     (if *fwd-subsume*
			 (cond
			  ((car
			    (delete-fwd-sub-resolvents
			     (list resolvent) :active *active-fwd-subsume*
			     :degree *subsume-degree* :weak *weak-subsume*
			     :answer *answer-subsume*))
			   (if *back-subsume*
			       (deactivate-back-sub-nodes
				(list resolvent)
				:degree *subsume-degree* :weak *weak-subsume*
				:answer *answer-subsume*))
			   (integrate-clause resolvent)
			   (if *unit-conflict* (unit-conflict *last-id*))
			   )
			  (T (setq fwd-sub-count (1+ fwd-sub-count)))
			  )
			 (progn
			  (if *back-subsume*
			      (deactivate-back-sub-nodes
			       (list resolvent)
			       :degree *subsume-degree* :weak *weak-subsume*
			       :answer *answer-subsume*))
			  (integrate-clause resolvent)
			  (if *unit-conflict* (unit-conflict *last-id*))
			  )))
	     (cond (resolvent-list
		    (if (< current-level *depth*)
			(format t "~2% Reached level ~d: " 
				(setq current-level *depth*))
			)
		    (format t "~d " *last-id*)
		    )
		   (T (format t "."))
		   )
	     (force-output)
	     ))
	     (cond
	      ((not clause-pair)
	       (if (and (null *empty-cls-ids*) (null *answer-cls-ids*))
		   (format t "~% Was unable to find new empty clauses or answer clauses."))
	       (return))
	      ((or *empty-cls-ids* *answer-cls-ids*)
	       (if *empty-cls-ids*
		   (format t "~% Found empty clause(s), node(s): ~d"
			   *empty-cls-ids*))
	       (if *answer-cls-ids*
		   (progn
		    (format t "~2% Found answer clause(s), node(s) ~d :"
			    *answer-cls-ids*)
		    (dolist (x *answer-cls-ids*)
			    (format t "~% ")
			    (print-node-clause x)
			    )
		    ))
	       (setq previous-empty
		     (union previous-empty *empty-cls-ids*))
	       (setq previous-answers
		     (union previous-answers *answer-cls-ids*))
	       (format t "~2% Continue the search?")
	       (cond
		((user-choice)
		 ;; "Fool" main loop into thinking no answer clauses
		 ;; and no empty clauses:
		 (setq *empty-cls-ids* nil)
		 (setq *answer-cls-ids* nil)
		 (format t " ")
		 )
		(T (return)))
	       )
	      ;; ((eq pairs-stop 100)
	       ;; (format t "~% Successfully resolved 100 pairs. Continue?")
	       ;; (cond
		;; ((user-choice)
		 ;; (setq pairs-stop 0)
		 ;; (format t " "))
		;; (T (return))
		;; ))
	      ))
	 ;; Restoring correct values:
	 (setq *empty-cls-ids* previous-empty)
	 (setq *answer-cls-ids* previous-answers)
	 )
    (format t "~% End of search:")
    (print-search-stats)
    (values)
    )))

(defun print-search-stats ()
  (format t "~%      Pairs popped from queue: ~d" pops)
  (format t "~%      Clause pairs resolved: ~d" pairs)
  (format t "~%      Resolvents generated: ~d" generated)
  (format t "~%      Resolvents integrated: ~d~%"
	  (- *last-id* (length *base-set*)))
  (if *fwd-subsume*
      (format t "~%      Resolvents forwards subsumed: ~d~%" fwd-sub-count))
  (if *empty-cls-ids*
      (format t "~% Empty clause(s): ~d" *empty-cls-ids*))
  (if *answer-cls-ids*
      (format t "~% Answer clause(s): ~d" *answer-cls-ids*))
  (if *priority-queue*
      (format t "~2% Run \"(user-search)\" to resume this search.")
      (format t "~% Priority queue empty. Exhausted this search space.")
      )
  (values))

 
(defun user-delete (list)
  (delete-taut-resolvents list))

(defun user-resolve (id1 id2)
  (resolve id1 id2))  ;; General resolution

;; (setq *max-length* 5) ;; Specify maximum number of literals allowed
;; (setq *max-complexity* 5) 

(defun unit-conflict (rslvnt-id)
  (if (= (clause-length (get-node-clause rslvnt-id)) 1)
      (let* ((unit-cls-ids (gethash 1 *cls-length-db*))
	     (rslv-rslts nil))
	    (dolist (unit-cls-id unit-cls-ids nil)
		    (cond
		     ((< unit-cls-id rslvnt-id)
		      (setq rslv-rslts (binary-resolve rslvnt-id unit-cls-id))
		      (cond
		       (rslv-rslts 
			(format t "~% UNIT CONFLICT found proof at ~d.~%"
				(integrate-clause-list rslv-rslts))
			(setq generated (1+ generated))
			))))
		    (if *empty-cls-ids*
			(return *empty-cls-ids*))
		    ))))

