;; FRAPPS - tpmisc.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;      ====> FRAPPS Miscellaneous functions <====

;;;;  This file contains functions that could be used by other
;;;;  functions at any level.

;;;;		NOTE: Includes ANSWER-LITERAL primitives.

;;		========================================


(defun set-equalp (s1 s2)
  (if (subsetp s1 s2 :test #'equal)
      (subsetp s2 s1 :test #'equal)
      ))

;; "FLATTEN" receives a list, and returns the list after "flattening" it.
;; Does NOT flatten variables, if it finds them.

(defun flatten (lst)
  (cond
   ((atom lst) lst)
   ((var-p (car lst))
    (cons (car lst) (flatten (cdr lst))))
   ((listp (car lst))
    (append (flatten (car lst)) (flatten (cdr lst))))
   (T (cons (car lst) (flatten (cdr lst))))
   ))

;; (defun add-to-set (x set)
  ;; (if (member x set :test #'equal)
      ;; set
      ;; (cons x set)))

;;  generate a "table" of the k-combinations given "n" and "k":

(defun gen-k-combs (n k)
  (let ((combn-tbl (make-array (list (choose n k) k) :initial-element -1))
	(j (1- k)))
    (dotimes (i k)
	     (setf (aref combn-tbl 0 i) (1+ i)))
    (do ((cur-row 1 (1+ cur-row)))
	((= cur-row (choose n k)) combn-tbl)
	(setq j (1- k))
	(do ()
	    ((/= (aref combn-tbl (1- cur-row) j) (+ (- n k) j 1)))
	    (setq j (1- j)))
	(dotimes (i j)
		 (setf (aref combn-tbl cur-row i) (aref combn-tbl (1- cur-row) i)))

	(setf (aref combn-tbl cur-row j) (1+ (aref combn-tbl (1- cur-row) j)))

	(do  ((i (1+ j) (1+ i)))
	     ((> i (1- k)))
	     (setf (aref combn-tbl cur-row i) (1+ (aref combn-tbl cur-row (1- i))))))))

;;  compute "n choose k" -- n!/[k! * (n-k)!] -- given "n" and "k"

(defun choose (n k)
  (/ (factorial n) (* (factorial k) (factorial (- n k)))))

;;  compute "n-factorial" -- n! -- given "n"
;;
;;  NOTE: assumes "n" >= 0

(defun factorial (n)
  (cond
    ((= n 0) 1)
    (T (* n (factorial (1- n))))))


(defun find-sld-resolvents (def-cls-id-list neg-consq-cls-id)
  (let ((resolvent-list (get-nodes-downto-level *depth*))
	(sld-node-id-list nil)
	(def-cls-parents nil)
	(non-def-cls-parents nil))
    (dolist (resolvent resolvent-list sld-node-id-list)


	    (setq def-cls-parents
		  (intersection def-cls-id-list (node-info-parents resolvent)))
	    (setq non-def-cls-parents
		  (set-difference (node-info-parents resolvent)
						      def-cls-parents)) 
	    

	    (if (and (eq (length def-cls-parents) 1)
		     (eq (length non-def-cls-parents) 1)
		     (or (member (first non-def-cls-parents) sld-node-id-list)
			 (eq (first non-def-cls-parents) neg-consq-cls-id)))
		(push (node-info-id resolvent) sld-node-id-list)))))

;; get-vars returns a list of the variables ocurring in l:

; (defun get-vars (l)
  ; (cond
   ; ((atom l) nil)
   ; ((var-p l) (list l))
   ; (T (remove-duplicates
	; (append (get-vars (car l)) (get-vars (cdr l))) :test #'equal))
   ; ))


;;  ===========================================================================
;;  =                                                                         =
;;  =                  TAUTOLOGY DETECTION FUNCTION                           =
;;  =                                                                         =
;;  ===========================================================================


;;  determine whether a given clause is a tautology;
;;  if it is a tautology, then non-NIL is returned, otherwise NIL is returned

;;  NOTE: the input to this function is expected to be a clause. (NEW)

(defun taut-p (cls)
  (let* ((cls-pred-list (bld-pred-list cls))
	 (len-cls-pred-list (length cls-pred-list)))
	(do* ((sub-list-index 0 (1+ sub-list-index))
	      (cls-pred-sub-list (nth sub-list-index cls-pred-list)
				 (nth sub-list-index cls-pred-list))
	      (sub-list-pred (first cls-pred-sub-list)
			     (first cls-pred-sub-list))
	      (pos-lit-sub-list (second cls-pred-sub-list)
				(second cls-pred-sub-list))
	      (neg-lit-sub-list (third cls-pred-sub-list)
				(third cls-pred-sub-list))
	      (pos-lit nil)
	      (taut-flag nil))
	     
	     ((or taut-flag (= sub-list-index len-cls-pred-list))
	      (if taut-flag t nil))
	     
	     (cond
	      ((not (ans-lit-p (list sub-list-pred)))
	       (dolist (pos-lit-indx pos-lit-sub-list)
		       (setq pos-lit (nth (1- pos-lit-indx) cls))
		       (dolist (neg-lit-indx neg-lit-sub-list)
			       (if (equal pos-lit
					  (rest (nth (1- neg-lit-indx) cls)))
				   (return (setq taut-flag t))))
		       (if taut-flag (return nil))))))))



;;;;  ============== Answer Literal Primitives =========================


;;  determines whether the given literal in an "answer" literal or not;
;;  if so, then "t" is returned, otherwise "nil" is returned

;; Error will occur if first element of "lit" is not an atom.

(defun ans-lit-p (lit)
  (if (and (>= (length (string (first lit))) 6)
	   (string-equal (first lit) "ANSWER"
			 :end1 6))
      T nil))

(defun ans-pred-p (pred)
  (if (and (>= (length (string pred)) 6)
	   (string-equal pred "ANSWER"
			 :end1 6))
      T nil))

(defun remove-ans-preds (list)
  (let ((result nil))
       (dolist (p list)
	       (if (not (ans-pred-p p))
		   (setq result (cons p result))
		   ))
       result))

;;  determines whether the given literal list contains an answer literal,
;;  if so, then "t" is returned, otherwise "nil" is returned

(defun contains-ans-lit-p (lit-list)
  (dolist (lit lit-list nil)
	  (if (ans-lit-p lit)
	      (return t))))


;;  determines the number of answer literals found in the given literal list;
;;  if none are found, then 0 (zero) is returned, otherwise the number of
;;  answer literals appearing in the literal list is returned

(defun num-ans-lits (lit-list)
  (let ((n 0))
       (dolist (lit lit-list n)
	       (if (ans-lit-p lit)
		   (setq n (1+ n))))))


;;  determines the length of the given clause (lit. list) EXCLUDING
;;  any answer literals which appear in the clause

(defun clause-length (lit-list)
  (- (length lit-list) (num-ans-lits lit-list)))


;; determines whether a clause contains only answer literals
;; The empty clause should NOT be considered an answer clause.

(defun answer-clause-p (clause)
  (if (null clause) nil (ans-clause-p clause)))

(defun ans-clause-p (lit-list)
  (if (null lit-list) T
      (if (ans-lit-p (car lit-list)) (ans-clause-p (cdr lit-list))
	  nil)))

;; returns list after removing the answer literals in it (new):

(defun remove-ans-lits (list)
  (let ((lit-list nil))
       (dolist (lit list lit-list)
	       (if (not (ans-lit-p lit))
		   (setq lit-list (append lit-list (list lit)))
		   ))))

;;;;  =============== End of Answer Literal Primitives ==================


;;;; =======> OLD STUFF...

;;  strips the "sign" from the given literal "lit"; that is, given
;;  a positive or negative literal, a "signless" atom is returned

(defun strip-sign (lit)
  (if (neg-lit-p lit)
      (rest lit)
    lit))


;;  changes the "sign" of the given literal

(defun change-sign (lit)
  (if (neg-lit-p lit)
      (rest lit)
    (cons 'not lit)))

(defun def-clause-list (l)
  (dolist (x l) (def-clause x))
  )

