;; FRAPPS - subsume.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; The first two functions repeat much of the code already in "delstrats.lsp"
;; Included for user's convenience and enjoyment. Decided not to simplify
;; this code further for efficiency purposes...

;; Whether answer literals are considered or not is determined by
;; the key literal :answer

;; Identify forwards-subsuming nodes for a single clause:

(defun get-ids-that-subsume-clause
  (clause &key (active T) (degree 'full) (weak nil) (answer T))
  ;; the key parameter "active" determines whether deactivated
  ;; subsumers are also returned. If T, only ACTIVE clauses are considered.
  (let ((subsmptn-test nil)
	(set-operation nil)
	(rslvnt-pred-list nil)
	(subsuming-cls-pred-list nil)
	(cls-id-list nil)
	(candidate-id-list nil)
	(lit-list nil)
	(results nil)
	(len nil)
	(rem-lit-list nil))
       (cond
	((eq degree 'full)
	 (setq subsmptn-test #'subsumes-p)
	 (setq set-operation #'union))
	((eq degree 'instances)
	 (setq subsmptn-test #'cls-instance-p)
	 (setq set-operation #'intersection))
	((eq degree 'variants)
	 (setq subsmptn-test #'cls-variant-p)
	 (setq set-operation #'intersection))
	(T (err-messg-subsume "get-ids-that-subsume-clause")))
       (cond
	(subsmptn-test
	 (cond (answer (setq lit-list clause)
		       (setq len (clause-length lit-list)))
	       (T (setq lit-list (remove-ans-lits clause))
		  (setq len (length lit-list))))
	 (cond
	  ((eq set-operation #'intersection)
	   (setq candidate-id-list
		 (intersection (get-ids-of-length len)
			       (ret-clauses-cont-more-general-lits (first lit-list))))
	   (setq rem-lit-list (rest lit-list)))
	  (T (setq candidate-id-list nil)
	     (setq rem-lit-list lit-list)))
	 (dolist (lit rem-lit-list)
		 (setq candidate-id-list
		       (apply set-operation
			      (list candidate-id-list
				    (ret-clauses-cont-more-general-lits lit)))))
	 (cond
	  ((not (null candidate-id-list))
	   (if
	    (and weak (eq degree 'full) (< len *max-db-length*))
	    (let ((new-candidate-ids nil))
		 ;; In this case only clauses of length less or equal than the
		 ;; possibly subsumed clause are tested:
		 (dotimes (cls-length len)
			  (setq new-candidate-ids
				(append new-candidate-ids
					(intersection candidate-id-list
						      (get-ids-of-length (1+ cls-length))
						      ))))
		 ;;;; (format t "~%Old Candidates: ~d~%" candidate-id-list)
		 (setq candidate-id-list new-candidate-ids)
		 ))
	   (cond
	    ((eq degree 'full)
	     ;; This pruning is not worth it in other cases!!! (it would work).
	     ;; maybe in the case of constraints it is always worth doing
	     ;; this...
	     ;;;; (format t "~%Candidates: ~d~%" candidate-id-list)
	     (setq rslvnt-pred-list (get-all-pred-syms lit-list))
	     (setq cls-id-list candidate-id-list)
	     (dolist (cls-id cls-id-list)
		     (setq subsuming-cls-pred-list
			   (if answer (get-cls-preds cls-id)
			       (remove-ans-preds (get-cls-preds cls-id))
			       ))
		     (if (not (eq (set-difference subsuming-cls-pred-list
						  rslvnt-pred-list)
				  nil))
			 (setq candidate-id-list
			       (remove cls-id candidate-id-list))
			 ))))
	   ;;;; (format t "~%Final Candidates: ~d~%" candidate-id-list)

	   ;; Now have 4 cases, depending on answer and active flags:
	   ;; Want to avoid checking the flags at each iteration of the loop:
	   (if candidate-id-list
	   (cond
	    (active
	     (if answer
		 ;; (and (answer active))
		 (dolist (cls-id candidate-id-list nil)
			 (if (get-node-active cls-id)
			     (if (not (eq (apply subsmptn-test
						 (list
						  (get-node-clause cls-id)
						  lit-list))
					  'FAIL))
				 (setq results (cons cls-id results))
				 )))
		 ;; (and (not answer) active)
		 (dolist (cls-id candidate-id-list nil)
			 (if (get-node-active cls-id)
			     (if (not (eq (apply subsmptn-test
						 (list
						  (remove-ans-lits (get-node-clause cls-id))
						  lit-list))
					  'FAIL))
				 (setq results (cons cls-id results))
				 )))
		   ))
	    (T
	     (if answer
		 ;; (and answer (not active))
		 (dolist (cls-id candidate-id-list nil)
			 (if (not (eq (apply subsmptn-test
					     (list
					      (get-node-clause cls-id)
					      lit-list))
				      'FAIL))
			     (setq results (cons cls-id results))
			     ))
		 ;; (and (not answer) (not active))
		 (dolist (cls-id candidate-id-list nil)
			   (if (not (eq (apply subsmptn-test
					       (list
						(remove-ans-lits (get-node-clause cls-id))
						lit-list))
					'FAIL))
			       (setq results (cons cls-id results))
			       ))
		 ))))))
	 results)
	(T (values))
	)))


;;  ==> Get Backward Subsumed Nodes

;;  Recovers ids subsumed by the given clause list, does NOT deactivate them.

(defun get-ids-sub-by-clause-list
  (clause-list &key (active T) (degree 'full) (weak nil) (answer T))
  (let ((subsmptn-test nil)
	(lit-list nil)
	(candidate-id-list nil)
	(del-list nil)
	(len nil)
	(cum-del-list nil))
       (cond
	((eq degree 'full)
	 (setq subsmptn-test #'subsumes-p))
	((eq degree 'instances)
	 (setq subsmptn-test #'cls-instance-p))
	((eq degree 'variants)
	 (setq subsmptn-test #'cls-variant-p))
	(t (err-messg-subsume "get-ids-sub-by-clause-list")))
       (cond
	(subsmptn-test
	 (dolist (clause clause-list cum-del-list)
		 (cond
		  (answer (setq lit-list clause)
			  (setq len (clause-length clause)))
		  (T (setq lit-list (remove-ans-lits clause))
		     (setq len (length lit-list))))
		 (setq candidate-id-list
		       (ret-clauses-cont-instance-lits (first lit-list)))
		 (if (not (eq degree 'full))
		     (setq candidate-id-list
			   (intersection candidate-id-list
					 (get-ids-of-length (clause-length lit-list))
					 )))
		 (dolist (lit (rest lit-list))
			 (setq candidate-id-list
			       (intersection candidate-id-list
					     (ret-clauses-cont-instance-lits lit))))
		 (setq candidate-id-list
		       (set-difference candidate-id-list cum-del-list))

		 ;;;; (format t "~%Candidates: ~d~%" candidate-id-list)
		 (if
		  (and weak (eq degree 'full) (> len 1))
		  (let ((new-candidate-ids nil))
		       ;; In this case only clauses of length greater than the
		       ;; possibly subsuming clause are tested:
		       (dotimes (cls-length (1+ (- *max-db-length* len)))
				(setq new-candidate-ids
				      (append new-candidate-ids
					      (intersection candidate-id-list
							    (get-ids-of-length (+ cls-length len))
							    ))))
		       (setq candidate-id-list new-candidate-ids)
		       ))
		 ;;;; (format t "~%New Candidates: ~d~%" candidate-id-list)

		 (setq del-list nil)

		 (if (not (null candidate-id-list))
		     ;; Now have 4 cases, depending on the answer and active flags:
		 (cond
		  (active
		   (if answer
		       ;; (and active answer)
		       (dolist (candidate-id candidate-id-list)
			       (if (get-node-active candidate-id)
				   (if (not (eq (apply subsmptn-test
						       (list lit-list
							     (get-node-clause candidate-id)))
						'FAIL))
				       (setq del-list (cons candidate-id del-list)))
				   ))
		       ;; (and active (not answer))
		       (dolist (candidate-id candidate-id-list)
			       (if (get-node-active candidate-id)
				   (if (not (eq (apply subsmptn-test
						       (list lit-list
							     (remove-ans-lits
							      (get-node-clause candidate-id))))
						'FAIL))
				       (setq del-list (cons candidate-id del-list)))
				   ))
		       ))
		  (T
		   (if answer
		       ;; (and (not active) answer)
		       (dolist (candidate-id candidate-id-list)
			       (if (not (eq (apply subsmptn-test
						   (list lit-list
							 (get-node-clause candidate-id)))
					    'FAIL))
				   (setq del-list (cons candidate-id del-list)))
			       )
		       ;; (and (not active) (not answer))
		       (dolist (candidate-id candidate-id-list)
			       (if (not (eq (apply subsmptn-test
						   (list lit-list
							 (remove-ans-lits
							  (get-node-clause candidate-id))))
					    'FAIL))
				   (setq del-list (cons candidate-id del-list))))
		       ))))
		 (if del-list
		     (setq cum-del-list (append cum-del-list del-list)))))
	(T (values))
	)))

;; Abbreviations:

;; NOTE: If "active" is T then only active clauses are returned.

(defun get-ids-sub-by-clause
  (c &key (active nil) (degree 'full) (weak nil) (answer T))
  (get-ids-sub-by-clause-list
   (list c) :active active :degree degree :weak weak :answer answer))

(defun gisc
  (c &key (active T) (degree 'full) (weak nil) (answer T))
  (get-ids-sub-by-clause-list
   (list c) :active active :degree degree :weak weak :answer answer))

(defun gitsc
  (c &key (active T) (degree 'full) (weak nil) (answer T))
  (get-ids-that-subsume-clause
   c :active active :degree degree :weak weak :answer answer))

;; When ids are used as arguments, have to remove them from the
;; output, since all clauses subsume themselves!!!

(defun get-ids-that-subsume-node
  (id &key (active T) (degree 'full) (weak nil) (answer T))
  (remove id
	  (get-ids-that-subsume-clause
	   (get-clause id)
	   :active active :degree degree :weak weak :answer answer)
	  ))

(defun gitsn
  (id &key (active T) (degree 'full) (weak nil) (answer T))
  (get-ids-that-subsume-node 
   id :active active :degree degree :weak weak :answer answer))

(defun get-ids-sub-by-node
  (id &key (active T) (degree 'full) (weak nil) (answer T))
  (remove id
	  (get-ids-sub-by-clause-list
	   (list (get-clause id))
	   :active active :degree degree :weak weak :answer answer)
	  ))

(defun gisn
  (id &key (active T) (degree 'full) (weak nil) (answer T))
  (get-ids-sub-by-node
   id :active active :degree degree :weak weak :answer answer))


;;  ==========================================================================
;;
;;
;;		SUBSUMPTION DEGREE DETECTION FUNCTIONS
;;
;;
;;  ===========================================================================


;;  ==> VARIANT DETECTION
;;
;;  determines if cls1 and cls2 are VARIANTS of each other, where both cls1 
;;  and cls2 are LITERAL LISTS. If cls1 and cls2 are variants, then "T" is 
;;  returned, otherwise "FAIL" is returned.
;;
;;  cls1 and cls2 are LISTS OF LITERALS... not quite. They are single
;;  literals more often than not.

;; This alone is not enought for real variant detection:
;; Clauses should be treated as SETS! A new function, new-variant-p,
;; similar to this one, is called by the CLAUSE variant detection algorithm,
;; now called cls-variant-p. ("new-variant-p" does not rename vars.
;; since "cls-variant-p" does.)
;; 
;; A similar story goes for instance-p.

(defun variant-p (cls1 cls2)
  (let* ((cls2-stdzed (stndze-vars-apart cls1 cls2))
	 (bind-list (unify cls1 cls2-stdzed))
	 (term-list nil))
	(cond
	 ((not (eq bind-list 'FAIL))
	  (dolist (bind-elt bind-list (if (equal (subst-s-exp cls1 bind-list)
						 cls2-stdzed)
					  T
					  'FAIL))
		  (if (var-p (rest bind-elt))
		      (if (not (member (rest bind-elt) term-list :test #'equal))
			  (setq term-list (cons (rest bind-elt) term-list))
			  (return 'FAIL))
		      (return 'FAIL))))
	 (T 'FAIL))))



;;  ==> INSTANCE DETECTION

;;  determines if exp2 is an INSTANCE of exp1; if so, then a substitution S
;;  is returned such that (exp1)(S) = exp2; otherwise "FAIL" is returned
;;
;;  NOTES: instance substitution S *COULD* potentially be "nil"
;;      
;;	this function essentially performs "one-way" matching
;;
;;	exp1 and exp2 are both *either* INDIVIDUAL LITERALS *OR*
;;	LISTS OF LITERALS (i.e.- a clause)

(defun instance-p (exp1 exp2 &optional bindings)
  (cond 
    ((equal exp1 exp2) 
     bindings)
    ((var-p exp1)
     (instantiate-var exp1 exp2 bindings))
    ((or (var-p exp2) (not (listp exp1)) (not (listp exp2))) 
     'FAIL)
    ((not (eq (setq bindings (instance-p (car exp1) (car exp2) bindings))
	      'FAIL))
     (instance-p (cdr exp1) (cdr exp2) bindings))
    (T 'FAIL)))

;;  determines if the given variable can be instantiated with the given
;;  expression (or if it is ALREADY instantiated with the given expression);
;;  if so, then the (possibly updated) binding list is returned; otherwise
;;  "FAIL" is returned

(defun instantiate-var (var exp bindings)
  (let ((val (find-binding var bindings)))
    (cond 
      ((and val (equal val exp))
       bindings)
      ((and (null val) (free-in var exp bindings) exp)  ;; exp can't be nil
       (cons (cons var exp) bindings))
      (T 'FAIL))))



;;  ==> "FULL" SUBSUMPTION DETECTION
;;
;;  determines if the first clause, "cls1", subsumes the second clause, "cls2",
;;  if so, "T" is returned, otherwise "FAIL" is returned
;; 
;;  NOTE: both "cls1" and "cls2" are lists of literals

(defun subsumes-p (cls1 cls2)
  (let ((cls1-vars (remove-duplicates (bld-var-list cls1) :test #'equal))
	(cls2-vars (remove-duplicates (bld-var-list cls2) :test #'equal)))

    (cond 
      ((and (null cls1-vars) (null cls2-vars))
       (if (subsetp cls1 cls2 :test #'equal)
	   T
	 'FAIL))
      (T (do ((neg-inst-cls2 (if (not (null cls2-vars))
				 (subst-s-exp cls2
					      (mapcar #'(lambda (var)
							  (cons var (gentemp)))
						      cls2-vars))
			       cls2))
	      (rslvnt-lst (list cls1))
	      (empty-cls-fnd nil)
	      (rslvnt-lst-empty nil)
	      (ord-rslvnt-lst nil)
	      (tmp-lst nil nil))
	     
	     ((or empty-cls-fnd rslvnt-lst-empty)
	      (if empty-cls-fnd
		  t
		'FAIL))

	     (dolist (rslvnt rslvnt-lst)
		     (dolist (lit neg-inst-cls2)
			     (setq tmp-lst 
				   (append tmp-lst
					   (setq ord-rslvnt-lst (ord-reslve rslvnt lit))))
			     (if (and (not (null ord-rslvnt-lst))
				      (eq (first ord-rslvnt-lst) '()))
				 (return (setq empty-cls-fnd T)))

			     )
		     (if empty-cls-fnd
			 (return nil)))
	     
	     (cond
	       ((null tmp-lst)
		(setq rslvnt-lst-empty T))
	       ((not empty-cls-fnd)
		(setq rslvnt-lst tmp-lst))))))))


;;  compute the "ordered" resolvent obtainable by resolving
;;  the given literal "lit" against the first (i.e. - "leftmost")
;;  literal of the clause "cls"
;;
;;  NOTE: the literal "lit" is ASSUMED to be complementary to the
;;  leftmost literal of "cls" -- the negative literal involved is
;;  IMPLICITLY negated (i.e. - is negative, but has no "not" symbol
;;  as its first element)
;;
;;  if a resolvent is produced, it is returned as a single element of a list

(defun ord-reslve (cls lit)
  (let ((unify-rslts nil))
       (cond
	((equal (first cls) lit)
	 (list (rest cls)))
	(T (if (not (eq (setq unify-rslts
			      (unify (first cls) lit))
			'FAIL))
	       (list (merge-left (subst-s-exp (rest cls) unify-rslts)))
	       nil)))))

;;  ============== END OF (OLD) SUBSUMPTION DETECTION FUNCTIONS ==============

(defun cls-instance-p (cls1 cls2)
  (cls-instance-p1 cls1 (stndze-vars-apart cls1 cls2)))

(defun cls-variant-p (cls1 cls2)
  (cls-variant-p1 cls1 (stndze-vars-apart cls1 cls2)))


(defun cls-instance-p1 (cls1 cls2 &optional bindings)
  (cond
   ((and (null cls1) (null cls2)) bindings)
   ((or (null cls1) (null cls2)) 'FAIL)
   (T (dolist (lit1 cls1 'FAIL)
	      (let ((new-bind nil)
		    (return-bind nil))
		   (cond
		    ((not (eq (setq new-bind
				    (instance-p lit1 (first cls2) bindings))
			      'FAIL))
		     (if (not (eq
			       (setq return-bind
				     (cls-instance-p1
				      (remove lit1 cls1 :test #'equal)
				      (cdr cls2)
				      new-bind
				      ))
			       'FAIL))
			 (return return-bind)
			 ))
		    ))
	      ))))

(defun cls-variant-p1 (cls1 cls2 &optional bindings)
  (cond
   ((and (null cls1) (null cls2))
    bindings)
   ((or (null cls1) (null cls2)) 'FAIL)
   (T (dolist (lit1 cls1 'FAIL)
	      (let ((new-bind nil)
		    (return-bind nil))
		   (cond
		    ((not (eq (setq new-bind
				    (new-variant-p lit1 (first cls2)))
			      'FAIL))
		     (if (not (eq
			       (setq return-bind
				     (cls-variant-p1
				      (remove lit1 cls1 :test #'equal)
				      (cdr cls2)
				      new-bind
				      ))
			       'FAIL))
			 (return return-bind)
			 ))
		    ))
	      ))))

;; Like variant-p, but does not need to rename variables:

(defun new-variant-p (exp1 exp2)
  (let ((bind-list (unify exp1 exp2))
	(term-list nil))
       (cond
	((not (eq bind-list 'FAIL))
	 (dolist (bind-elt bind-list (if (equal (subst-s-exp exp1 bind-list)
						exp2)
					 T
					 'FAIL))
		 (if (var-p (rest bind-elt))
		     (if (not (member (rest bind-elt) term-list :test #'equal))
			 (setq term-list (cons (rest bind-elt) term-list))
			 (return 'FAIL))
		     (return 'FAIL))))
	(T 'FAIL)
	)))
