;; FRAPPS - sld.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Inference Strategies.
;; Shared by H-Frapps.

;; There was a bug with the old SLD-resolution version.
;; This, hopefully, fixes it.

;; This is the global variable for the SLD selection function:

(defvar *sld-selection-fn* 'leftmost-select-fn)

;;  ==> SLD Resolution inference strategy
;;
;; c1 and c2 are node-ids.

(defun sld-resolve (c1 c2)
  (let ((pos-lit nil)
	(selected-lit nil)
	(neg-cls-id nil)
	(def-cls-id nil)
	(cls1 (get-cls-info c1))
	(cls2 (get-cls-info c2))
	(unifier nil)
	(def-clause nil)
	(neg-clause nil)
	(rslvnt nil))
    (cond
      ((or (not cls1) (not cls2))
       (if *print-inference-errors* (determine-error c1 c2)))
      ((and (neg-cls-p (clause-lit-list cls1))
	    (setq pos-lit (def-cls-p (clause-lit-list cls2))))
       (setq neg-cls-id c1)
       (setq def-cls-id c2)
       (setq neg-clause (clause-lit-list cls1))
       (setq def-clause (clause-lit-list cls2))
       (setq selected-lit (apply *sld-selection-fn*
				 (list neg-clause)))
       )
      ((and (neg-cls-p (clause-lit-list cls2))
	    (setq pos-lit (def-cls-p (clause-lit-list cls1))))
       (setq neg-cls-id c2)
       (setq def-cls-id c1)
       (setq neg-clause (clause-lit-list cls2))
       (setq def-clause (clause-lit-list cls1))
       (setq selected-lit (apply *sld-selection-fn*
				 (list neg-clause)))
       ))
    (cond
      ((and neg-cls-id def-cls-id)
       (setq def-clause (stndze-vars-apart neg-clause def-clause))
       (cond
	((not (eq (setq unifier (unify (nth (1- pos-lit) def-clause)
				       (cdr (nth (1- selected-lit) neg-clause))))
		  'FAIL))
	 (setq rslvnt
	       (subst-s-exp
		(append
		 (butlast def-clause (1+ (- (length def-clause) pos-lit)))
		 (nthcdr pos-lit def-clause)
		 ;; (rmv-nth-lit poslit def-clause) ;; Probably less efficient.

		 (butlast neg-clause (1+ (- (length neg-clause) selected-lit)))
		 (nthcdr selected-lit neg-clause)
		 ;; (rmv-nth-lit selected-lit neg-clause)
		 )
		unifier))
	 (values
	  (list
	   (construct-resolvent-info
	    (merge-left rslvnt)	;; Deletes duplicates from right to left.
	    (list c1 c2) ;; Parents go in same order as the arguments were.
	    'br))
	  (list unifier)
	  ))
	(t nil)))
     (t nil))))


;;  the "selection function" evaluator is given the clause as input,
;;  and it returns the index of the next literal to resolve upon.

;;  ==> "leftmost" selection function
  
(defun leftmost-select-fn (clause)
  (cond
   ((null clause) 1)
   ((answer-clause-p clause) 1)
   ((ans-lit-p (car clause))
    (+ 1 (leftmost-select-fn (cdr clause))))
   (T 1)))


(defun rightmost-select-fn (clause)
  (+ 1 (- (length clause) (leftmost-select-fn (reverse clause)))
     ))

