;; FRAPPS - run-demo.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Depends on these two files, which can also be loaded
;; as an optional part of FRAPPS:

;; (load "searchfns.lsp")
;; (load "user.lsp")

;; variables for collecting statistics:

(defvar generated 0)
(defvar pairs 0)
(defvar pops 0)
(defvar fwd-sub-count 0)

;; Flags LOCAL to these procedures:

(defvar *back-subsume* nil) ;; back subsumption flag.
(defvar *fwd-subsume* nil) ;; forward subsumption flag.
(defvar *unit-conflict* nil) ;; unit conflict flag.

;; Have just one set of parameters for both forward and back subsumption:

(defvar *subsume-degree* 'full)	;; can be 'full, 'instances", or 'variants

(defvar *weak-subsume* nil)	;; If non-nil, subsumption only worries
				;; about subsumer clauses of length less than
				;; or equal to subsumed clause.

(defvar *answer-subsume* nil)	;; If non-nil, answer literals ARE
				;; considered in subsumption detection functs.

(defvar *active-fwd-subsume* T)	;; only active clauses will be used to forward
				;; subsume.

(defun run-demo ()
  (if *kcl-bug* (read-line))
  (let ((answer "")
	(sos-flag nil))
       (defun user-resolve (x y) (resolve x y))
       (setq *pair-select-function* 'gen-pair-select-fn)
       (format t "~% Search strategy:")
       (format t "~%     1: breadth-first")
       (format t "~%     2: depth-first-search")
       (format t "~%     3: unit")
       (format t "~%     4: input")
       (format t "~%     5: SLD~%")
       ;; (format t "~%     6: set-of-support")
       (format t "~%     0: Already set")
       (do ()
	   ((or (string-equal answer "0")
		(string-equal answer "1")
		(string-equal answer "2")
		(string-equal answer "3")
		(string-equal answer "4")
		(string-equal answer "5")))
	   (format t "~% Enter 0-5: ")
	   (setq answer (read-line))
	   )
       (format t "~%")
       (cond
	((string-equal answer "1") (set-breadth-costfn)) ;; defaults
	((string-equal answer "2") (set-depth-costfn))
	((string-equal answer "3") (set-unit-costfn))
	((string-equal answer "4") (set-input-costfn))
	((string-equal answer "5")
	 (defun user-resolve (x y)
		(sld-resolve x y))
	 (setq *pair-select-function* 'sld-pair-select-fn)
	 (set-breadth-costfn))
	;; ((string-equal answer "6") (set-sos-costfn))
	)
       (format t " Use set-of-support?")
       (cond
	((user-choice)
	 (setq sos-flag t)
	 (setq *cost-function-single-components*
	       (cons 'sos-single-costfn *cost-function-single-components*))
	 (setq *cost-function-single-weights*
	       (cons 1 *cost-function-single-weights*))
	 ))
       (if *hooked-version* (load-h-demo) (load-n-demo))
       
       (cond
	(sos-flag
	 (setq *cost-function-single-components*
	       (cdr *cost-function-single-components*))
	 (setq *cost-function-single-weights*
	       (cdr *cost-function-single-weights*))
	 ))
       (format t "~% Use back subsumption?")
       (cond 
	((user-choice)
	 (setq *back-subsume* T)
	 (format t "~% Print back subsumed clauses?")
	 (if (user-choice)
	     (setq *print-back-sub-clauses* T)
	     (setq *print-back-sub-clauses* nil)
	     )
	 )
	(T (setq *back-subsume* nil)))
       (format t "~% Use forward subsumption?")
       (if (user-choice)
	   (setq *fwd-subsume* T)
	   (setq *fwd-subsume* nil)
	   )
       (format t "~% Do unit conflict?")
       (if (user-choice)
	   (setq *unit-conflict* T)
	   (setq *unit-conflict* nil)
	   )
       (setq generated 0)
       (setq pairs 0)
       (setq pops 0)
       (setq fwd-sub-count 0)

       (format t "~% The initial set of clauses is:~%")

       (print-level 0)

       (format t "~% NOTE: Will use current \"user-delete\" as the deletion procedure.")
       (format t "~% Redefine it? (Enter \"n\" to begin search.)")
       (cond
	((user-choice)
	 (format t "~% Define \"user-delete (resolvent-list)\" as you wish")
	 (format t "~% and then run \"(user-search)\" ... ")
	 )
	(T (real-user-search))
	;; Do not call user-search directly, in order to avoid KCL bug.
	)
       )
  (values)
  )

(if (not *hooked-version*)
  (defun load-h-demo () nil))

(defun load-n-demo ()
  (let ((answer "")
	(filename ""))
       (format t "~% Demo test problems:")
       (format t "~%    1: Block Colors")
       (format t "~%    2: Square root of 2")
       (format t "~%    3: Circuits")
       (format t "~%    4: Murder Mystery")
       (format t "~%    5: Lewis Carroll Propositional Puzzle")
       (format t "~%    6: Primes Problem")
       (format t "~2%    7: Already Loaded")
       (format t "~%    0: Other~%")
       (do ()
	   ((or (string-equal answer "1")
		(string-equal answer "2")
		(string-equal answer "3")
		(string-equal answer "4")
		(string-equal answer "5")
		(string-equal answer "6")
		(string-equal answer "7")
		(string-equal answer "0")))
	   (format t "~% Enter 0-5: ")
	   (setq answer (read-line))
	   )
       (format t "~%")
       (cond
	((string-equal answer "1") (load-demo "blocks"))
	((string-equal answer "2") (load-demo "square"))
	((string-equal answer "3") (load-demo "circ1"))
	((string-equal answer "4") (load-demo "mystery"))
	((string-equal answer "5") (load-demo "boys"))
	((string-equal answer "6") (load-demo "primes"))
	((string-equal answer "7") (partial-reset))
	((string-equal answer "0")
	 (format t "~% Enter complete filename: ")
	 (do () ((not (equal filename "")))
	     (setq filename (read-line)))
	 (reset-frapps)
	 (load filename)
	 ))
       ))

