;; FRAPPS - prqmgmt.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Priority Queue Management
;; Shared by H-Frapps.

;; NOTE: To reinitialize the priority queue, it is simply set to nil.

;;  add an element to the priority queue
;;
;;  NOTE: cls-pair MUST be a clause-pair STRUCTURE

(defun add-elt-to-priority-queue (cls-pair)
  ;;;;(format t "~2% $$$$ ADDING ELEMENT to PRIORITY QUEUE--> ~d " cls-pair)
  ;;;;(read)
  (let
   ((target-priority (apply '+ (mapcar '* *cost-function-weights*
					  (clause-pair-priority-vector
					    cls-pair))))
    )
  (if (< target-priority *max-cost*)
  (do  ((low-indx 0)
	(high-indx (1- (length *priority-queue*)))
	(pr-bkt-fnd nil)
	(mid-indx nil))
       

       ((or pr-bkt-fnd (> low-indx high-indx))   ;; exit form 
	(cond
	  (pr-bkt-fnd 
	    (add-cls-pair-to-bkt cls-pair mid-indx))
	  (t (add-new-bkt-to-queue cls-pair (1+ high-indx)))))

       (setq mid-indx (truncate (/ (+ low-indx high-indx) 2)))
       (cond 
	 ((< target-priority 
	     (priority-bucket-priority (nth mid-indx *priority-queue*)))
	  (setq high-indx (1- mid-indx)))
	 ((> target-priority 
	     (priority-bucket-priority (nth mid-indx *priority-queue*)))
	  (setq low-indx (1+ mid-indx)))
	 (t (setq pr-bkt-fnd t))
	 )))
  ))




;;  Add a new clause pair to the specified clause pair bucket:
;;
;;  NOTE: new-clause-pair MUST be a clause pair STRUCTURE
;;        bkt-indx MUST be an integer

(defun add-cls-pair-to-bkt (new-cls-pair bkt-indx)
  (do* ((bkt (nth bkt-indx *priority-queue*))
	(bkt-cls-pairs (priority-bucket-clause-pairs bkt))
	(num-bkt-cls-pairs (length bkt-cls-pairs))
	(bkt-cls-pair-indx 0)
	(bkt-curr-cls-pair-pr-vect (clause-pair-priority-vector
				     (nth bkt-cls-pair-indx bkt-cls-pairs)))
	(new-cls-pair-pr-vect (clause-pair-priority-vector new-cls-pair))
	(num-cf-comps (length new-cls-pair-pr-vect))
	(pr-vect-indx 0)
	(cls-insert-cond-fnd nil)
	(cond-code nil))


       (cls-insert-cond-fnd                      ;;;; exit form
	 (cond
	   ((eq cond-code 'head)                     ;; insert at "head"
	    ;;;;(print "=====> INSERTING AT 'head'...")
	    (setq bkt-cls-pairs
		  (cons new-cls-pair bkt-cls-pairs)))
	   ((eq cond-code 'middle)                   ;; insert in "middle"
	    ;;;;(print "=====> INSERTING IN 'middle'...")
	    (setq bkt-cls-pairs 
		  (append (subseq bkt-cls-pairs 
				  0
				  bkt-cls-pair-indx)
			  (list new-cls-pair)
			  (subseq bkt-cls-pairs
				  bkt-cls-pair-indx))))
	   (t ;;;;(print "=====> INSERTING AT 'tail'...")
	      (setq bkt-cls-pairs                   ;; insert at "tail"
		    (append bkt-cls-pairs (list new-cls-pair)))))
	 (setf (priority-bucket-clause-pairs bkt) bkt-cls-pairs)
	 (setf (elt *priority-queue* bkt-indx) bkt))

       (cond
	;; There was a bug here, when the vector indices had different
	;; lengths (in case there were a different number of single-node and
	;; node-pair const functions). Thus, have to check whether the
	;; value returned by n-th is nil or not. If it is nil, then
	;; plus infinity is returned, so that shorter vectors are preferred.
	;; this is why "=" is replaced by "eq" here and the
	;; new "queue-greater-than" test is introduced instead
	;; of the < test below.

	 ((eq (nth pr-vect-indx new-cls-pair-pr-vect)
	      (nth pr-vect-indx bkt-curr-cls-pair-pr-vect))
	  (cond
	    ((< pr-vect-indx (1- num-cf-comps))
	     ;;;;(print "CASE 1.1 ==> increment vector index...")
	     (setq pr-vect-indx (1+ pr-vect-indx)))
	    (t (setq cls-insert-cond-fnd t)
	       (cond
		 ((= bkt-cls-pair-indx 0)
		  ;;;;(print "CASE ==> set insert flag & cond-code=head")
		  (setq cond-code 'head))
		 (t ;;;;(print "CASE ==> set insert flag & cond-code=middle")
		    (setq cond-code 'middle))))))

	 (;; A specialized test is more efficient than the following:
	  ;; (> (if-null-inf (nth pr-vect-indx new-cls-pair-pr-vect))
	  ;;    (if-null-inf (nth pr-vect-indx bkt-curr-cls-pair-pr-vect)))
	  (queue-greater-than (nth pr-vect-indx new-cls-pair-pr-vect)
			      (nth pr-vect-indx bkt-curr-cls-pair-pr-vect))
	  (cond
	    ((< bkt-cls-pair-indx (1- num-bkt-cls-pairs))
	     ;;;;(print "CASE 2.1 ==> increment cls-pair index...")
	     (setq bkt-cls-pair-indx (1+ bkt-cls-pair-indx))
	     (setq bkt-curr-cls-pair-pr-vect 
		   (clause-pair-priority-vector
		     (nth bkt-cls-pair-indx bkt-cls-pairs)))
	     (setq pr-vect-indx 0))
	    (t ;;;;(print "CASE 2.2 ==> set insert-flag & cond-code=tail")
	       (setq cls-insert-cond-fnd t)
	       (setq cond-code 'tail))))
	 (t (setq cls-insert-cond-fnd t)
	    (cond
	      ((= bkt-cls-pair-indx 0)
	       (setq cond-code 'head)
	       ;;;;(print "CASE 3 ==> set insert flag & cond-code=head")
	       )
	      (t (setq cond-code 'middle)
		 ;;;;(print "CASE 3 ==> set insert flag & cond-code=middle")
		 ))))))

;; (defun if-null-inf (x)
  ;; (if x x most-positive-fixnum))

(defun queue-greater-than (x y)
  (cond
   ((null y) nil)
   ((null x) T)
   (t (> x y))
   ))


;;  adds a NEW clause pair bucket to the priority queue and inserts the 
;;  given clause pair into it
;;
;;  NOTES: cls-pair MUST be a clause pair STRUCTURE
;;         new-bkt-posn MUST be an integer (that specifies where to insert the 
;;         new bucket)

(defun add-new-bkt-to-queue (cls-pair new-bkt-posn)
  (let ((new-bkt (construct-new-bucket 
		  (if (second (clause-pair-ids cls-pair))
		      (apply '+ (mapcar '* *cost-function-weights*
					(clause-pair-priority-vector
					 cls-pair)))
		      (apply '+ (mapcar '* *cost-function-single-weights*
					(clause-pair-priority-vector cls-pair)))
		      )
		  (list cls-pair))))
    (cond
      ((null *priority-queue*)
       (setq *priority-queue* (list new-bkt)))
      ((< new-bkt-posn (length *priority-queue*))
       (setq *priority-queue*
	     (append (subseq *priority-queue*
			     0 
			     new-bkt-posn)
		     (list new-bkt)
		     (subseq *priority-queue*
			     new-bkt-posn))))
      ((= new-bkt-posn (length *priority-queue*))
       (setq *priority-queue* (append *priority-queue* (list new-bkt))))
      (t (format t "~2% Internal FRAPPS error: new-bkt-posn: ~d is *out of range*" new-bkt-posn)
	 (read))
     )))



;;  gets the first REAL clause pair found from the first priority bucket 
;;  in the priority queue

(defun pop-priority-queue ()
  (cond
    ((null *queue-on*)
     (format t " ERROR: The priority queue is turned off.~%"))
    ((null *priority-queue*) nil)
    (t (do* ((head-pr-bkt-cls-id-pair nil)
	     (real-cls-id nil)
	     (real-cls-pair-fnd nil)
	     (cls-id-list nil nil))

	    ((or real-cls-pair-fnd (null *priority-queue*))    ;;;; termination form
	     (if real-cls-pair-fnd
		 head-pr-bkt-cls-id-pair
		 nil))

	    (setq head-pr-bkt-cls-id-pair 
		  (clause-pair-ids
		    (first (priority-bucket-clause-pairs 
			     (first *priority-queue*)))))


	    (setf (priority-bucket-clause-pairs (first *priority-queue*))
		  (rest (priority-bucket-clause-pairs (first *priority-queue*))))
	    (if (null (priority-bucket-clause-pairs (first *priority-queue*)))
		(setq *priority-queue* (rest *priority-queue*)))
	    (cond
	      ((and (not (null (first head-pr-bkt-cls-id-pair)))
		    (not (null (second head-pr-bkt-cls-id-pair))))
	       ;;;;(print "...SETTING real-cls-pair-fnd to TRUE...")
	       (setq real-cls-pair-fnd t))
	      (t (setf real-cls-id (first head-pr-bkt-cls-id-pair))
		 ;;;;(print "...PROCESSING pseudo pair...")
		 ;;;;(read)

		 ;; NEW: Possibly user-defined function to match up pairs!!!

		 (setq cls-id-list
		       (apply *pair-select-function* (list real-cls-id)))

		 (cond
		  ;; Note that deactivated single node entries might or might
		  ;; not particupate in the construction of queue pairs
		   ((not (null cls-id-list))
		    (dolist (cls-id cls-id-list)
			    ;; (if ;; (and (<= cls-id real-cls-id) (clause-active (gethash cls-id *node-db*)))
				;; all these conditions are optional...
				;; unactive nodes should be screened out before
				;; if that is what the user wants.
				;; Node-id ordering needs to be tested
				;; for before, too, if needed.
				;; (some inference rules might not be symmetric,
				;; so the order of the pairs might actually
				;; be important.)
				(progn
				  ;;;;(format t "~2%adding pair:~d,~d to QUEUE")
				  (add-elt-to-priority-queue 
				    (construct-new-clause-pair
				      (compute-pr-vector
					cls-id real-cls-id)
				      (list cls-id real-cls-id)))
				  ))) ;; )
		    )))))))

;; Default pair matching procedure:
;; Obtains all possible resolvents for the given node.
;; Excludes pairs where one of the clauses is deactivated,
;; and makes sure that the ids are ordered so that resolutions
;; are not done twice. (That is, pairs are really sets).

(defun gen-pair-select-fn (real-cls-id)
  (if (get-node-active real-cls-id)
      (let ((cls-id-list nil)
	    (result nil))
	   (dolist (lit (get-node-clause real-cls-id))
		   (cond
		    ((not (ans-lit-p lit))
		     (if (neg-lit-p lit)
			 (setq lit (rest lit))
			 (setq lit (cons 'not lit)))
		     (setq cls-id-list
			   (append cls-id-list
				   (ret-clauses-cont-unifiable-lits lit))
			   ))))
	   (dolist (cls-id (remove-duplicates cls-id-list))
		   (if (and (<= cls-id real-cls-id)
			    (get-node-active cls-id))
		       (setq result (cons cls-id result))))
	   result)
      ))

(defun sld-pair-select-fn (cls-id)
  (if (get-node-active cls-id)
      (let ((clause (get-node-clause cls-id))
	    (selected-lit 0)
	    (result nil)
	    (cls-id-list nil))
	   (cond
	    ((neg-cls-p clause)
	     ;; rule out cls-id if it does not have a negative clause.
	     ;; now get all the clauses that unify with the selected literal:
	     (setq selected-lit
		   (apply *sld-selection-fn*
			  (list clause)))
	     (setq cls-id-list (ret-clauses-cont-unifiable-lits
				(rest (nth (1- selected-lit) clause))))
	     ;; now screen larger ids and deactivated clauses:
	     (dolist (cls-id (remove-duplicates cls-id-list))
		     (if (get-node-active cls-id)
			 ;; do not have to worry about duplication of
			 ;; work here...
			 (setq result (cons cls-id result))))
	     result)
	    ))))


;;  add the list of specified clause ids to the priority queue as 
;;  PSEUDO-pairs (i.e. - a list consisting of a clause id and "nil"
;;  as the second "id")

;; (defun add-new-clauses-to-priority-queue (cls-id-list)
  ;; (if *queue-on*
      ;; (dolist (cls-id cls-id-list)
	      ;; (add-elt-to-priority-queue (construct-new-clause-pair
					     ;; (compute-pr-vector cls-id nil)
					     ;; (list cls-id))))))

(defun add-new-clauses-to-priority-queue (cls-id-list)
  (if *queue-on*
      (dolist (cls-id cls-id-list)
	      (let* ((cls-pair (construct-new-clause-pair
				(compute-pr-vector cls-id nil)
				(list cls-id)))
		     (target-priority (apply '+ (mapcar '* *cost-function-single-weights*
								  (clause-pair-priority-vector
								   cls-pair))))
		     )
		    (if (< target-priority *max-single-cost*)
			(do  ((low-indx 0)
			      (high-indx (1- (length *priority-queue*)))
			      (pr-bkt-fnd nil)
			      (mid-indx nil))
			     ((or pr-bkt-fnd (> low-indx high-indx))   ;; exit form 
			      (cond
			       (pr-bkt-fnd 
				(add-cls-pair-to-bkt cls-pair mid-indx))
			       (t (add-new-bkt-to-queue cls-pair (1+ high-indx)))))
			     
			     (setq mid-indx (truncate (/ (+ low-indx high-indx) 2)))
			     (cond 
			      ((< target-priority 
				  (priority-bucket-priority (nth mid-indx *priority-queue*)))
			       (setq high-indx (1- mid-indx)))
			      ((> target-priority 
				  (priority-bucket-priority (nth mid-indx *priority-queue*)))
			       (setq low-indx (1+ mid-indx)))
			      (t (setq pr-bkt-fnd t))
			      )))
		    ))
      ))


;;  Construct a NEW priority queue bucket STRUCTURE with the specified
;;  attributes:

(defun construct-new-bucket (prty cls-prs)
  (make-priority-bucket :priority prty
			:clause-pairs cls-prs))



;;  Construct a NEW clause pair STRUCTURE with the specified attributes:

(defun construct-new-clause-pair (pr-vector id-pair)
  (make-clause-pair :priority-vector pr-vector
		    :ids id-pair))


;;  Compute the cost function vector for the specified clause-id pair:
;;
;;  NOTES: the global var *cost-function-components* is accessed for 
;;         determining those functions which will be used to compute
;;         the priority vector for the clause pair
;;
;;         the functions used as cost function components MUST accept
;;         TWO ARGUMENTS -- a pair of NODE-INFO structures.
;;
;;	The elements of *cost-function-components* need only be function names
;;
;;	This was what the OLD version did:
;;         if a PSEUDO-pair is specified (i.e.- cls2-id is NIL), then
;;         cls2-struct is set to *pseudo-cls*, which denotes the PSEUDO-clause
;;         (i.e.- an "empty" clause which is at level 0) which is created
;;         at system "start-up" time.

;;	See the code for this in "old-prqmgmt.lsp"
;;	Now we simply compute the SINGLE node cost function:

;; The problem with this is that the user would have to take this
;; *pseudo-cls* into account when defining cost functions.
;; This, in turn, depens on further assumptions on these functions...
;; Instead, we apply the new *cost-function-single-components* to the
;; single clause; the user can thus decide if it will get expanded
;; sooner rather than later.

(defun compute-pr-vector (cls1-id cls2-id)
  (let ((pr-vector nil)
	(cls1-struct (get-node-node-info cls1-id))
	(cls2-struct (if cls2-id
			 (get-node-node-info cls2-id)
			 ;; *pseudo-cls* ;; no longer used !!
			 )))
       ;; Note that cost function components accept node-info structures.
       (if cls2-id
	   (dolist (cost-fn-comp *cost-function-components* pr-vector)
		   (setq pr-vector (append pr-vector
					   (list (apply cost-fn-comp
							(list cls1-struct cls2-struct)
							)))))
	   (dolist (unit-fn-comp *cost-function-single-components* pr-vector)
		   (setq pr-vector (append pr-vector
					   (list (apply unit-fn-comp
							(list cls1-struct)))))
		   )
	   )))



;; ====================================================================


;; Priority queue debugging and Session Management functions:

(defun show-priority-queue ()
  (format t "~2% The priority queue contains ~d buckets..."
	  (length *priority-queue*))
  (dolist (bkt *priority-queue*)
	  (read)
	  (format t "~3% *** BUCKET *** ")
	  (format t "~% ===> priority: ~d" (priority-bucket-priority bkt))
	  (format t "~% ===> clause pairs: ~% ")
	  (dolist (cls-pair (priority-bucket-clause-pairs bkt))
		  (format t "~% >>>>> ~d " cls-pair))
	  ))

(defun save-priority-queue-contents (stream)
  (dolist (bkt *priority-queue*)
	  (print (priority-bucket-priority bkt) stream)
	  (dolist (cls-pair (priority-bucket-clause-pairs bkt))
		  (print (list (clause-pair-priority-vector cls-pair)
			       (clause-pair-ids cls-pair))
			 stream))
	  (print 'bkt stream))
  (print '***end-priority-queue*** stream))

(defun restore-priority-queue-contents (stream)
  (do ((priority (read stream))
       (cls-pair-list nil))
      ((equal priority '***end-priority-queue***) nil)
      (do ((cls-pair (read stream)))
	  ((equal cls-pair 'bkt) nil)
	  (setq cls-pair-list (append cls-pair-list
				      (list
				       (construct-new-clause-pair
					(first cls-pair)
					(second cls-pair)))))
	  (setq cls-pair (read stream)))
      (setq *priority-queue*
	    (append *priority-queue*
		    (list (construct-new-bucket priority cls-pair-list))
		    ))
      (setq cls-pair-list nil)
      (setq priority (read stream))
      ))

