;; FRAPPS - prover-strats.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; These used to be part of FRAPPS, but no more.
;; They are retained for the use of the prover, though:

;;  ==> Set Of Support inference strategy

;; This is the (more efficient) version used by the prover.
;; It assumes the ENTIRE strategy has been carried out using SOS,
;; so it cannot be used in general; furthermore, the global variable
;; *unsupported-set* is only defined in the prover's code.

(defun prover-sos-resolve (c1 c2)
  (if (not (and (member c1 *unsupported-set*)
		(member c2 *unsupported-set*)))
	(resolve c1 c2)))


;; Beginning of regular (OLD) Set-of-Support code:

;; (defun sos-resolve (c1 c2)
  ;; (if (or (has-support-p c1)
	  ;; (has-support-p c2))
      ;; (resolve c1 c2)))

;;  determines if the given clause has "support" (i.e. - is a member of the
;;  support set, or has an ancestor that is a member of the support set),
;;  if so, "t" is returned, otherwise "nil" is returned

(defun has-support-p (cls-id)
  (let ((id-parents nil))
    ;;;;(format t "~2% cls-id: ~d" cls-id)
    ;;;;(if (and (not (null cls-id)) (atom cls-id))
    ;;;;    (format t "...it's PARENTS are: ~d" (get-node-parents cls-id)))
    ;;;;(read)
    (cond 
      ((null cls-id) nil)
      ((atom cls-id)
       (cond
	 ((member cls-id *support-set*)
	  t)
	 ((equal (setq id-parents (get-node-parents cls-id)) 
		 '(nil nil)) 
	  nil)
	 (t (or (has-support-p (car id-parents))
		(has-support-p (cdr id-parents))))))
      (t (or (has-support-p (car cls-id))
	     (has-support-p (cdr cls-id)))))))


;;;;  ========> END OF Set-of-Support code <=============

;;  ==> Ancestry Filtering inference strategy
;;


(defun anc-filter-resolve (c1 c2)
  (cond
    ((or (member c1 *base-set*)
	 (member c2 *base-set*)
	 (anc-p c2 c1)
	 (anc-p c1 c2))
     (resolve c1 c2))))



;;  determines whether or not the first clause is an ancestor of the second;
;;  if so, "t" (i.e. - "true") is returned, otherwise "nil" is returned
;;
;;  NOTE:  this version *DOES NOT* rely upon the user-info slot of the 
;;         clause structure

(defun anc-p (cls1-id cls2-id)
  (cond
    ((eq cls1-id cls2-id) nil)
    (t (do ((ancs-to-proc-queue (list cls2-id))
	    (cls1-id-fnd nil)
	    (node-to-proc nil)
	    (node-ancs nil))

	   ((or (null ancs-to-proc-queue) cls1-id-fnd)   ;; termination form
	    (if cls1-id-fnd
		t
	      nil))
      
	   (setq node-to-proc (first ancs-to-proc-queue))
	   (setq ancs-to-proc-queue (rest ancs-to-proc-queue))
	   (cond
	     ((not (null node-to-proc))
	      (setq node-ancs (get-node-parents node-to-proc))
	      (if (member cls1-id node-ancs)
		  (setq cls1-id-fnd t)
		(setq ancs-to-proc-queue (append ancs-to-proc-queue node-ancs)))))))))


;;  ==> Input Resolution inference strategy
;;

(defun input-resolve (c1 c2)
  (if (or (member c1 *base-set*)
	  (member c2 *base-set*))
      (resolve c1 c2)))



;;  ==> Unit Resolution inference strategy
;;

(defun unit-resolve (c1 c2)
  (if (or (eq (clause-length (get-node-clause c1)) 1)
	  (eq (clause-length (get-node-clause c2)) 1))
      (resolve c1 c2)))


;;  ==> P1-resolution inference strategy
;;

(defun p1-resolve (c1 c2)
  (if (or (pos-cls-p (get-clause c1)) (pos-cls-p (get-clause c2)))
      (resolve c1 c2)))

