;; FRAPPS - prover-funcs.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; NOTE: This is not really a part of FRAPPS, and thus
;; some of the following functions are rather obsolete now.

;; Changed *empty-cls-fnd* and *empty-cls-ids* to local
;; "prover-" variables.

(defun prover-sos-resolve (c1 c2)
  (if (not (and (member c1 *unsupported-set*)
		(member c2 *unsupported-set*)))
      (resolve c1 c2)))

;; NOTE: *unsupported-set* is not maintained by FRAPPS.

;;  ==> "MAIN" FUNCTION
;;
;;  this is essentially the "top level" function of the whole system; it
;;  provides the "overall" control by inferring clauses and processing them
;;  until a refutation is found (or some other termination condition is 
;;  encountered)
;;
;;  the "main" test/infer/process loop is structured as follows:
;;
;;       WHILE a "termination" condition is NOT present DO
;;       
;;         --> get the "most promising" UNTRIED clause pair from the 
;;             priority queue
;;
;;         --> infer new clauses from the clause pair using all "active"
;;             inference rules
;;
;;         --> "process" the new resolvents and "insert" them in the priority
;;             queue as "pseudo-pairs"

(defun search-for-refutation ()
  (if (member '*set-of-support* *active-inf-rules*)
      (setq *unsupported-set* (set-difference *base-set* *support-set*)))
  (do ((priority-queue-empty nil))
      
      ((or priority-queue-empty
	   *prover-empty-cls-fnd*
	   (> *num-generated-clauses* *max-generated-clauses*)
	   (> *num-kept-clauses* *max-kept-clauses*))
       (cond
	 (*output-base-set*
	   (output-clauses *base-set* "The Set of Clauses:")
	   (if *support-set*
	       (output-clauses *support-set* "With Support Set:"))))
       (cond 
	 (*prover-empty-cls-fnd*
	   (format t "~2% ... are Unsatisfiable"))
	 (priority-queue-empty
	   (format t "~2% ... are Satisfiable"))
	 ((> *num-generated-clauses* *max-generated-clauses*)
	  (format t "~2% ... have not yet been proven to be either Satisfiable")
	  (format t "~%  or Unsatisfiable as the number of clauses generated has")
	  (format t "~%  exceeded the limit specified by *max-generated-clauses*"))
	 ((> *num-kept-clauses* *max-kept-clauses*)
	  (format t "~2% ... have not yet been proven to be either Satisfiable")
	  (format t "~%  or Unsatisfiable as the number of clauses generated has")
	  (format t "~%  exceeded the limit specified by *max-kept-clauses*")))
       (cond
	 (*output-all-kept-clauses*
	   (read-line)  ;;  <== THIS function call is **NOT** needed by LUCID!!!
	   (format t "~2% Press <return> to see the list of retained resolvents")
	   (read-line)
	   (format t "~2% The retained resolvents (by level) were:")
	   (output-clauses-by-level *depth*)))
       (cond
	 (*output-stats*
	   (format t "~2% Press <return> to see the list of statistics compiled")
	   (format t "~% during the search for a refutation")
	   (read-line)
	   (output-statistics)))
       (cond
	 ((and *display-proof* *prover-empty-cls-fnd*)
	  (format t "~2% Press <return> to see the proof that was generated")
	  (read-line) 
	  (output-proof (recover-proof)))))

      (setq cls-id-pair (pop-priority-queue))
      (cond
	((not (null cls-id-pair))
	 (setq new-rslvnts (infer-new-rslvnts cls-id-pair))
	 (cond
	   (new-rslvnts
	     (setq *num-generated-clauses*
		   (+ *num-generated-clauses* (length new-rslvnts)))
	     (setq kept-cls-ids
		   (process-inferred-clauses new-rslvnts nil))
	     (setq *num-kept-clauses* 
		   (+ *num-kept-clauses* (length kept-cls-ids))))))
	(t (setq priority-queue-empty t)))))


      

;;  "process" the list of given resolvents
;;
;;  "processing" an individual clause consists of the following steps:
;;
;;   ==> output the new clause (optional)
;;   ==> "discard" the new clause if it is a tautology (optional)
;;   ==> "discard" the new clause if it is too long (optional)
;;   ==> "discard" the new clause if it is too complex (optional)
;;   ==> "discard" the new clause if it is forward subsumed (optional)
;;   ==> integrate the new clause *if* it hasn't been previously discarded
;;
;;   the following steps are delayed until the steps listed above have been
;;   applied to *ALL* of the newly inferred clauses:
;;
;;   ==> output the "kept" clauses (optional)
;;   ==> search for the "empty clause" amongst the newly "kept" clauses **OR**
;;       for a *unit* clause amongst the newly "kept" clauses which contradicts
;;       an already existing *unit* clause; if either are found, EXIT this 
;;       function IMMEDIATELY
;;   ==> "deactivate" those nodes which are backward subsumed by the "kept"
;;       clauses (optional)
;;   ==> factor the "kept" clauses and process each of the factors individually
;;       as they are produced (optional)
;;
;;   This function returns a list of the IDS of those clauses which are *KEPT*

(defun process-inferred-clauses (rslvnt-list proc-factors)
  (let ((kept-rslvnt-ids nil)
	(kept-rslvnts nil)
	(proc-rslts nil)
	(factor-rslts nil))
    ;;;;(format t "~2% *** NEWLY GENERATED CLAUSES ***")
    (if *output-gen-clauses*
	(output-gen-resolvents rslvnt-list))
    ;;;;(read)  ;; <======
    (dolist (rslvnt rslvnt-list)
	    (cond
	      ((setq proc-rslts (process-newly-inferred-clause rslvnt))
	       (setq kept-rslvnt-ids (append kept-rslvnt-ids (list proc-rslts)))
	       (setq kept-rslvnts (cons rslvnt kept-rslvnts)))))
    ;;;;(format t "~2% *** NEWLY GENERATED ==> KEPT <== CLAUSES ***")
    (if *output-kept-clauses*
	(output-kept-clauses kept-rslvnt-ids))
    ;;;;(read)
    (cond
      ((or (empty-clause-gen-p kept-rslvnt-ids)
	   (unit-conflict-p kept-rslvnt-ids))
       (setq *prover-empty-cls-fnd* t))
      ((and *factor* (not proc-factors))
       (dolist (rslvnt-id kept-rslvnt-ids)
	       (setq factor-rslts (factor rslvnt-id))
	       (cond
		 ((not (null factor-rslts))
		  (setq *num-generated-clauses*
			(+ *num-generated-clauses* (length factor-rslts)))
		  (setq kept-rslvnt-ids
			(append kept-rslvnt-ids
				(process-inferred-clauses factor-rslts t))))))))
    kept-rslvnt-ids))




;;  "process" an individual newly generated clause

(defun process-newly-inferred-clause (resolvent)
  (cond
    ((or (and *taut-delete* (taut-p (resolvent-info-clause resolvent)))
	 (and *length-delete* 
	      (> (clause-length (resolvent-info-clause resolvent)) 
		 *max-length*))
	 (and *complex-delete*
	      (> (clause-complexity (resolvent-info-clause resolvent))
		 *max-complexity*))
	 (and *fwd-subsume*
	      (null (delete-fwd-sub-resolvents (list resolvent)))))
     nil)
    (t (if *back-subsume*
	   (let (subsumed-nodes (get-ids-sub-by-clause resolvent))
		(if *print-back-sub-clauses*
		    (dolist (id subsumed-nodes)
			    (format t "~2% Clause: ~d back subsumed by resolvent: ~d"
				    (get-node-clause id) lit-list)))
		(dolist (id subsumed-nodes)
			(deactivate-node id)
			)
		))
       (integrate-clause resolvent))))



;;  infer new resolvents using the currently "active" inference procedures;
;;  return those resolvents (duplicates removed) which are produced
;;
;;  NOTE: the global var. *active-inf-rules* is used to "store" references to
;;        the "active" inference procedures (rules)
;;   
;;        cls-id-pair MUST be a list containing a PAIR of clause IDS

(defun infer-new-rslvnts (cls-id-pair)
  (let ((rslvnt-list nil))
    (dolist (inf-rule *active-inf-rules*)
	    (setq rslvnt-list
		  (append rslvnt-list
			  (apply (eval inf-rule) cls-id-pair))))
    (remove-duplicates rslvnt-list :from-end t :test #'equal)))




;;  searches for unit clauses amongst the list of resolvents provided,
;;  those resolvents which are determined to be UNITS are then used to 
;;  search for CONTRADICTING units which *already* exist in the clause
;;  database; if a unit contradiction is found then the node-id of the
;;  "newly integrated" *empty clause* is returned, otherwise "nil" is 
;;  returned
;;
;;  NOTE: rslvnt-ids MUST be a list of clause IDS

(defun unit-conflict-p (rslvnt-ids)
  (let* ((unit-cls-ids (gethash 1 *cls-length-db*))
	 (new-unit-rslvnt-ids (intersection unit-cls-ids rslvnt-ids))
	 (rslv-rslts nil)
	 (unit-conflict-fnd nil))
    (dolist (rslvnt-id new-unit-rslvnt-ids nil)
	    (dolist (unit-cls-id unit-cls-ids nil)
		    (cond
		      ((< unit-cls-id rslvnt-id)
		       (setq rslv-rslts (b-resolve (gethash rslvnt-id *node-db*)
						   (gethash unit-cls-id *node-db*)))
		       (cond
			 ((and rslv-rslts (empty-clause-gen-p rslv-rslts))
			  (setq *num-generated-clauses* (1+ *num-generated-clauses*))
			  (setq *num-kept-clauses* (1+ *num-kept-clauses*))
			  (return (setq *prover-empty-cls-ids* 
					(adjoin (first (integrate-clause-list rslv-rslts)) *prover-empty-cls-ids*)))))))
	    (if *prover-empty-cls-ids*
		(return *prover-empty-cls-ids*))))))


;;  resets the prover global variables

(defun reset-prover ()
  (setq *num-generated-clauses* 0) 
  (setq *num-kept-clauses* 0)
  (setq *prover-empty-cls-fnd* nil))

(defun output-statistics ()
  (format t "~4%           *** Statistical Summary ***")
  (format t "~3%  ~d clauses were generated" *num-generated-clauses*)
  (format t "~1%  ~d clauses were retained" *num-kept-clauses*)
  (format t "~1%  The depth of the deepest clause retained was ~d" *depth*)
  (dotimes (level *depth*)
           (format t "~% ~d level ~d clauses were retained"
                   (length (gethash (1+ level) *level-db*)) (1+ level))))



;;  output the "results" returned by the function "recover-proof"

(defun output-proof (proof-nodes-anc-info)
  (let ((node-pars nil)
	(node nil))
       (dolist (proof-node-info proof-nodes-anc-info)
	       (setq node-pars (first proof-node-info))
	       (setq node (second proof-node-info))
	       (cond
		((not (equal node-pars '(nil nil)))
		 (format t "~3% The Clauses: ~% ")
		 (dolist (par node-pars)
			 (cond
			  (par (format t " ~% ~d: ~d" par (get-node-clause par)))
			  (t   (format t " ~% ~d: ~d" par nil))))
		 (format t "~2% produced the level-~d resolvent... ~d: ~d"
			 (get-node-level node) node (get-node-clause node))
		 (read-line))))))


;;  "recovers" the proof after a *refutation* has been found
;;
;;  NOTE: this function assumes that a proof has been FOUND previously, and
;;        that the global var. *prover-empty-cls-ids* has been set by the
;;        function "empty-clause-gen-p". Recovers the FIRST proof found.
;;
;;        this function builds, and subsequently returns, a list structure
;;        of the following form:
;;
;;          ( ((l-par1 r-par1).child1) ... ((l-parn r-parn).childn) )
;;
;;          where:
;;                 "l-pari", "r-par-i", and "childi" are *ALL* NODE IDS and
;;                 "childn" is the "empty-clause" NODE ID

(defun recover-proof ()
  (do ((ancs-to-proc-queue (list (car *prover-empty-cls-ids*)))
       (proof-nodes-anc-info nil)
       (node-to-proc nil)
       (node-ancs nil))
      
      ((null ancs-to-proc-queue) proof-nodes-anc-info)  ;; termination form
      
      (setq node-to-proc (first ancs-to-proc-queue))
      (cond
       ((not (null node-to-proc))
	(setq node-ancs (get-node-parents node-to-proc))
	(setq proof-nodes-anc-info
	      (cons (list node-ancs node-to-proc)
		    proof-nodes-anc-info))
	(setq ancs-to-proc-queue
	      (append (rest ancs-to-proc-queue) node-ancs)))
       (t (setq ancs-to-proc-queue
		(rest ancs-to-proc-queue))))))


;;  Function "empty-clause-gen-p" receives a list of EITHER resolvent-info
;;  structures *OR* node-info structures as input. It searches thru the
;;  list looking for the empty clause; if the empty clause is found then
;;  either the NODE-ID of the empty clause is returned (if node-info
;;  structures are passed as input), or "t" is returned (if resolvent-info
;;  structures are passed as input); otherwise "nil" is returned in the
;;  event that the empty clause is not found
;;
;;  NOTE: if node-info structures are passed to this function, then
;;        the node id of the empty clause is added to the global var.
;;        *prover-empty-cls-ids* in the event that the empty clause is found

(defun empty-clause-gen-p (clause-list)
  (let ((clause-access-fn nil)
	(elt-type nil))
       (cond
	((resolvent-info-p (first clause-list))
	 (setq clause-access-fn #'(lambda (resolvent)
					  (resolvent-info-clause resolvent)))
	 (setq elt-type 'resolvent))
	(t (setq clause-access-fn #'(lambda (id)
					    (get-node-clause id)))
	   (setq elt-type 'node-id)))
       (dolist (clause clause-list nil)
	       (if (eq (clause-length (apply clause-access-fn (list clause))) 0)
		   (if (eq elt-type 'node-id)
		       (return (setq *prover-empty-cls-ids*
				     (adjoin clause *prover-empty-cls-ids*)))
		       (return t))))))



;; ---------------------------------------------------------------

;; The following are some output functions used only by the prover
;; (now not part of FRAPPS)

;;  output the list of given clauses

(defun output-kept-clauses (clause-id-list)
  (output-clauses clause-id-list "kept clauses:"))

;;  output the given message followed by the given list of clauses

(defun output-clauses (node-id-list msg)
  (format t "~2% ~d " msg)
  (if node-id-list
      (print-cls-lst node-id-list)
      (format t "~% none... ")))

;;  output the given list of resolvent-info structures

(defun output-gen-resolvents (rslvnt-list)
  (format t "~2% generated: ")
  (dolist (rslvnt rslvnt-list)
	  (format t "~% ~d" rslvnt)))

