;; FRAPPS - prover-defs.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;  =========================================================================
;;;;  =                                                                       =
;;;;  =                                                                       =
;;;;  =                  PROVER GLOBAL VARIABLE DEFAULT SETTINGS              =
;;;;  =                                                                       =
;;;;  =                                                                       =
;;;;  =========================================================================

;;  This file contains the global variable definitions for a "sophisticated"
;;  theorem proving system that was implemented using FRAPPS.  The details of
;;  this prover are discussed in Section 8.3 of my thesis.


;;  === Inference Rule "related" ===

(defvar *active-inf-rules* '(*unrestricted-bin-res*))  ;; list of "active" 
                                                       ;; inference strategies

;;  ==> Inference Strategies
(defvar *unrestricted-bin-res* #'resolve)	 ;; Unrestricted Bin. Res.
(defvar *set-of-support* #'prover-sos-resolve)   ;; Set of Support strategy
(defvar *ancestry-filter* #'anc-filter-resolve)  ;; Ancestry Filtering strat.
(defvar *input-res* #'input-resolve)             ;; Input resolution strategy
(defvar *unit-res* #'unit-resolve)               ;; Unit resolution strategy
(defvar *sld-res* #'sld-resolve)                 ;; SLD resolution
(defvar *p1-res* #'p1-resolve)                   ;; P1 resolution


;; (setq *sld-selection-fn* 'leftmost-select-fn) ;; Part of FRAPPS

(defvar *unsupported-set* nil)   ;; (list) id's of clauses not in the sos.

;;  === Generated Clauses "related"

(defvar *num-generated-clauses* 0)  ;; (integer) self-descriptive
(defvar *num-kept-clauses* 0)       ;; (integer) self-descriptive
(defvar *max-generated-clauses* most-positive-fixnum)  ;; (integer) self-des.
(defvar *max-kept-clauses* most-positive-fixnum)  ;; (integer) self-descrip.



;;  ==========================
;;
;;         ====> GLOBAL FLAGS
;;
;;  ==========================

;;  === output flags ===

(defvar *output-gen-clauses* t)      ;; enables/disables output of gen. clauses
(defvar *output-base-set* t)         ;; enables/disables output of base set
(defvar *output-kept-clauses* t)     ;; enables/disables output of kept cls. (during proof)
(defvar *output-stats* t)            ;; enables/disables output of "end" stats.
(defvar *display-proof* t)           ;; enables/disables output of "proof"
(defvar *output-all-kept-clauses* t) ;; enables/disables output of ALL keepers (after proof)
  

;;  === deletion strategy flags ===
   
(defvar *taut-delete* t)     ;; enables/disables tautology deletion
(defvar *length-delete* t)   ;; enables/disables length deletion
(defvar *complex-delete* t)  ;; enables/disables complexity deletion
(defvar *fwd-subsume* t)     ;; enables/disables fwd subsumption deletion
(defvar *back-subsume* nil)    ;; enables/disables backwd. subsumption deletion


;;  === "delayed event" clause processing flags ===

(defvar *factor* nil)               ;; enables/disables factoring
(defvar *unit-conflict-search* t) ;; enables/disables unit-conflict search
