;; FRAPPS - init.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Global variables used in this file:

(defvar *kcl-bug* nil)
(defvar *frapps-dir* "")
(defvar *compiled-dir* "")
(defvar *demos-dir* "")
(defvar *source-suffix* ".lsp")
(defvar *compiled-suffix* "")
(defvar *frapps-files* "")


;; ======================= BEGIN INSTALLATION GLOBALS =====================

;; The values in this section should be changed according to the particular
;; installation:

(if (string-equal (lisp-implementation-type) "Kyoto Common Lisp")
  (setq *kcl-bug* T)
  (setq *kcl-bug* nil))

;; *kcl-bug* should be set to "T" if a version of KCL with the
;; "read-line" bug is being used, and "nil" otherwise.
;; Otherwise, the start-frapps and resume-session functions can appear
;; to be "hung-up", when they are really waiting for a line to be read in.

;; ========================= FILE LOCATIONS ===============================

;; defaults are for the CS341 IBM installation:

;; This should be the directory where all FRAPPS source files reside:
(setq *frapps-dir* "/usersb/cs341/src/frapps")

;; This should be the directory where all FRAPPS compiled files reside:
(setq *compiled-dir* "/usersb/cs341/bin/frapps")

;; This should be the directory where all the demos are located:

(setq *demos-dir* "/usersb/cs341/lib/frapps-demos")

;; The following two variables should be set according to the version
;; of LISP being used:

(setq *source-suffix* ".lsp") ;; suffix for source files
(setq *compiled-suffix* ".o") ;; suffix for compiled files

;; Try to customize above variables for different machines, versions of Lisp:

(if (string-equal (lisp-implementation-type) "Allegro CL")
  (setq *compiled-suffix* ".fasl")
  )

(if (string-equal (lisp-implementation-type) "Lucid Common Lisp")
  (cond ((string-equal (machine-instance) "frege")
	 (setq *compiled-suffix* ".bbin")
	 (setq *frapps-dir* "/u/uribe/frapps")
	 (setq *compiled-dir* "/u/uribe/bin")
	 (setq *demos-dir* "/u/uribe/frapps/demos")
	 )
	(T (setq *compiled-suffix* ".sbin") ;; For the AI Suns
	   (setq *frapps-dir* "/mnt9/home/AI/frisch/uribe/frapps")
	   (setq *compiled-dir* "/mnt9/home/AI/frisch/uribe/bin")
	   (setq *demos-dir* "/mnt9/home/AI/frisch/uribe/frapps/demos")
	   )))

;; KCL on the AI suns:
(if (string-equal (lisp-implementation-type) "Kyoto Common Lisp")
  (cond ((string-equal (machine-version) "SUN")
	 (setq *frapps-dir* "/mnt9/home/AI/frisch/uribe/frapps")
	 (setq *compiled-dir* "/mnt9/home/AI/frisch/uribe/bin")
	 (setq *demos-dir* "/mnt9/home/AI/frisch/uribe/frapps/demos")
	 )))


;; ======================= END  INSTALLATION GLOBALS =====================

;; Functions for loading source, compiled and demo files:

(defun frapps-source-filename (str)
   (concatenate 'string *frapps-dir* "/" str *source-suffix*))

(defun frapps-compiled-filename (str)
   (concatenate 'string *compiled-dir* "/" str *compiled-suffix*))

(defun frapps-demo-filename (str)
   (concatenate 'string *demos-dir* "/" str *source-suffix*))

;; demos will probably not be compiled, but anyway:
(defun frapps-compiled-demo-filename (str)
   (concatenate 'string *demos-dir* "/" str *compiled-suffix*))

(defun load-source-file (str)
  (load (frapps-source-filename str)))

(defun load-object-file (str)
  (load (frapps-compiled-filename str)))

(defun load-demo (str)
  (if (probe-file (frapps-compiled-demo-filename str))
      (load (frapps-compiled-demo-filename str))
      (load (frapps-demo-filename str))))

;; =======================================================================

;; Initialization function:

(defun start-frapps ()
  (format t "~% FRAPPS 2.0")
  (format t "~% KRRG, University of Illinois at Urbana-Champaign, 1991~%")
  (if (probe-file (frapps-compiled-filename "dbss"))
      ;; assume that if this file is there, all of them are...
      (option-start-frapps)
      (load-frapps-source-code))

  ;; (set-pseudo-cls-globals) ;; No longer used.

  (reset-frapps)
  (format t "~2%SYSTEM READY...")
  (values)
  )

(defun option-start-frapps ()

  (if *kcl-bug* (read-line))

  (do ((version nil))
      ((or (string-equal version "i") (string-equal version "c"))
       (cond
	((string-equal version "i")
	 (format t "~%loading FRAPPS \"source\" modules...~2%")
	 (load-frapps-source-code))
	((string-equal version "c")
	 (format t "~%loading FRAPPS \"object\" modules...~2%")
	 (load-frapps-object-code))))
      (format t "~2% Enter \"i\" to load the INTERPRETED FRAPPS code,")
      (format t  "~%       \"c\" to load the COMPILED FRAPPS code.")
      (format t "~2% Your choice: ")
      (setq version (read-line))
      ))

;; List of the names of all the FRAPPS files:

(setq *frapps-files*
  (list
   "glvads"	;; global vars and data structures ;; Should always go FIRST.
   "dbss"	;; database support system 
   "dbshared"	;; shared database support system 
   "unifylits"	;; unifier and literal primitives
   "infprims"	;; inference primitives 
   "prqmgmt"	;; priority queue mgmt 
   "costfns"	;; cost functions definitions
   "delstrats"	;; deletion strategies 
   "outputfns"	;; output functions
   "tpmisc"	;; miscellaneous functions
   "subsume"	;; subsumption functions
   "session"	;; session management
   "sld"

   ;; Demos could also be loaded separately, with (load-demos).
   "run-demo";; for running demos
   "user"	;; search procedure used in the above
   ))

(defun run-demos () (run-demo))

;; This is its actual name in the manual - not "run-demoS"...

;; ============= Functions that do the actual loading: ============


;;  load the **LISP SOURCE** version of FRAPPS:

(defun load-frapps-source-code ()
  (dolist (file *frapps-files*)
	  (load-source-file file))
  (reset-frapps))


;;  load the **LISP OBJECT CODE** version of FRAPPS:

(defun load-frapps-object-code ()
  (dolist (file *frapps-files*)
	  (load-object-file file))
  (reset-frapps))


;;  load the **LISP SOURCE** version of the theorem proving system 
;;  discussed in section 8.3 of thesis (Michael K. Mitchell, 1989)

(defun load-prover ()
  (load-source-file "prover-defs")	;; prover global defs
  (load-source-file "prover-funcs")	;; prover function defs
  (load-source-file "prover-strats")	;; prover inference strategies
  )

(defun load-demos ()
  (let ((flag nil))
       (cond
	((and (probe-file (frapps-compiled-filename "run-demo"))
	      (probe-file (frapps-compiled-filename "user")))
	 (format t "~% Load compiled files? ")
	 (if *kcl-bug* (read-line))
	 (cond
	  ((user-choice)
	   (load-object-file "run-demo") ;; "Interface" for demos
	   (load-object-file "user")	 ;; Search procedure 
	   (setq flag T)
	   ))
	 ))
       (if (null flag)
	   (progn
	    (load-source-file "run-demo")
	    (load-source-file "user")
	    )))
  (values))


;;		 ============================================

;; Compiling FRAPPS: Compiles those files whose object files don't
;; exist in the given directory, or whose compiled version is
;; older than the source file.

(defun compff (str)	;; "Compile Frapps Filename"
  (if (or (not (probe-file (frapps-compiled-filename str)))
	  (< (file-write-date (frapps-compiled-filename str))
	     (file-write-date (frapps-source-filename str)))
	  )
      (compile-file (frapps-source-filename str)
		    :output-file (frapps-compiled-filename str)
		    )))

(defun compile-frapps ()
  (dolist (file *frapps-files*)
	  (compff file)
	  ))

(defun compile-demos ()
  (compff "run-demo")
  (compff "user")
  )

