;; hooked-on-FRAPPS - sort-unify.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;; SORTED unifier:

(defun sorted-unify (lit1 lit2 &optional const1 const2)
  (declare (ignore const1) (ignore const2))
  (let ((rslt (s-unify lit1 lit2)))
       (if (not (eq rslt 'FAIL))
	   (list (list rslt nil))
	   'FAIL)
       ))

;; (defun merge-const (c1 c2 subst) nil)


(defun purge-const (c)
  (let ((reslt nil))
       (dolist (x c)
	       (if (var-p (car x))
		   (if (not (equal (cadr x) *univ*))
		       (setf reslt (cons x reslt)))))
       reslt))


(defun make-new-const (constraint substitution)
  (if (null constraint) nil
      (let* ((pair (car constraint))
	     (value (compose-bindings (car pair) substitution)))
	   (if (var-p value) ;; have x:animal --> y:dog
	       (cons (list value (second pair))
		     (make-new-const 
		      (subst-s-exp (cdr constraint) (list (cons (car pair) value)))
		      substitution))
	       (make-new-const (cdr constraint) substitution))
	       )))


(defun purge (const vars) ;; removes variables not in list "vars" from "const".
  (cond
   ((atom const) const)
   ((atom (car const)) nil)
   ((var-p (first (car const)))
    (if (equal (cdr (car const)) (first (car const)))
	nil
	(if (member (first (car const)) vars :test #'equal)
	    (cons (car const) (purge (cdr const) vars))
	    (purge (cdr const) vars))
	))
    ('T (purge (cdr const) vars))
    ))


;;  NOTE: this function assumes that a variable has the form: 
;;
;;              (*var* <var. name> <var. subscript>)

;; Assumes monomorphic tree restriction as spelled out in *tree*.
;; Unknown or nil sorts are considered universal...

(defun s-unify (pat1 pat2 &optional bindings)
  (cond 
    ((equal pat1 pat2)
     bindings)
    ((var-p pat1) 
     (s-var-unify pat1 pat2 bindings))
    ((var-p pat2) 
     (s-var-unify pat2 pat1 bindings))
    ((or (not (listp pat1)) (not (listp pat2))) 
     'FAIL)
    ((not (eq (setq bindings (s-unify (car pat1) (car pat2) bindings)) 'FAIL))
     (s-unify (cdr pat1) (cdr pat2) bindings))
    (t 'FAIL)))


;;  determines if the given variable will unify with the given pattern in the
;;  context of the given variable bindings

(defun s-var-unify (var pat bindings)
  (let ((val (find-binding var bindings)))
       (cond 
	(val (s-unify val pat bindings))
	((and (free-in var pat bindings) pat) ; pat can't be nil
	 (if (s-entails var pat)
	     (cons (cons var pat) bindings)
	     (if (and (var-p pat) (s-entails pat var))
		 ;; (cons (cons pat var) bindings) ;; There was a bug here!
		 (s-var-unify pat var bindings)
		 'FAIL)))
	((var-p pat)
	 (let ((var2 (compose-bindings pat bindings)))
	      (cond
	       ((equal var var2) bindings)
	       ((s-entails var var2)
		(collapse-subst (cons (cons var pat) bindings)))
	       ((s-entails var2 var)
		(collapse-subst (cons (cons pat var) bindings)))
	       (t 'FAIL)
	       )))
	(t 'FAIL))))

