;; hooked-on-FRAPPS - hsubsume.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;  ==========================================================================
;;
;;
;;	(MONOMORPHIC-)**SORTED** SUBSUMPTION DETECTION FUNCTIONS 
;;
;;
;;  ===========================================================================

;;  ==> VARIANT DETECTION
;;
;;  determines if cls1 and cls2 are VARIANTS of each other, where both cls1 
;;  and cls2 are LITERAL LISTS. If cls1 and cls2 are variants, then "t" is 
;;  returned, otherwise "FAIL" is returned.
;;
;;  NOTE: cls1 and cls2 are LISTS OF LITERALS

;; ignores constraint arguments; same as unsorted version except "s-unify"
;; is used instead of "unify" to get initial substitution, and then
;; reverse unification check is done when going throught the binding list:

(defun const-variant-p (cls1 cls2 &optional const1 const2)
  (declare (ignore const1) (ignore const2))
  (s-cls-variant-p1 cls1 (stndze-vars-apart cls1 cls2)))

(defun s-cls-variant-p1 (cls1 cls2 &optional bindings)
  (cond
   ((and (null cls1) (null cls2))
    bindings)
   ((or (null cls1) (null cls2)) 'FAIL)
   (T (dolist (lit1 cls1 'FAIL)
	      (let ((new-bind nil)
		    (return-bind nil))
		   (cond
		    ((not (eq (setq new-bind
				    (s-variant-p lit1 (first cls2)))
			      'FAIL))
		     (if (not (eq
			       (setq return-bind
				     (s-cls-variant-p1
				      (remove lit1 cls1 :test #'equal)
				      (cdr cls2)
				      new-bind
				      ))
			       'FAIL))
			 (return return-bind)
			 ))
		    ))
	      ))))



(defun s-variant-p (cls1 cls2)
  (let ((bind-list (s-unify cls1 cls2))
	(term-list nil))
       (cond
	((not (eq bind-list 'FAIL))
	 (dolist (bind-elt bind-list (if (equal
					  (subst-s-exp cls1 bind-list)
					  cls2)
					 T
					 'FAIL))
		 (if (and (var-p (rest bind-elt))
			  (s-entails (rest bind-elt) (car bind-elt))
			  ) ;; this was the "reverse" check.
		     (if (not (member (rest bind-elt) term-list :test #'equal))
			 (setq term-list (cons (rest bind-elt) term-list))
			 (return 'FAIL))
		     (return 'FAIL))))
	(T 'FAIL))))



;;  ==> INSTANCE DETECTION

;; Same as unsorted version, except now use s-instantiate-var, in s-instance-p.

(defun const-instance-p (cls1 cls2 &optional const1 const2)
  (declare (ignore const1) (ignore const2))
  (s-cls-instance-p1 cls1 (stndze-vars-apart cls1 cls2))
  )

(defun s-cls-instance-p1 (cls1 cls2 &optional bindings)
  (cond
   ((and (null cls1) (null cls2)) bindings)
   ((or (null cls1) (null cls2)) 'FAIL)
   (T (dolist (lit1 cls1 'FAIL)
	      (let ((new-bind nil)
		    (return-bind nil))
		   (cond
		    ((not (eq (setq new-bind
				    (s-instance-p lit1 (first cls2) bindings))
			      'FAIL))
		     (if (not (eq
			       (setq return-bind
				     (s-cls-instance-p1
				      (remove lit1 cls1 :test #'equal)
				      (cdr cls2)
				      new-bind
				      ))
			       'FAIL))
			 (return return-bind)
			 ))
		    ))
	      ))))


;;  determines if exp2 is an INSTANCE of exp1; if so, then a substitution S
;;  is returned such that (exp1)(S) = exp2; otherwise "FAIL" is returned
;;
;;  NOTES: instance substitution S *COULD* potentially be "nil"
;;      
;;	this function essentially performs "one-way" matching
;;
;;	exp1 and exp2 are both *either* INDIVIDUAL LITERALS *OR*
;;	LISTS OF LITERALS (i.e.- a clause)

(defun s-instance-p (exp1 exp2 &optional bindings)
  (cond 
   ((equal exp1 exp2) 
    bindings)
   ((var-p exp1)
    (s-instantiate-var exp1 exp2 bindings))
   ((or (var-p exp2) (not (listp exp1)) (not (listp exp2))) 
    'FAIL)
   ((not (eq (setq bindings (s-instance-p (car exp1) (car exp2) bindings))
	     'FAIL))
    (s-instance-p (cdr exp1) (cdr exp2) bindings))
   (T 'FAIL)))

;;  determines if the given variable can be instantiated with the given
;;  expression (or if it is ALREADY instantiated with the given expression);
;;  if so, then the (possibly updated) binding list is returned; otherwise
;;  "FAIL" is returned

;; Now has to check if the expression is of the right sort:

(defun s-instantiate-var (var exp bindings)
  (let ((val (find-binding var bindings)))
       (cond 
	((and val (equal val exp))
	 bindings)
	((and (null val) (free-in var exp bindings) exp ;; exp can't be nil
	      (s-entails var exp))	;; Checks that sorts are right.
	 (cons (cons var exp) bindings))
	(T 'FAIL))))



;;  ==> "FULL" SORTED SUBSUMPTION DETECTION
;;
;;  determines if the first clause, "cls1", subsumes the second clause, "cls2",
;;  if so, "T" is returned, otherwise "FAIL" is returned
;; 
;;  NOTE: both "cls1" and "cls2" are lists of literals

;; Same as unsorted case, only now "ord-resolve" has to take sorts into
;; account.
;; COMPLICATED by the fact that need to define sorts of new objects;
;; there's probably a simpler way of doing this...

(defun const-subsumes-p (cls1 cls2 &optional const1 const2)
  (declare (ignore const1) (ignore const2))
  (let ((cls1-vars (remove-duplicates (bld-var-list cls1) :test #'equal))
	(cls2-vars (remove-duplicates (bld-var-list cls2) :test #'equal))
	(old-objects nil)
	(answer nil))
    (cond 
      ((and (null cls1-vars) (null cls2-vars))
       (if (subsetp cls1 cls2 :test #'equal)
	   T
	 'FAIL))
      (T (setq old-objects *objects*)
	 (setq answer
	 (do ((neg-inst-cls2 (if (not (null cls2-vars))
				 (subst-s-exp cls2
					      (mapcar #'(lambda (var)
								(let ((new-const (gentemp)))
								     (def-sortobject new-const (get-var-sort var))
								     (cons var new-const)
								     ))
						      cls2-vars))
			       cls2))
	      (rslvnt-lst (list cls1))
	      (empty-cls-fnd nil)
	      (rslvnt-lst-empty nil)
	      (ord-rslvnt-lst nil)
	      (tmp-lst nil nil))
	     
	     ((or empty-cls-fnd rslvnt-lst-empty)
	      (if empty-cls-fnd
		  t
		'FAIL))

	     (dolist (rslvnt rslvnt-lst)
		     (dolist (lit neg-inst-cls2)
			     (setq tmp-lst 
				   (append tmp-lst
					   (setq ord-rslvnt-lst (s-ord-reslve rslvnt lit)))) ;; sorted
			     (if (and (not (null ord-rslvnt-lst))
				      (eq (first ord-rslvnt-lst) '()))
				 (return (setq empty-cls-fnd t)))

			     )
		     (if empty-cls-fnd
			 (return nil)))
	     
	     (cond
	       ((null tmp-lst)
		(setq rslvnt-lst-empty T))
	       ((not empty-cls-fnd)
		(setq rslvnt-lst tmp-lst))))
	       ) ;; end setq
	 (setq *objects* old-objects)
	 ;; return objects to its old value.
	 answer
	 ))))


;;  compute the "ordered" resolvent obtainable by resolving
;;  the given literal "lit" against the first (i.e. - "leftmost")
;;  literal of the clause "cls"
;;
;;  NOTE: the literal "lit" is ASSUMED to be complementary to the
;;  leftmost literal of "cls" -- the negative literal involved is
;;  IMPLICITLY negated (i.e. - is negative, but has no "not" symbol
;;  as its first element)
;;
;;  if a resolvent is produced, it is returned as a single element of a list

(defun s-ord-reslve (cls lit)
  (let ((unify-rslts nil))
       (cond
	((equal (first cls) lit)
	 (list (rest cls)))
	(T (if (not (eq (setq unify-rslts
			      (s-unify (first cls) lit)) ;; sort-unify
			'FAIL))
	       (list (merge-left (subst-s-exp (rest cls) unify-rslts)))
	       nil)))))

;;  ================ END OF SUBSUMPTION DETECTION FUNCTIONS ==================


