;; hooked-on-FRAPPS - hsubsume.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;  ==> Obtain Backward Subsumed Nodes
;;
;;  Recovers ids subsumed by the given clause/const list, does NOT
;;  deactivate them. Note that constraints are needed now!

;; New: All the test functions should take constraints into account.
;; the arguments are: clause1, clause 2, const1, const2
;; It is the USER's responsibility to define them correctly.

(defun get-ids-that-subsume-clause-const
  (clause const &key (active T) (degree 'full) (weak nil) (answer T))
  ;; the key parameter "active" determines whether deactivated
  ;; subsumers are also returned. If T, only ACTIVE clauses are considered.
  (let ((subsmptn-test nil)
	(set-operation nil)
	(rslvnt-pred-list nil)
	(subsuming-cls-pred-list nil)
	(cls-id-list nil)
	(candidate-id-list nil)
	(lit-list nil)
	(results nil)
	(len nil)
	(rem-lit-list nil))
       (cond
	;; Note that all the tests should take constraint parameters too.
	((eq degree 'full)
	 (setq subsmptn-test #'const-subsumes-p)
	 (setq set-operation #'union))
	((eq degree 'instances)
	 (setq subsmptn-test #'const-instance-p)
	 (setq set-operation #'intersection))
	((eq degree 'variants)
	 (setq subsmptn-test #'const-variant-p)
	 (setq set-operation #'intersection))
	(t (err-messg-subsume "get-ids-that-subsume-clause-const")))
       (cond
	(subsmptn-test
	 (cond (answer (setq lit-list clause)
		       (setq len (clause-length lit-list)))
	       (T (setq lit-list (remove-ans-lits clause))
		  (setq len (length lit-list))))
	 (cond
	  ((eq set-operation #'intersection)
	   (setq candidate-id-list
		 (intersection (get-ids-of-length len)
			      (ret-clauses-cont-more-general-lits (first lit-list))))
	   (setq rem-lit-list (rest lit-list)))
	  (T (setq candidate-id-list nil)
	     (setq rem-lit-list lit-list)))
	 (dolist (lit rem-lit-list)
		 (setq candidate-id-list
		       (apply set-operation
			      (list candidate-id-list
				    (ret-clauses-cont-more-general-lits lit)))))
	 (cond
	  ((not (null candidate-id-list))
	   (if
	    (and weak (eq degree 'full) (< len *max-db-length*))
	    (let ((new-candidate-ids nil))
		 ;; In this case only clauses of length less than the
		 ;; possibly subsumed clause are tested:
		 (dotimes (cls-length len)
			  (setq new-candidate-ids
				(append new-candidate-ids
					(intersection candidate-id-list
						      (get-ids-of-length (1+ cls-length))
						      ))))
		 ;;;; (format t "~%Old Candidates: ~d~%" candidate-id-list)
		 (setq candidate-id-list new-candidate-ids)
		 ))
	   (cond
	    ((eq degree 'full)
	     ;; This pruning is not worth it in other cases!!! (it would work).
	     ;; maybe in the case of constraints it is always worth doing
	     ;; this...
	     (setq rslvnt-pred-list (get-all-pred-syms lit-list))
	     (setq cls-id-list candidate-id-list)
	     (dolist (cls-id cls-id-list)
		     (setq subsuming-cls-pred-list
			   (if answer (get-cls-preds cls-id)
			       (remove-ans-preds (get-cls-preds cls-id))
			       ))
		     (if (not (eq (set-difference subsuming-cls-pred-list
						  rslvnt-pred-list)
				  nil))
			 (setq candidate-id-list
			       (remove cls-id candidate-id-list))
			 ))))
	   (if candidate-id-list
	   (cond
	    (active
	     (if answer
		 ;; (and answer active)
		 (dolist (cls-id candidate-id-list nil)
			 (if (get-node-active cls-id)
			     (if (not (eq (apply subsmptn-test
						 (list (get-node-clause cls-id)
						       lit-list
						       (get-node-const cls-id)
						       const
						       ))
					  'FAIL))
				 (setq results (cons cls-id results))
				 )))
		 ;; (and (not answer) active)
		 (dolist (cls-id candidate-id-list nil)
			 (if (get-node-active cls-id)
			     (if (not (eq (apply subsmptn-test
						 (list (remove-ans-lits
							(get-node-clause cls-id))
						       lit-list
						       (get-node-const cls-id)
						       const
						       ))
					  'FAIL))
				 (setq results (cons cls-id results))
				 )))
		 ))
	    (T
	     (if answer
		 ;; (and answer (not active))
		 (dolist (cls-id candidate-id-list nil)
			 (if (not (eq (apply subsmptn-test
					     (list (get-node-clause cls-id)
						   lit-list
						   (get-node-const cls-id)
						   const
						   ))
				      'FAIL))
			     (setq results (cons cls-id results))
			     ))
		 ;; (and (not answer) (not active))
		 (dolist (cls-id candidate-id-list nil)
			 (if (not (eq (apply subsmptn-test
					     (list (remove-ans-lits
						    (get-node-clause cls-id))
						   lit-list
						   (get-node-const cls-id)
						   const
						   ))
				      'FAIL))
			     (setq results (cons cls-id results))
			     ))
		 ))))))
	 results)
	(T (values))
	)))


(defun get-ids-sub-by-clause-const-list
  (clause-const-list  &key (active T) (degree 'full) (weak nil) (answer T))
  (let ((subsmptn-test nil)
	(lit-list nil)
	(candidate-id-list nil)
	(del-list nil)
	(len nil)
	(cum-del-list nil)
	(clause nil)
	(const nil))
       (cond
	((eq degree 'full)
	 (setq subsmptn-test #'const-subsumes-p))
	((eq degree 'instances)
	 (setq subsmptn-test #'const-instance-p))
	((eq degree 'variants)
	 (setq subsmptn-test #'const-variant-p))
	(t (err-messg-subsume "get-ids-sub-by-clause-const-list")))
       (cond
	(subsmptn-test
	 (dolist (clause-const clause-const-list cum-del-list)
		 (setq clause (first clause-const))
		 (setq const (second clause-const))
		 (cond
		  (answer (setq lit-list clause)
			  (setq len (clause-length clause)))
		  (T (setq lit-list
		       (remove-ans-lits clause))
		     (setq len (length lit-list))))
		 (setq candidate-id-list
		       (ret-clauses-cont-instance-lits (first lit-list)))
		 ;; Note that this uses normal unification.

		 (if (not (eq degree 'full))
		     (setq candidate-id-list
			   (intersection candidate-id-list
					 (get-ids-of-length (clause-length lit-list))
					 )))
		 (dolist (lit (rest lit-list))
			 (setq candidate-id-list
			       (intersection candidate-id-list
					     (ret-clauses-cont-instance-lits lit))))
		 (setq candidate-id-list
		       (set-difference candidate-id-list cum-del-list))
		 (if
		  (and weak (> len 1))
		  (let ((new-candidate-ids nil))
		       ;; In this case only clauses of length greater than the
		       ;; possibly subsuming clause are tested:
		       (dotimes (cls-length (1+ (- *max-db-length* len)))
				(setq new-candidate-ids
				      (append new-candidate-ids
					      (intersection candidate-id-list
							    (get-ids-of-length (+ cls-length len))
							    ))))
		       (setq candidate-id-list new-candidate-ids)
		       ))
		 (setq del-list nil)
		 (if (not (null candidate-id-list))
		     ;; Now have 4 cases, depending on the answer and active flags:
		 (cond
		  (active
		   (if answer
		       ;; (and active answer)
		       (dolist (candidate-id candidate-id-list)
			       (if (get-node-active candidate-id)
				   (if (not (eq (apply subsmptn-test
						       (list lit-list
							     (get-node-clause candidate-id)
							     const
							     (get-node-const candidate-id)
							     ))
						'FAIL))
				       (setq del-list (cons candidate-id del-list)))
				   ))
		       ;; (and active (not answer))
		       (dolist (candidate-id candidate-id-list)
			       (if (get-node-active candidate-id)
				   (if (not (eq (apply subsmptn-test
						       (list lit-list
							     (remove-ans-lits
							      (get-node-clause candidate-id))
							     const
							     (get-node-const candidate-id)
							     ))
						'FAIL))
				       (setq del-list (cons candidate-id del-list)))
				   ))
		       ))
		  (T
		   (if answer
		       ;; (and (not active) answer)
		       (dolist (candidate-id candidate-id-list)
			       (if (not (eq (apply subsmptn-test
						   (list lit-list
							 (get-node-clause candidate-id)
							 const
							 (get-node-const candidate-id)
							 ))
					    'FAIL))
				   (setq del-list (cons candidate-id del-list))))
		       ;; (and (not active) (not answer))
		       (dolist (candidate-id candidate-id-list)
			       (if (not (eq (apply subsmptn-test
						   (list lit-list
							 (remove-ans-lits
							  (get-node-clause candidate-id))
							 const
							 (get-node-const candidate-id)
							 ))
					    'FAIL))
				   (setq del-list (cons candidate-id del-list))))
		       ))))
		 (if del-list (setq cum-del-list (append cum-del-list del-list)))
		 ))
	(T (values))
	)))



(defun get-ids-sub-by-clause-const
  (clause const &key (active T) (degree 'full) (weak nil) (answer T))
  (get-ids-sub-by-clause-const-list
   (list (list clause const))
   :active active :degree degree :weak weak :answer answer))

(defun giscc
  (cls const &key (active T) (degree 'full) (weak nil) (answer T))
  (get-ids-sub-by-clause-const-list
   (list cls const)
   :active active :degree degree :weak weak :answer answer))

(defun get-ids-sub-by-node
  (id &key (active T) (degree 'full) (weak nil) (answer T))
  (remove id
	  (get-ids-sub-by-clause-const-list
	   (list (list
		  (get-node-clause id)
		  (get-node-const id)
		  ))
	   :active active :degree degree :weak weak :answer answer))
  )

(defun gisn
  (id &key (active T) (degree 'full) (weak nil) (answer T))
  (get-ids-sub-by-node
   id :active active :degree degree :weak weak :answer answer))

(defun gitscc
  (cls const &key (active T) (degree 'full) (weak nil) (answer T))
  (get-ids-that-subsume-clause-const
   cls const :active active :degree degree :weak weak :answer answer))

(defun get-ids-that-subsume-node
  (id &key (active T) (degree 'full) (weak nil) (answer T))
  (remove id
	  (get-ids-that-subsume-clause-const
	   (get-node-clause id)
	   (get-node-const id)
	   :active active :degree degree :weak weak :answer answer)))

(defun gitsn
  (id &key (active T) (degree 'full) (weak nil) (answer T))
  (get-ids-that-subsume-node
   id :active active :degree degree :weak weak :answer answer))

;;  ==========================================================================
;;
;;
;;		SUBSUMPTION DEGREE DETECTION FUNCTIONS (UNSORTED)
;;
;;
;;  ===========================================================================

;; NOTE: These functions are the same as in the original FRAPPS.
;; Do NOT take into account constraints or specialized unifier.
;; Now they are only used for efficient indexing and retrieval of candidates
;; for real subsumption.


;;  ==> VARIANT DETECTION
;;
;;  determines if cls1 and cls2 are VARIANTS of each other, where both cls1 
;;  and cls2 are LITERALS. If cls1 and cls2 are variants, then "t" is 
;;  returned, otherwise "FAIL" is returned.
;;
;;  NOTE: cls1 and cls2 are LITERALS

(defun variant-p (cls1 cls2)
  (let* ((cls2-stdzed (stndze-vars-apart cls1 cls2))
	 (bind-list (unify cls1 cls2-stdzed))
	 (term-list nil))
	(cond
	 ((not (eq bind-list 'FAIL))
	  (dolist (bind-elt bind-list (if (equal (subst-s-exp cls1 bind-list)
						 cls2-stdzed)
					  t
					  'FAIL))
		  (if (var-p (rest bind-elt))
		      (if (not (member (rest bind-elt) term-list :test #'equal))
			  (setq term-list (cons (rest bind-elt) term-list))
			  (return 'FAIL))
		      (return 'FAIL))))
	 (t 'FAIL))))



;;  ==> INSTANCE DETECTION

;;  determines if exp2 is an INSTANCE of exp1; if so, then a substitution S
;;  is returned such that (exp1)(S) = exp2; otherwise "FAIL" is returned
;;
;;  NOTES: instance substitution S *COULD* potentially be "nil"
;;      
;;	this function essentially performs "one-way" matching
;;
;;	exp1 and exp2 are INDIVIDUAL LITERALS

(defun instance-p (exp1 exp2 &optional bindings)
  (cond 
    ((equal exp1 exp2) 
     bindings)
    ((var-p exp1)
     (instantiate-var exp1 exp2 bindings))
    ((or (var-p exp2) (not (listp exp1)) (not (listp exp2))) 
     'FAIL)
    ((not (eq (setq bindings (instance-p (car exp1) (car exp2) bindings))
	      'FAIL))
     (instance-p (cdr exp1) (cdr exp2) bindings))
    (t 'FAIL)))

;;  determines if the given variable can be instantiated with the given
;;  expression (or if it is ALREADY instantiated with the given expression);
;;  if so, then the (possibly updated) binding list is returned; otherwise
;;  "FAIL" is returned

(defun instantiate-var (var exp bindings)
  (let ((val (find-binding var bindings)))
    (cond 
      ((and val (equal val exp))
       bindings)
      ((and (null val) (free-in var exp bindings) exp)  ;; exp can't be nil
       (cons (cons var exp) bindings))
      (t 'FAIL))))



;;  ==> "FULL" SUBSUMPTION DETECTION
;;
;;  determines if the first clause, "cls1", subsumes the second clause, "cls2",
;;  if so, "true" is returned, otherwise "FAIL" is returned
;; 
;;  NOTE: both "cls1" and "cls2" are lists of literals

(defun subsumes-p (cls1 cls2)
  (let ((cls1-vars (remove-duplicates (bld-var-list cls1) :test #'equal))
	(cls2-vars (remove-duplicates (bld-var-list cls2) :test #'equal)))

    (cond 
      ((and (null cls1-vars) (null cls2-vars))
       (if (subsetp cls1 cls2 :test #'equal)
	   t
	 'FAIL))
      (T (do ((neg-inst-cls2 (if (not (null cls2-vars))
				 (subst-s-exp cls2
					      (mapcar #'(lambda (var)
							  (cons var (gentemp)))
						      cls2-vars))
			       cls2))
	      (rslvnt-lst (list cls1))
	      (empty-cls-fnd nil)
	      (rslvnt-lst-empty nil)
	      (ord-rslvnt-lst nil)
	      (tmp-lst nil nil))
	     
	     ((or empty-cls-fnd rslvnt-lst-empty)
	      (if empty-cls-fnd
		  t
		'FAIL))

	     (dolist (rslvnt rslvnt-lst)
		     (dolist (lit neg-inst-cls2)
			     (setq tmp-lst 
				   (append tmp-lst
					   (setq ord-rslvnt-lst (ord-reslve rslvnt lit))))
			     (if (and (not (null ord-rslvnt-lst))
				      (eq (first ord-rslvnt-lst) '()))
				 (return (setq empty-cls-fnd t)))

			     )
		     (if empty-cls-fnd
			 (return nil)))
	     
	     (cond
	       ((null tmp-lst)
		(setq rslvnt-lst-empty t))
	       ((not empty-cls-fnd)
		(setq rslvnt-lst tmp-lst))))))))


;;  compute the "ordered" resolvent obtainable by resolving
;;  the given literal "lit" against the first (i.e. - "leftmost")
;;  literal of the clause "cls"
;;
;;  NOTE: the literal "lit" is ASSUMED to be complementary to the
;;  leftmost literal of "cls" -- the negative literal involved is
;;  IMPLICITLY negated (i.e. - is negative, but has no "not" symbol
;;  as its first element)
;;
;;  if a resolvent is produced, it is returned as a single element of a list

;;  NOTE: This function used by regular subsumption procedure.
;;  Does not use constraints.

(defun ord-reslve (cls lit)
  (let ((unify-rslts nil))
       (cond
	((equal (first cls) lit)
	 (list (rest cls)))
	(T (if (not (eq (setq unify-rslts
			      (unify (first cls) lit))
			'FAIL))
	       (list (merge-left (subst-s-exp (rest cls) unify-rslts)))
	       nil)))))

;;  ================ END OF SUBSUMPTION DETECTION FUNCTIONS ==================

