;; hooked-on-FRAPPS - hsession.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Note: hooked-on frapps sessions are INCOMPATIBLE with FRAPPS.

(defvar *session-suffix* ".ssn");; suffix for session files

(defun f-fname (str)		;; FRAPPS session filename
  (concatenate 'string (string str) *session-suffix*)
  )

;;  save the current FRAPPS session
;;
;;                         *** IMPORTANT ***
;;
;;	Due to *bug* in KCL "read-line", the first call to "read-line"
;;	is *necessary* in order to "eat" the initial <cr-lf> entered 
;;	after "manually" invoking the function.  This "bug" doesn't 
;;	exist in the LUCID or ACL implementation. Thus, the first "read-line"
;;	must be **removed** when porting this code to the LUCID or ACL
;;	environment.
;;	This also applies to the "save-derivation" and "resume-session"
;;	functions in this same file.

;;	NEW: The code can be ported to and from KCL by setting the
;;	*kcl-bug* global variable in init.lsp to T (for KCL) or nil.


(defun save-session (file)
  ;; THIS function call **NOT* needed by LUCID or ACL:
  (if *kcl-bug* (read-line))

  (let ((real-file (f-fname file)))
       (if (not (probe-file real-file))
	   (with-open-file (str real-file :direction :output)
			   (format t "~% Saving session...~%")
			   (print '****H-FRAPPS-SESSION**** str)
			   (save-all-globals str)
			   (save-node-db-contents str)
			   (save-priority-queue-contents str)
			   (format t "~% The current session has been saved in '~d' " real-file))
	   (format t "~% ERROR: The file '~d' already exists; session not saved" real-file)
	   ))
  (values))

;; The following function saves everything but the priority queue:

(defun save-derivation (file)
  ;; THIS function call **NOT* needed by LUCID or ACL:
  (if *kcl-bug* (read-line))
  (let ((real-file (f-fname file)))
       (if (not (probe-file real-file))
	   (with-open-file (str real-file :direction :output)
			   (format t "~% Saving derivation...~%")
			   (print '****H-FRAPPS-SESSION**** str)
			   (save-all-globals str)
			   (save-node-db-contents str)
			   (print '***end-priority-queue*** str)
			   (format t "~% The current DERIVATION has been saved in '~d' " real-file))
	   (format t "~% ERROR: The file '~d' already exists; derivation not saved" real-file)
	   ))
  (values))

(defun list-user-globals () nil) ;; do not print anything

(defun save-all-globals (str)
  (print (list-user-globals) str)
  (print *unifier* str)
  (print *singleton* str)
  (print *general-unifier* str)

  (print *support-set* str)
  (print *last-id* str)
  (print *depth* str)
  (print *empty-cls-ids* str)
  (print *answer-cls-ids* str)
  (print *factor-flag* str)
  (print *max-length* str)
  (print *max-complexity* str)
  (print *print-back-sub-clauses* str)
  (print *print-inference-errors* str)
  (print *print-access-errors* str)
  (print *sld-selection-fn* str)
  (print *queue-on* str)
  (print *pair-select-function* str)
  (print *cost-function-components* str)
  (print *cost-function-weights* str)
  (print *max-cost* str)
  (print *cost-function-single-components* str)
  (print *cost-function-single-weights* str)
  (print *max-single-cost* str)
  )

;;  save the contents of the global node database in the file associated with 
;;  the specified stream

(defun save-node-db-contents (stream)
  (print '***begin-node*** stream)
  (maphash #'(lambda (key val)
		     (declare (ignore key))
		     (print (construct-list-from-node val) stream))
	   *node-db*)
  (print '***end-node*** stream)
  )

;;  resume a previously "saved" FRAPPS session 
;;

(defun resume-session (file)
  ;; THIS function call **NOT* needed by LUCID or ACL:
  (if *kcl-bug* (read-line))
  (let ((real-file (f-fname file)))
       (if (not (null (probe-file real-file)))
	   (with-open-file (str real-file :direction :input)
			   (cond ((not (equal (read str) '****H-FRAPPS-SESSION****))
				  (format t "~% The file '~d' is not a valid H-FRAPPS session file" real-file)
				  )
				 (T
				  (format t "~% Resuming session...~%")
				  (dbss-reset)
				  (restore-all-globals str)
				  (restore-node-db-contents str)
				  (update-all-databases)
				  (restore-priority-queue-contents str)
				  (format t "~% The session saved in '~d' has been recovered" real-file)))
			   )
	   (format t "~% ERROR: The file '~d' does not exist" real-file)
	   ))
  (values))

(defun restore-user-globals (list) list) ;; do not do anything.

(defun restore-all-globals (str)
  (restore-user-globals (read str))
  (setq *unifier* (read str))
  (setq *singleton* (read str))
  (setq *general-unifier* (read str))

  (setq *support-set* (read str))
  (setq *last-id* (read str))
  (setq *depth* (read str)) 
  (setq *empty-cls-ids* (read str))
  (setq *answer-cls-ids* (read str))
  (setq *factor-flag* (read str))
  (setq *max-length* (read str))
  (setq *max-complexity* (read str))
  (setq *print-back-sub-clauses* (read str))
  (setq *print-inference-errors* (read str))
  (setq *print-access-errors* (read str))
  (setq *sld-selection-fn* (read str))
  (setq *queue-on* (read str))
  (setq *pair-select-function* (read str))
  (setq *cost-function-components* (read str))
  (setq *cost-function-weights* (read str))
  (setq *max-cost* (read str))
  (setq *cost-function-single-components* (read str))
  (setq *cost-function-single-weights* (read str))
  (setq *max-single-cost* (read str))
  )

;; restore the contents of the previously saved databases

(defun restore-node-db-contents (stream)
  (do ((input nil))
      ((equal input '***end-node***) nil)
      (setq input (read stream))
      (if (listp input) 
	  (setf (gethash (first input) *node-db*) (construct-node-from-list
						   input)))))

(defun list-to-user-field (list) list)  ;; The Identity

(defun construct-node-from-list (list)
  (make-clause :id (nth 0 list)
	       :lit-list (nth 1 list)
	       :left-par (nth 2 list)
	       :right-par (nth 3 list)
	       :children nil	;; restored later
	       :max-subscr (nth 4 list)
	       :pred-list (nth 5 list)
	       :depth (nth 6 list)
	       :user-field (list-to-user-field (nth 7 list))
	       :deriv-mthd (nth 8 list)
	       :active (nth 9 list)
	       :constraints (list-to-const (nth 10 list))
	       ))

;; The following are defaults; users can redefine them to make storage
;; more efficient.

(defun const-to-list (const) const)
(defun list-to-const (lst) lst)

(defun user-field-to-list (user-fld) user-fld) ;; The Identity

(defun construct-list-from-node (node)
  (list (clause-id node)
	(clause-lit-list node)
	(clause-left-par node)
	(clause-right-par node)
	(clause-max-subscr node)
	(clause-pred-list node)
	(clause-depth node)
	(user-field-to-list (clause-user-field node))
	(clause-deriv-mthd node)
	(clause-active node)
	(const-to-list (clause-constraints node))
	))


(defun update-all-databases ()
  (maphash #'(lambda (key val)
		     (declare (ignore key))
		     (session-update-clause val))
	   *node-db*)
  (setq *base-set* (get-ids-at-level 0))
  )

(defun session-update-clause (cls) ;; cls is a clause (node) structure.
  (let* ((node-id (clause-id cls))
	 (level (clause-depth cls))
	 (lvl-lst (gethash level *level-db*))
	 )
	(setf (gethash level *level-db*)
	      (append lvl-lst (list node-id)))
	
	;; (add-cls-lits-to-lit-db node-id)
	;; "Writing this out" might make it more efficient:
	(dolist (lit (clause-lit-list cls))
		(update-lit-db-add lit node-id))
	(update-cls-length-db node-id)
	))

;;  delete a previously "saved" H-FRAPPS session

(defun delete-session (file)
  (let ((real-file (f-fname file))
	(is-valid nil))
       (cond
	((probe-file real-file)
	 (with-open-file (str real-file :direction :input)
			 (setq is-valid (equal (read str) '****H-FRAPPS-SESSION****)))
	 (cond ((not is-valid)
		(format t "~% The file '~d' is not a valid H-FRAPPS session file" real-file))
	       (T
		(format t "~% Are you sure?")
		(if *kcl-bug* (read-line))
		(cond ((user-choice)
		       (delete-file real-file)
		       (format t "~% The file '~d' has been deleted" real-file))
		      )
		)))
	(T (format t "~% The file '~d' does not exist" real-file))
	)
       (values)))

