;; hooked-on-FRAPPS - hinit.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;; Global variables used in this file:

(defvar *hooked-version* T)
(defvar *kcl-bug* nil)
(defvar *h-frapps-dir* "")
(defvar *shared-dir* "")
(defvar *compiled-dir* "")
(defvar *demos-dir* "")
(defvar *source-suffix* ".lsp")
(defvar *compiled-suffix* "")
(defvar *h-frapps-files* "")
(defvar *shared-files* "")

;; ======================= BEGIN INSTALLATION GLOBALS =====================

(setq *kcl-bug* nil)

(if (string-equal (lisp-implementation-type) "Kyoto Common Lisp")
  (setq *kcl-bug* T))

;; *kcl-bug* should be set to "T" if a version of KCL with the
;; "read-line" bug is being used, and "nil" otherwise.
;; Otherwise, the start-frapps and resume-session functions can appear
;; to be "hung-up", when they are really waiting for a line to be read in.

;; ========================= FILE LOCATIONS ===============================

;; defaults are for the CS341 IBM installation:

;; This should be the directory where all H-FRAPPS source files reside:

(setq *h-frapps-dir* "/usersb/cs341/src/frapps/hooked")

;; Directory where "shared" with the normal FRAPPS reside
;; (usually normal FRAPPS directory):

(setq *shared-dir* "/usersb/cs341/src/frapps")

;; This should be the directory where all H-FRAPPS compiled files reside:
;; Note that compiled files in general CANNOT be shared between the normal
;; and hooked FRAPPS (since the structure definitions are different):

(setq *compiled-dir* "/usersb/cs341/bin/frapps/hooked")

;; This should be the directory where all the demos are located:

(setq *demos-dir* "/usersb/cs341/lib/frapps-demos/hdemos")

;; The following two variables should be set according to the version
;; of LISP being used:

(setq *source-suffix* ".lsp") ;; suffix for source files
(setq *compiled-suffix* ".o") ;; suffix for compiled files

;; Try to customize above variables for different machines, versions of Lisp:

(if (string-equal (lisp-implementation-type) "Allegro CL")
  (setq *compiled-suffix* ".fasl")
  )

(if (string-equal (lisp-implementation-type) "Lucid Common Lisp")
  (cond ((string-equal (machine-instance) "frege")
	 (setq *compiled-suffix* ".bbin")
	 (setq *h-frapps-dir* "/u/uribe/frapps/hooked")
	 (setq *shared-dir* "/u/uribe/frapps")
	 (setq *compiled-dir* "/u/uribe/hbin")
	 (setq *demos-dir* "/u/uribe/frapps/hooked/hdemos")
	 )
	(T (setq *compiled-suffix* ".sbin") ;; For the AI Suns
	   (setq *h-frapps-dir* "/mnt9/home/AI/frisch/uribe/frapps/hooked")
	   (setq *shared-dir* "/mnt9/home/AI/frisch/uribe/frapps")
	   (setq *compiled-dir* "/mnt9/home/AI/frisch/uribe/hbin")
	   (setq *demos-dir* "/mnt9/home/AI/frisch/uribe/frapps/hooked/hdemos")
	   )))

;; KCL on the AI suns:
(if (string-equal (lisp-implementation-type) "Kyoto Common Lisp")
  (cond ((string-equal (machine-version) "SUN")
	 (setq *h-frapps-dir* "/mnt9/home/AI/frisch/uribe/frapps/hooked")
	 (setq *shared-dir* "/mnt9/home/AI/frisch/uribe/frapps")
	 (setq *compiled-dir* "/mnt9/home/AI/frisch/uribe/hbin")
	 (setq *demos-dir* "/mnt9/home/AI/frisch/uribe/frapps/hooked/hdemos")
	 )))


;; ======================= END  INSTALLATION GLOBALS =====================


(defun frapps-demo-filename (str)
  (concatenate 'string *demos-dir* "/" str *source-suffix*))

(defun frapps-compiled-demo-filename (str)
  (concatenate 'string *demos-dir* "/" str *compiled-suffix*))

(defun frapps-source-filename (str)
   (concatenate 'string *h-frapps-dir* "/" str *source-suffix*))

(defun frapps-compiled-filename (str)
   (concatenate 'string *compiled-dir* "/" str *compiled-suffix*))

(defun frapps-shared-filename (str)	;; always source
   (concatenate 'string *shared-dir* "/" str *source-suffix*))

(defun load-source-file (str)
  (load (frapps-source-filename str)))

(defun load-object-file (str)
  (load (frapps-compiled-filename str)))

(defun load-shared-source-file (str)
  (load (frapps-shared-filename str)))

(defun load-demo (str)
  (if (probe-file (frapps-compiled-demo-filename str))
      (load (frapps-compiled-demo-filename str))
      (load (frapps-demo-filename str))))

;; =======================================================================

;; Initialization function:

(defun start-frapps ()
  (format t "~% Hooked-on-FRAPPS 2.0")
  (format t "~% KRRG, University of Illinois at Urbana-Champaign, 1991~%")
  (if (probe-file (frapps-compiled-filename "hdbss"))
      ;; assume that if this file is there, all of them are...
      (option-start-frapps)
      (load-hooked-on-frapps-source))

  ;; (set-pseudo-cls-globals) ;; No longer used.

  (reset-frapps)
  (format t "~% hooked-on-FRAPPS ready...")
  (values)
  )


(defun option-start-frapps ()

  (if *kcl-bug* (read-line))

  (do ((version nil))
      ((or (string-equal version "i") (string-equal version "c"))
       (cond
	((string-equal version "i")
	 (format t "~%loading H-FRAPPS \"source\" modules...~2%")
	 (load-hooked-on-frapps-source))
	((string-equal version "c")
	 (format t "~%loading H-FRAPPS \"object\" modules...~2%")
	 (load-hooked-on-frapps-compiled))))
      (format t "~2% Enter \"i\" to load the INTERPRETED Hooked-on-FRAPPS code,")
      (format t  "~%       \"c\" to load the COMPILED code.")
      (format t "~2% Your choice: ")
      (setq version (read-line))
      ))

;; List of the names of all the H-FRAPPS files, excluding those
;; shared with FRAPPS:

(setq *h-frapps-files*
  (list
   "hglvads"	;; global vars and data structures 
   "hdbss"	;; database support system 
   "hinfprims"	;; inference primitives 
   "hdelstrats"	;; deletion strategies
   "hsubsume"	;; subsumption detection functions
   "hsession"	;; session management functions
   "hsld"	;; sld-resolution with constraints

   ;; NOTE: The default unifier is the unconstrained one.
   ))


;; List of the names of all files shared by H-FRAPPS and FRAPPS:

(setq *shared-files*
  (list
   "dbshared"	;; shared database support system 
   "unifylits"	;; normal unification and literal primitives.
   "prqmgmt"	;; priority queue management
   "costfns"	;; cost function components
   "outputfns"	;; output functions 
   "tpmisc"	;; miscellaneous functions

   ;; Demos could also be loaded separately, with (load-demos).
   "run-demo"	;; for running demos
   "user"	;; search procedure used in the above
   ))


;; ============= Functions that do the actual loading: ============


;;  load the **LISP SOURCE** version of H-FRAPPS:

(defun load-hooked-on-frapps-source ()
  (dolist (file *h-frapps-files*)
	  (load-source-file file))
  (dolist (file *shared-files*)
	  (load-shared-source-file file))
  (reset-frapps))


;;  load the **LISP OBJECT CODE** version of H-FRAPPS

;; note that both H-FRAPPS and shared OBJECT file should be in the same place:

(defun load-hooked-on-frapps-compiled ()
  (dolist (file (append *h-frapps-files* *shared-files*))
	  (load-object-file file))
  (reset-frapps))

;; Loading the simple sorted unifier:

(defun load-simple-sorts ()
  (let ((flag nil))
       (cond
	((probe-file (frapps-compiled-filename "sorts"))
	 (format t "~% Load compiled files? ")
	 (if *kcl-bug* (read-line))
	 (cond
	  ((user-choice)
	   (load-object-file "sorts")	   ;; maintenance of sorts database
	   (load-object-file "sort-unify")   ;; sorted unifier
	   (load-object-file "sort-subsume") ;; subsumption procedures.
	   (setq flag T)
	   ))
	 ))
       (if (null flag)
	   (progn
	    (load-source-file "sorts")
	    (load-source-file "sort-unify")
	    (load-source-file "sort-subsume")
	    )))
  (values))



;;  load the **LISP SOURCE** version of the theorem proving system 
;;  discussed in section 8.3 of thesis (Michael K. Mitchell, 1989)

(defun load-prover ()
  (load-source-file "prover-defs")	;; prover global defs
  (load-source-file "prover-funcs")	;; prover function defs
  (load-source-file "prover-strats")	;; prover inference strategies
  )

(defun load-demos ()
  (let ((flag nil))
       (cond
	((and (probe-file (frapps-compiled-filename "run-demo"))
	      (probe-file (frapps-compiled-filename "user")))
	 (format t "~% Load compiled files? ")
	 (if *kcl-bug* (read-line))
	 (cond
	  ((user-choice)
	   (load-object-file "run-demo") ;; "Interface" for demos
	   (load-object-file "user")     ;; Search procedure
	   (setq flag T)
	   ))
	 ))
       (if (null flag)
	   (progn
	    (load-shared-source-file "run-demo")
	    (load-shared-source-file "user")
	    )))
  (values))


;;               ============================================

;; Compiling FRAPPS: Compiles those files whose object files don't
;; exist in the given directory, or whose compiled file is older
;; than the source file.

(defun compff (str)	;; "Compile Frapps Filename"
  (if (or (not (probe-file (frapps-compiled-filename str)))
	  (< (file-write-date (frapps-compiled-filename str))
	     (file-write-date (frapps-source-filename str)))
	  )
      (compile-file (frapps-source-filename str)
		    :output-file (frapps-compiled-filename str)
		    )))

(defun comp-shared-ff (str) ;; "Compile Shared Frapps Filename"
  (if (or (not (probe-file (frapps-compiled-filename str)))
	  (< (file-write-date (frapps-compiled-filename str))
	     (file-write-date (frapps-shared-filename str)))
	  )
      (compile-file (frapps-shared-filename str)
		    :output-file (frapps-compiled-filename str)
		    )))

(defun compile-frapps ()
  (dolist (file *h-frapps-files*)
	  (compff file))
  (dolist (file *shared-files*)
	  (comp-shared-ff file))
  )

(defun compile-demos ()
  (comp-shared-ff "run-demo")
  (comp-shared-ff "user")
  )

(defun compile-simple-sorts ()
  (compff "sorts")
  (compff "sort-unify")
  (compff "sort-subsume")
  )


;;               ============================================


;; Loading hooked demos:

(defun load-h-demo()
  (let ((answer ""))
       (format t "~% Demo sorted test problems:")
       (format t "~%    1: love")
       (format t "~%    2: prob")
       (format t "~%    3: shub-sort")
       (format t "~%    4: shub2")
       (format t "~%    5: tweety")
       (format t "~2%    6: Already Loaded")
       (format t "~%    0: Other~%")
       (do ()
	   ((or (string-equal answer "1")
		(string-equal answer "2")
		(string-equal answer "3")
		(string-equal answer "4")
		(string-equal answer "5")
		(string-equal answer "6")
		(string-equal answer "0")))
	   (format t "~% Enter 0-5: ")
	   (setq answer (read-line))
	   )
       (format t "~%")
       (cond
	((string-equal answer "1") (load-demo "love"))
	((string-equal answer "2") (load-demo "prob"))
	((string-equal answer "3") (load-demo "shub-sort"))
	((string-equal answer "4") (load-demo "shub2"))
	((string-equal answer "5") (load-demo "tweety"))
	((string-equal answer "0")
	 (format t "~% Enter complete filename: ")
	 (do () ((not (equal filename "")))
	     (setq filename (read-line)))
	 (reset-frapps)
	 (load filename)
	 ))
       ))

