;; hooked-on-FRAPPS - hdelstrats.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;  ==> Delete Forward Subsumed Resolvents
;;
;;  determine those members of the list of given resolvents which
;;  are NOT forward subsumed by *existing* clauses (nodes), return those 
;;  resolvents which are NOT forward subsumed

;; NEW: All the test functions should take constraints into account.
;; the arguments are: clause1, clause 2, const1, const2
;; It is the USER's responsibility to define them correctly.

(defun delete-fwd-sub-resolvents
  (rslvnt-list &key (active T) (degree 'full) (weak nil) (answer T))
  (let ((subsmptn-test nil)
	(set-operation nil)
	(rslvnt-pred-list nil)
	(subsuming-cls-pred-list nil)
	(keep-list nil)
	(cls-id-list nil)
	(candidate-id-list nil)
	(lit-list nil)
	(lit-list-constraints nil)
	(del-flag nil)
	(len nil)
	(rem-lit-list nil))
    (cond
     ;; Note that all the tests should take constraint parameters too.
     ((eq degree 'full)
      (setq subsmptn-test #'const-subsumes-p)
      (setq set-operation #'union))
     ((eq degree 'instances)
      (setq subsmptn-test #'const-instance-p)
      (setq set-operation #'intersection))
     ((eq degree 'variants)
      (setq subsmptn-test #'const-variant-p)
      (setq set-operation #'intersection))
     (t (err-messg-subsume "delete-fwd-sub-resolvents")))
    (cond
     (subsmptn-test
	(dolist (rslvnt rslvnt-list keep-list)
		(setq del-flag nil)
		(setq lit-list-constraints (resolvent-info-constraints rslvnt))
		(cond (answer
		       (setq lit-list (resolvent-info-clause rslvnt))
		       (setq len (clause-length lit-list)))
		      (T (setq lit-list (remove-ans-lits
					 (resolvent-info-clause rslvnt)))
			 (setq len (length lit-list))))
		(cond
		 ((eq set-operation #'intersection)
		  (setq candidate-id-list
			(intersection (get-ids-of-length len)
				      (ret-clauses-cont-more-general-lits (first lit-list))))
		  (setq rem-lit-list (rest lit-list)))
		 (T (setq candidate-id-list nil)
		    (setq rem-lit-list lit-list)))
		(dolist (lit rem-lit-list)
			(setq candidate-id-list
			      (apply set-operation
				     (list candidate-id-list
					   (ret-clauses-cont-more-general-lits lit)))))

		(cond
		 ((not (null candidate-id-list))
		  (if
		   (and weak (< len *max-db-length*))
		   (let ((new-candidate-ids nil))
			;; In this case only clauses of length less than or =
			;; to that of the possibly subsumed clause are tested:
			(dotimes (cls-length (length lit-list))
				 (setq new-candidate-ids
				       (append new-candidate-ids
					       (intersection candidate-id-list
							     (get-ids-of-length (1+ cls-length))
							     ))))
			;;;; (format t "~%Old Candidates: ~d~%" candidate-id-list)
			(setq candidate-id-list new-candidate-ids)
			))
		  (cond
		   ((eq degree 'full)
		    (setq rslvnt-pred-list 
			  (get-all-pred-syms (resolvent-info-clause rslvnt)))
		    (setq cls-id-list candidate-id-list)
		    (dolist (cls-id cls-id-list)
			    (setq subsuming-cls-pred-list 
				  (if answer (get-cls-preds cls-id)
				      (remove-ans-preds (get-cls-preds cls-id))
				      ))
			    (if (not (eq (set-difference subsuming-cls-pred-list
							 rslvnt-pred-list)
					 nil))
				(setq candidate-id-list
				      (remove cls-id candidate-id-list))
				))))
		  (cond
		   (active
		    (if answer
			;; (and answer active)
			(setq del-flag
			      (dolist (cls-id candidate-id-list nil)
				      (if (get-node-active cls-id)
					  (if (not (eq (apply subsmptn-test
							      (list (get-node-clause cls-id)
								    lit-list
								    (get-node-const cls-id)
								    lit-list-constraints
								    ))
						       'FAIL))
					      (return t)))))
			;; (and (not answer) active)
			(setq del-flag
			      (dolist (cls-id candidate-id-list nil)
				      (if (get-node-active cls-id)
					  (if (not (eq (apply subsmptn-test
							      (list (remove-ans-lits
								     (get-node-clause cls-id))
								    lit-list
								    (get-node-const cls-id)
								    lit-list-constraints
								    ))
						       'FAIL))
					      (return t)))))
			))
		   (T
		    (if answer
			;; (and answer (not active))
			(setq del-flag
			      (dolist (cls-id candidate-id-list nil)
				      (if (not (eq (apply subsmptn-test
							  (list (get-node-clause cls-id)
								lit-list
								(get-node-const cls-id)
								lit-list-constraints
								))
						   'FAIL))
					  (return t))))
			;; (and (not answer) (not active))
			(setq del-flag
			      (dolist (cls-id candidate-id-list nil)
				      (if (not (eq (apply subsmptn-test
							  (list (remove-ans-lits
								 (get-node-clause cls-id))
								lit-list
								(get-node-const cls-id)
								lit-list-constraints
								))
						   'FAIL))
					  (return t))))
			)))
		  )
		 (T (setq del-flag nil))
		 )
 
		(if (not del-flag)
		    (setq keep-list (append keep-list (list rslvnt))))
		))
     ;; (t rslvnt-list)
     (T (values))
     )))



;;  ==> Deactivate Backward Subsumed Nodes
;;
;;  determines which (if any) *existing* clauses (nodes) are backward
;;  subsumed by members of the list of given resolvents and deactivates
;;  them. Returns the list of node ids which *ARE* backward subsumed.
;;
;;
;;  NOTE: CAN TAKE **ANSWER** LITERALS INTO CONSIDERATION.
;;

(defun deactivate-back-sub-nodes
  (rslvnt-list &key (degree 'full) (weak nil) (answer T))
  (let ((subsmptn-test nil)
	(lit-list nil)
	(lit-list-constraints nil)
	(candidate-id-list nil)
	(del-list nil)
	(len nil)
	(cum-del-list nil))
    (cond
     ((eq degree 'full)
      (setq subsmptn-test #'const-subsumes-p))
     ((eq degree 'instances)
      (setq subsmptn-test #'const-instance-p))
     ((eq degree 'variants)
      (setq subsmptn-test #'const-variant-p))
     (T (err-messg-subsume "deactivate-back-sub-nodes")))
    (cond
     (subsmptn-test
      (dolist (rslvnt rslvnt-list cum-del-list)
	      (cond
	       (answer (setq lit-list (resolvent-info-clause rslvnt))
		       (setq len (clause-length lit-list)))
	       (T (setq lit-list
			(remove-ans-lits (resolvent-info-clause rslvnt)))
		  (setq len (length lit-list))
		  ))
	      (setq lit-list-constraints (resolvent-info-constraints rslvnt))
	      (setq candidate-id-list
		    (ret-clauses-cont-instance-lits (first lit-list)))
	      (if (not (eq degree 'full))
		  (setq candidate-id-list
			(intersection candidate-id-list
				      (get-ids-of-length (clause-length lit-list))
				      )))
	      (dolist (lit (rest lit-list))
		      (setq candidate-id-list
			    (intersection candidate-id-list
					  (ret-clauses-cont-instance-lits lit))))
	      (if
	       (and weak (eq degree 'full) (> len 1))
	       (let ((new-candidate-ids nil))
		    (dotimes (cls-length (1+ (- *max-db-length* len)))
			     (setq new-candidate-ids
				   (append new-candidate-ids
					   (intersection candidate-id-list
							 (get-ids-of-length (+ cls-length len))
							 ))))
		    (setq candidate-id-list new-candidate-ids)
		    ))
	      (setq del-list nil)
	      ;; Note that there is no active flag in this case:
	      (if
	       (not (null candidate-id-list))
	       (if answer
		   (dolist (candidate-id candidate-id-list)
			   (if (clause-active (gethash candidate-id *node-db*))
			       (if (not (eq (apply subsmptn-test
						   (list lit-list 
							 (get-node-clause candidate-id)
							 lit-list-constraints
							 (get-node-const candidate-id)))
					    'FAIL))
				   (setq del-list (cons candidate-id del-list)))))
		   (dolist (candidate-id candidate-id-list)
			   (if (clause-active (gethash candidate-id *node-db*))
			       (if (not (eq (apply subsmptn-test
						   (list lit-list
							 (remove-ans-lits
							  (get-node-clause candidate-id))
							 lit-list-constraints
							 (get-node-const candidate-id)))
					    'FAIL))
				   (setq del-list (cons candidate-id del-list)))))
		   ))
	      (cond
	       ((not (null del-list))
		(dolist (id del-list)
			(deactivate-node id))
		(if *print-back-sub-clauses*
		    (dolist (id del-list)
			    (found-back-sub-msg id
						(resolvent-info-clause rslvnt)
						)))
		(setq cum-del-list (append cum-del-list del-list))))))
     (t nil))))



;;  ==> Delete "Long" Resolvents
;;
;;  determines which resolvents from the given list of resolvents contain 
;;  more than the maximum allowable (i.e.- *max-length*) number of literals;
;;  returns the list of those resolvents that contain fewer than the maximum
;;  number of literals
;; 
;;  NOTE: rslvnt-list MUST be a list of resolvent-info STRUCTS

(defun delete-long-resolvents (rslvnt-list)
  (let ((keep-list nil))
    (dolist (rslvnt rslvnt-list keep-list)
	    (if (<= (clause-length (resolvent-info-clause rslvnt)) 
		    *max-length*)
		(setq keep-list (append keep-list (list rslvnt)))))))




;;  ==> Delete "Complex" Resolvents
;;
;;  determines which resolvents from the given list of resolvents have a 
;;  nesting "complexity" which is deeper than the maximum allowable 
;;  (i.e.- *max-complexity*); returns the list of those resolvents that 
;;  are less "complex" than the maximum complexity allowed
;; 
;;  NOTE: rslvnt-list MUST be a list of resolvent-info STRUCTS

(defun delete-complex-resolvents (rslvnt-list)
  (let ((keep-list nil))
    (dolist (rslvnt rslvnt-list keep-list)
	    (if (<= (clause-complexity (resolvent-info-clause rslvnt))
		    *max-complexity*)
		(setq keep-list (append keep-list (list rslvnt)))))))



;;  ==> Delete Tautologies
;;
;;  determines which resolvents from the given list of resolvents are 
;;  tautologies; returns the list of those resolvents that are NOT
;;  tautologies
;; 
;;  NOTE: rslvnt-list MUST be a list of resolvent-info STRUCTS
 
(defun delete-taut-resolvents (rslvnt-list)
  (let ((keep-list nil))
       (dolist (rslvnt rslvnt-list keep-list)
	       (if (not (taut-p (resolvent-info-clause rslvnt)))
		   (setq keep-list (append keep-list (list rslvnt)))))))



;; The following function is still included here for ``historical''
;; reasons:

;; determines those resolvents which are not already in the tree.
;; returns list of resolvents that are NOT already in the tree.
;; This is really "variant" forwards subsumption with no variables.
;; Not very useful, in general...

(defun delete-duplicate-resolvents (rslvnt-list)
  (let ((keep-list nil))
       (dolist (rslvnt (remove-duplicates rslvnt-list :test #'equal) keep-list)
	       (if (not (in-tree-p (resolvent-info-clause rslvnt)))
		   (setq keep-list (append keep-list (list rslvnt)))))))


;; Checks to see if clause is in the derivation tree:

(defun in-tree-p (clause)
  (let ((candidate-id-list nil)
	(lit-list nil))
       (dolist (lit clause lit-list)
	       (if (not (ans-lit-p lit))
		   (setq lit-list (append lit-list (list lit)))))
       
       (setq candidate-id-list
	     (ret-clauses-cont-equal-lits (first lit-list)))
       (dolist (lit (rest lit-list))
	       (setq candidate-id-list
		     (intersection candidate-id-list
				   (ret-clauses-cont-equal-lits lit))))
       
       ;; Now need to go through id list checking the clauses against "clause."
       ;; This returns the first node-id having a clause equal to "clause:"
       (is-clause-in-p clause (remove-duplicates candidate-id-list))
       ))


(defun is-clause-in-p (clause id-list)
  (cond ((null id-list) nil)
	((set-equalp clause (get-node-clause (car id-list))) (car id-list))
	(t (is-clause-in-p clause (cdr id-list)))
	))

;;  compute the "complexity" of a clause by determining the maximum functional
;;  nesting depth of any TERM of the literals of the given clause

(defun clause-complexity (lit-list)
  (let ((max-nest-depth 0)
	(nest-depth 0))
       (dolist (lit lit-list max-nest-depth)
	       (if (and (not (ans-lit-p lit))
			(> (setq nest-depth (fnd-max-nest-depth
					     (if (neg-lit-p lit)
						 (rest (rest lit))
						 (rest lit))))
			   max-nest-depth))
		   (setq max-nest-depth nest-depth)))))



;;  determines the maximum nesting depth of the given s-expression

(defun fnd-max-nest-depth (exp)
  (cond
   ((or (null exp) (atom exp) (var-p exp)) 0)
   (t (max (+ (fnd-max-nest-depth (car exp)) 1)
	   (fnd-max-nest-depth (cdr exp))))))


