;; FRAPPS - glvads.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;  =========================================================================
;;;;  =                                                                       =
;;;;  =                  FRAPPS GLOBAL VARIABLE DEFAULT SETTINGS              =
;;;;  =                                                                       =
;;;;  =========================================================================

;;;;  Note: A small number of other global variables, like
;;;;  *sld-selection-fn*, are defined in other files.

;;  variable read macro to translate ?x to (*var* x 1):

(defun var-reader (stream char)
  (declare (ignore char))
  `(*var* ,(read stream t nil t) 1))

;;  define "?" as the "variable" macro-character:

(set-macro-character #\? #'var-reader)


;;  ==============================
;;
;;         ====> GLOBAL DEFSTRUCTS
;;
;;  ==============================

  
;;  === Clause-Database related ===
;;
;;  defines the data structures used to implement the clause database


;;  "derivation node" structure
;;
;;  NOTE: "transparent" to user

(defstruct clause 
  id
  lit-list
  left-par
  right-par
  children	;; new
  max-subscr
  pred-list
  depth
  user-field	;; used to be called lambda
  deriv-mthd
  active)


;; "derivation node information" structure
;;
;;  NOTE: this is the "user visible" node information structure

(defstruct node-info
  id
  clause
  parents
  children	;; new
  level
  deriv-mthd
  user-field
  active	;; new; not visible to user before
  )

;;  "resolvent information" structure
;;
;;  NOTE: "visible" to user

(defstruct resolvent-info
  clause
  parents
  deriv-mthd
  user-field)


;;  === Priority-queue related ===


;;  priority queue "bucket" structure
;;
;;  NOTE: the priority queue is comprised of a sequence of these
;;        structures

(defstruct priority-bucket
  priority
  clause-pairs)


;;  priority queue bucket "clause pair" structure
;;
;;  NOTE: each priority queue bucket "holds" a sequence of
;;        these structures

(defstruct clause-pair
  priority-vector
  ids)


;;  ==========================
;;
;;     ====> GLOBAL PARAMETERS
;;
;;  ==========================


;;  === data base support system related ===

(defvar *print-inference-errors* T)
;; Flag for printing error messages originated in "resolve" and "factor"
;; when deactivated OR non-existing nodes are used.

;; Flag for printing error messages when non-existing node-ids are used
;; by get-* node-access functions:

(defvar *print-access-errors* T)

(defvar *last-id* 0) ;; (integer) denotes the last "assigned" integer node-id.

(defvar *depth* 0)   ;; (integer) specifies the level of the "deepest" resolvent

(defvar *base-set* nil)    ;; (list) specifies the id's of the "base" clauses

(defvar *support-set* nil) ;; (list) specifies the id's of the "support set"

(defvar *max-db-length* 0) ;; (integer) maximum clause length in the database



;;  === Priority Queue related

(defvar *queue-on* T) ;; indicates whether queue is used or not
		       ;; used to be called *priority-queue-on*

(defvar *priority-queue* nil)  ;; (list) used for the clause-pair "priority
                               ;; queue" mechanism

(defvar *pair-select-function* 'gen-pair-select-fn) ;; NEW

;; The following is no longer used:

;; (defvar *pseudo-cls* nil)   ;; create the "pseudo" clause -- gets initialized
                               ;; in function "start-frapps"
;; (defvar *pseudo-cls-info* nil)



;;  === "max" clause characteristics ===

;; Note: These have an effect only if the corresponding deletion strategy
;; 	 is used.

(defvar *max-length* most-positive-fixnum)    ;; (integer) max number of
                                                ;; literals a clause can have
(defvar *max-complexity* most-positive-fixnum)  ;; (integer) max depth to which
                                                ;; a literal can be nested


;;  === Cost Function related ===

;; default cost function components:

(defvar *cost-function-components* '(cls-depth-costfn))
(defvar *cost-function-weights* '(1))
(defvar *max-cost* (- most-positive-fixnum 1))

(defvar *cost-function-single-components* '(most-negative-costfn))
(defvar *cost-function-single-weights* '(1))
(defvar *max-single-cost* (- most-positive-fixnum 1))

;;  === Database Hash-tables ===

;;  allocates storage for the clause database hash-tables

;; NOTE: :test #'equal was changed to :test #'eql for those tables
;; indexed by integers...

(defvar *node-db* (make-hash-table :test #'eql))  ;; derivation node database
(defvar *level-db* (make-hash-table :test #'eql)) ;; nodes indexed by levels
(defvar *lit-db* (make-hash-table :test #'equal))   ;; literal database
(defvar *arg-retrv-db* (make-hash-table :test #'equal))  ;; arg. retrieval DB
(defvar *arg-dtct-db* (make-hash-table :test #'equal))  ;; arg. detection DB
(defvar *cls-length-db* (make-hash-table :test #'eql))  ;; nodes indexed by 
                                                        ;; length

;;  ==========================
;;
;;         ====> GLOBAL FLAGS
;;
;;  ==========================


;;  === clause processing flags ===

(defvar *factor-flag* nil)	;; enables/disables factoring

;; enables/disables printing of subsumed clauses:

(defvar *print-back-sub-clauses* T)

;;  === "event status" flags ===

(defvar *empty-cls-ids* nil) ;; node-ids of empty clauses
(defvar *answer-cls-ids* nil) ;; node-ids of answer clauses


;; === Resetting and printing flags:

;; Resetting flags:

(defun reset-defaults ()
  (setq *factor-flag* nil)
  (setq *max-length* most-positive-fixnum)
  (setq *max-complexity* most-positive-fixnum)
  (setq *print-back-sub-clauses* T)
  (setq *print-inference-errors* T)
  (setq *print-access-errors* T)
  (setq *sld-selection-fn* 'leftmost-select-fn)
  (setq *queue-on* T)
  (setq *pair-select-function* 'gen-pair-select-fn)
  (setq *cost-function-components* '(cls-depth-costfn))
  (setq *cost-function-weights* '(1))
  (setq *max-cost* (- most-positive-fixnum 1))
  (setq *cost-function-single-components* '(most-negative-costfn))
  (setq *cost-function-single-weights* '(1))
  (setq *max-single-cost* (- most-positive-fixnum 1))
  (values)
  )

(defun print-flags ()
  (format t "~% *factor-flag*: ~d" *factor-flag*)
  (format t "~% *max-length*: ~d" *max-length*)
  (format t "~% *max-complexity*: ~d" *max-complexity*)
  (format t "~% *print-back-sub-clauses*: ~d" *print-back-sub-clauses*)
  (format t "~% *print-inference-errors*: ~d" *print-inference-errors*)
  (format t "~% *print-access-errors*: ~d" *print-access-errors*)
  (format t "~% *sld-selection-fn*: ~d" *sld-selection-fn*)
  (format t "~%")
  (format t "~% *queue-on*: ~d" *queue-on*)
  (format t "~% *pair-select-function*: ~d" *pair-select-function*)
  (format t "~% *cost-function-components*: ~d" *cost-function-components*)
  (format t "~% *cost-function-weights*: ~d" *cost-function-weights*)
  (format t "~% *max-cost*: ~d" *max-cost*)
  (format t "~% *cost-function-single-components*: ~d"
	  *cost-function-single-components*)
  (format t "~% *cost-function-single-weights*: ~d"
	  *cost-function-single-weights*)
  (format t "~% *max-single-cost*: ~d" *max-single-cost*)
  (values)
  )

;; Printing database globals.
;; (They are reset in the "dbss-reset" function in "dbss.lsp".)

(defun print-graph-globals ()
  (format t "~% *base-set*: ~d" *base-set*)
  (format t "~% *support-set*: ~d" *support-set*)
  (format t "~% *last-id*: ~d" *last-id*)
  (format t "~% *depth*: ~d" *depth*)
  (format t "~% *max-db-length*: ~d" *max-db-length*)
  (format t "~% *empty-cls-ids*: ~d" *empty-cls-ids*)
  (format t "~% *answer-cls-ids*: ~d" *answer-cls-ids*)
  (values)
  )

;; flag to tell demo-loading procedures which demos
;; to load. Non-nil for hooked-on-FRAPPS:

(defvar *hooked-version* nil)

