;; Trick that apparently gets Allegro Common lisp to do automatic garbage
;; collection:

(setf *gc-tenure-total* 0)

(setf *old-gc-after-hook* *gc-after-hook*)

(defun gc-hook-fixer (&rest args)
  (apply *old-gc-after-hook* args)
  (if (car args) (setf *gc-tenure-total* 0))
  (incf *gc-tenure-total* (third args))
  (if (> *gc-tenure-total* 5100000) (gc t)))

(setf *gc-after-hook* #'gc-hook-fixer)

