;; extras.lsp
;; extra functions that might or might not be useful...


 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



(defun get-empty-clauses (idlist)
  (mapcan #'(lambda (x) (if (null (get-clause x)) (list (get-node-info x))
                            nil))
          idlist))

(defun get-answer-clauses (idlist)
  (mapcan #'(lambda (x) (let ((c (get-clause x)))
                             (if (answer-clause-p c)
                                 (list x)
                                 )))
          idlist))

(defun tautology (c) ;; Determines whether a set of clauses c is a tautology
                        in the PROPOSITONAL case.
  (cond ((null c) nil)
        ((find-car-opp c) 'T)
        ('T (tautology (cdr c)))
        ))

(defun select-and-integrate (node-list)
  (dolist (n node-list)
          (let ((x (resolvent-info-clause n)))
               (if (good x)
                   (format t " ~D" (integrate-clause n)))
               (cond ((null x)
                      (format t " Found {}! ") (setq *searching* nil))
                     (answer-clause-p x) (prin1 x))
                     ))
          ))

(defun good (x)
  (if (< (depth x) 9)
      (not (tautology x))
      ))

(defun find-car-opp (l) ; Looks for the negation of (car l) in (cdr l).
  (let ((x (car l)))
       (if (equal (car x) 'not) (look-for (cdr x) (cdr l))
	   (look-for (cons 'not x) (cdr l))
	   )))

(defun look-for (x l) ; Looks for an x inside list l
  (cond ((null l) nil)
	((equal x (car l)) 'T)
	('T (look-for x (cdr l)))
	))

