;; official OTTER version of Schubert's Steamroller:

;; ----- OTTER to FRAPPS Translator 1.0, May 1991 -----

;; formula_list(axioms).
;; (all x (Wolf(x) -> animal(x))).
;; (all x (Fox(x) -> animal(x))).
;; (all x (Bird(x) -> animal(x))).
;; (all x (Caterpillar(x) -> animal(x))).
;; (all x (Snail(x) -> animal(x))).
;; (all x (Grain(x) -> plant(x))).
;; (all x (animal(x) -> ((all y (plant(y) -> eats(x,y))) | (all z ((animal(z) & Smaller(z,x) & (exists u (plant(u) & eats(z,u)))) -> eats(x,z)))))).
;; (all x all y ((Caterpillar(x) & Bird(y)) -> Smaller(x,y))).
;; (all x all y ((Snail(x) & Bird(y)) -> Smaller(x,y))).
;; (all x all y ((Bird(x) & Fox(y)) -> Smaller(x,y))).
;; (all x all y ((Fox(x) & Wolf(y)) -> Smaller(x,y))).
;; (all x all y ((Bird(x) & Caterpillar(y)) -> eats(x,y))).
;; (all x (Caterpillar(x) -> (exists y (plant(y) & eats(x,y))))).
;; (all x (Snail(x) -> (exists y (plant(y) & eats(x,y))))).
;; (all x all y ((Wolf(x) & Fox(y)) -> -eats(x,y))).
;; (all x all y ((Wolf(x) & Grain(y)) -> -eats(x,y))).
;; (all x all y ((Bird(x) & Snail(y)) -> -eats(x,y))).
;; -(exists x exists y (-$answer(eats(x,y)) & animal(x) & animal(y) & eats(x,y) & (all z (Grain(z) -> eats(y,z))))).
;; end_of_list.

;; formula_list(sos).
;; (exists x Wolf(x)).
;; (exists x Fox(x)).
;; (exists x Bird(x)).
;; (exists x Caterpillar(x)).
;; (exists x Snail(x)).
;; (exists x Grain(x)).
;; end_of_list.

(reset-frapps)

;; Axioms in clausal form: 
(def-clause '((not Wolf ?x) (animal ?x)) )
(def-clause '((not Fox ?x) (animal ?x)) )
(def-clause '((not Bird ?x) (animal ?x)) )
(def-clause '((not Caterpillar ?x) (animal ?x)) )
(def-clause '((not Snail ?x) (animal ?x)) )
(def-clause '((not Grain ?x) (plant ?x)) )
(def-clause '((not animal ?x) (not plant ?y) (eats ?x ?y) (not animal ?z) (not Smaller ?z ?x) (not plant ?u) (not eats ?z ?u) (eats ?x ?z)) )
(def-clause '((not Caterpillar ?x) (not Bird ?y) (Smaller ?x ?y)) )
(def-clause '((not Snail ?x) (not Bird ?y) (Smaller ?x ?y)) )
(def-clause '((not Bird ?x) (not Fox ?y) (Smaller ?x ?y)) )
(def-clause '((not Fox ?x) (not Wolf ?y) (Smaller ?x ?y)) )
(def-clause '((not Bird ?x) (not Caterpillar ?y) (eats ?x ?y)) )
(def-clause '((not Caterpillar ?x) (plant (f1 ?x))) )
(def-clause '((not Caterpillar ?x) (eats ?x (f1 ?x))) )
(def-clause '((not Snail ?x) (plant (f2 ?x))) )
(def-clause '((not Snail ?x) (eats ?x (f2 ?x))) )
(def-clause '((not Wolf ?x) (not Fox ?y) (not eats ?x ?y)) )
(def-clause '((not Wolf ?x) (not Grain ?y) (not eats ?x ?y)) )
(def-clause '((not Bird ?x) (not Snail ?y) (not eats ?x ?y)) )
(def-clause '((answer (eats ?x ?y)) (not animal ?x) (not animal ?y) (not eats ?x ?y) (Grain (f3 ?x ?y))) )
(def-clause '((answer (eats ?x ?y)) (not animal ?x) (not animal ?y) (not eats ?x ?y) (not eats ?y (f3 ?x ?y))) )
;; end_of_list.

;; Set of Support in clausal form: 
(def-clause '((Wolf c1))  :support-set 't)
(def-clause '((Fox c2))  :support-set 't)
(def-clause '((Bird c3))  :support-set 't)
(def-clause '((Caterpillar c4))  :support-set 't)
(def-clause '((Snail c5))  :support-set 't)
(def-clause '((Grain c6))  :support-set 't)
;; end_of_list.

