;; FRAPPS Demo 
;; To prove: The square root of 2 is irrational. Without cheating!

(reset-frapps)

;; 1] (even (sqr ?x)) ==> (even ?x):
(def-clause '((even ?x) (not even (sqr ?x))) )

;; 2] (even ?x) ==> (even (div (sqr ?x) two)):
(def-clause '((even (div (sqr ?x) two)) (not even ?x)) )

;; 3] For all ?x, (even (mult two ?x)):
(def-clause '((even (mult two ?x))) )

;; 4] (eq ?x ?y) and (even ?x) ==> (even ?y):
(def-clause '((even ?y) (not eq ?x ?y) (not even ?x)) )

;; 5] (eq ?x (div ?y ?z)) ==> (eq (mult ?x ?z) ?y):
(def-clause '((eq (mult ?x ?z) ?y) (not eq ?x (div ?y ?z))) )

;; 6] (eq ?x (div ?y ?z)) ==> (eq (div ?y ?x) ?z):
(def-clause '((eq (div ?y ?x) ?z) (not eq ?x (div ?y ?z))) )

;; Negation of the theorem to be proved:

;; 7] two = (sqr a) / (sqr b) :
(def-clause '((eq two (div (sqr a) (sqr b)))) :support-set T)

;; 8] Where a and b cannot be both even (weaker requirement than
;;    "a and b have no divisors in common"):
(def-clause '((not even a) (not even b)) :support-set T)

;; Extra commutativity axiom for equality, not really needed:

(def-clause '((not eq ?x ?y) (eq ?x ?y)))

;; plus associativity, to make things even worse:

(def-clause '((not eq ?x ?y) (not eq ?y ?z) (eq ?x ?z)) )

