;; The search procedures here do not use the priority queue,
;; and thus can be quite inefficient for complex searches.

;; In a case like H(n), where almost everything resolves with everything
;; else, they can be MORE efficient.

(setq *priority-queue-on* nil)	;; These search procedures do not use the
				;; priority queue.

(setq *searching* T)	;; variable local to these procedures

(defvar generated 0)
(defvar *max-level* 3)

(defun user-delete (l) l)

(defun expand-list-pair (l1 l2)
  (dolist (x l1) (integrate-resolvents x l2))
  )

(defun expand-SLD (l1 l2)	;; Used for SLD search.
  (dolist (x l1) (integrate-SLD-resolvents x l2))
  )

(defun expand-unit (l1 l2)
  (dolist (x l1)
	  (if (= (clause-length (get-node-clause x)) 1)
	      (integrate-resolvents x l2)
	      (integrate-unit x l2))
	  ))

(defun expand-list (l)
  (cond ((null l) nil)
	(T (integrate-resolvents (car l) l)
	   (expand-list (cdr l))
	   )))

(defun expand-SLD-list (l)
  (cond ((null l) nil)
	(T (integrate-SLD-resolvents (car l) l)
	   (expand-SLD-list (cdr l))
	   )))

(defun expand-unit-list (l)
  (cond ((null l) nil)
	(T  (if (= (clause-length (get-node-clause (car l))) 1)
		(integrate-resolvents (car l) l)
		(integrate-unit (car l) l))
	    (expand-unit-list (cdr l))
	    )))

;; (defun integrate-SLD-resolvents (y l)
  ;; (if (equal (caar (get-node-clause y)) 'answer)
      ;; (dolist (x l) (select-and-integrate (resolve y x :c1-lit 2)))
      ;; (dolist (x l) (select-and-integrate (resolve y x :c1-lit 1)))
      ;; ))

(defun integrate-SLD-resolvents (y l)
  (dolist (x l)
	  (if *searching* (sld-resolve y x)
	      (return))
	  ))

(defun integrate-unit (x l)
  (dolist (y (intersection l (get-ids-of-length 1)))
	      (if *searching* (select-and-integrate (resolve x y))
		  (return)
	      )))

;; (defun old-integrate-unit (x l)
  ;; (dolist (y l)
	  ;; (if (= (clause-length (get-node-clause y)) 1)
	      ;; (select-and-integrate (resolve x y))
	      ;; )))


(defun integrate-resolvents (x l)
  (dolist (y l)
	  (if *searching*
	      ;;(if (<= x y)
		  (select-and-integrate (resolve x y))
	      ;; )
	      (return))
	  ))

(defun select-and-integrate (node-list)
  (setq generated (+ generated (length node-list)))
  (dolist (n node-list)
	  (cond
	   ((user-delete (list n))
	    (let ((cls (resolvent-info-clause n)))
		 (format t " ~D" (integrate-clause n))
		 (cond ((null cls)
			(format t " Found {}!~%")
			(format t " Search for more proofs?")
			(cond ((not (user-choice))
			       (setq *searching* nil)
			       (return))
			      (T (format t "~%")))
			)
		       ((answer-clause-p cls)
			(format t " Found answer: ~d~%" cls)
			(format t "~% Search for more answers?")
			(cond ((not (user-choice))
			       (setq *searching* nil)
			       (return))
			      (T (format t "~%")))
			)
		       )))
	   (T (format t "."))
	   )))

(defun SLD (start-set)
  (if (null start-set) 'end
      (let ((n (get-node-level (car start-set)) ))
	   (format t "~%Level ~D:" (+ 1 n))
	   (if (= n 0) (expand-SLD-list *base-set*)
	       (expand-SLD start-set *base-set*))
	   (if *searching*
	       (SLD (gial (+ 1 n)) ))
	   )))

(defun unit-input (start-set)
  (if (null start-set) 'end
      (let ((n (get-node-level (car start-set)) ))
	   (format t "~%Level ~D:" (+ 1 n))
	   (if (= n 0) (expand-unit-list *base-set*)
	       (expand-unit start-set *base-set*))
	   (if *searching*
	       (unit-input (gial (+ 1 n)) ))
	   )))

(defun unit (start-set)
  (if (null start-set) 'end
      (let ((n (get-node-level (car start-set)) ))
	   (format t "~%Level ~D:" (+ 1 n))
	   (if (= n 0) (expand-unit-list *base-set*)
	       (expand-unit start-set (gidl n)))
	   (if *searching*
	       (unit (gial (+ 1 n)) ))
	   )))

(defun input (start-set)
  (if (null start-set) 'end
      (let ((n (get-node-level (car start-set)) ))
	   (format t "~%Level ~D:" (+ 1 n))
	   (if (= n 0) (expand-list *base-set*)
	       (expand-list-pair start-set (gidl n)))
	   (if *searching*
	       (input (gial (+ 1 n)) ))
	   )))

(defun breadth (n)	;; Generates level n+1, recurses.
  ;; quite inefficient in general!!!
  (if (or (null (gial n)) (>= n *max-level*)) 'end
      (let ((ids (get-ids-at-level n)))
	   (format t "~%Level ~D:" (+ 1 n))
	   (if (= n 0) (expand-list ids) ;; same as base-set
	       (progn
		(expand-list-pair ids (gidl (- n 1)))
		(expand-list ids)
		))
	   (if *searching* 
	       (breadth (+ 1 n) ))
	   )))


(defun search-general ()
  (setq *searching* T)
  (setq generated 0)
  (if *kcl-bug* (read-line))
  (breadth 0))

(defun search-unit ()
  (setq *searching* T)
  (setq generated 0)
  (if *kcl-bug* (read-line))
  (unit *base-set*))

(defun search-unit-input ()
  (setq *searching* T)
  (setq generated 0)
  (if *kcl-bug* (read-line))
  (unit-input *base-set*))

(defun search-sld ()
  (setq *searching* T)
  (setq generated 0)
  (if *kcl-bug* (read-line))
  (sld *base-set*))

(defun search-input ()
  (setq generated 0)
  (setq *searching* T)
  (if *kcl-bug* (read-line))
  (input *base-set*))

(defun search-sos ()
  (setq generated 0)
  (setq *searching* T)
  (if *kcl-bug* (read-line))
  (expand-list-pair *support-set* *base-set*)
  (breadth 1)
  )

