;; FRAPPS 91

;; Simple priority-queue search, stops at first answer or proof:

(defun user-search ()
  (let ((clause-pair 'not-empty)
	(resolvent-list nil)
	(current-level 0))
       (setq clause-pair (pop-priority-queue))
       (do () ((or (not clause-pair) *empty-cls-ids* *answer-cls-ids*))
	   (setq resolvent-list 
		 (user-delete (user-resolve (car clause-pair) (cadr clause-pair))))

	   ;; The following carries out backwards subsumption.
	   ;; Note that it has to go BEFORE the resolvents are integrated
	   ;; (otherwise they will all subsume themselves).
	   ;; also, subsumption between the resolvents themselves is not
	   ;; checked for.
	   ;; >>>> (deactivate-back-subsumed-nodes resolvent-list)
	   
	   (integrate-clause-list resolvent-list)
	   (cond (resolvent-list
		  (if (< current-level *depth*)
		      (format t "~2% Reached level ~d: " 
			      (setq current-level *depth*)))
		  (format t "~d " *last-id*))
		 (T (format t "."))
		 (force-output)
		 )
	   (setq clause-pair (pop-priority-queue)))
       (if *empty-cls-ids*
	   (format t "~% Found empty clause(s), node(s): ~d" *empty-cls-ids*))
       (if *answer-cls-ids*
	   (format t "~% Found answer clause(s), node(s): ~d" *answer-cls-ids*))
       )
  (values))
 
(defun user-delete (list)
  (delete-taut-resolvents list))

(defun user-resolve (id1 id2)
  (resolve id1 id2))  ;; General resolution

;; (setq *max-literals* 5) ;; Specify maximum number of literals allowed
;; (setq *max-complexity* 5) 

