;; FRAPPS demo:

;; This is a simple breadth-first search that does NOT use the
;; priority queue, and depends on the definitions of
;; "user-resolve" and "user-delete".
;; The search is stopped when the number of levels indicated
;; by "max-level" has been expanded.

;; This is OLD and INEFFICIENT!!!

(defun print-proof (id) (print-derivation id))

(defun manual (x y) (integrate-clause-list (resolve x y)))

(setq *queue-on* nil)
(format t "~% NOTICE: The priority queue is now turned OFF.~%")

(defun my-search ()
  (setq *searching* 't)
  (breadth-first *base-set*)
  (format t "~%")
  (if *answer-cls-ids*
      (progn
       (format t "~%Answers found at: ~d" *answer-cls-ids*)
       (format t "~%~d~%"
	       (remove-duplicates
		(mapcar #'get-clause *answer-cls-ids*) :test #'set-equalp))
       ))
  (if *empty-cls-ids*
      (format t "~%Empty clauses (proofs) found at: ~d" *empty-cls-ids*))
  (if (not (or *answer-cls-ids* *empty-cls-ids*))
      (format t "~%No proofs or answers found."))
  (format t "~%")
  )

(setq max-level 4)

(defun reset-general ()
  (reset-frapps)
  (defun user-resolve (x y) (resolve x y))
  )

(defun reset-sld ()
  (reset-frapps)
  (defun user-resolve (x y) (sld-resolve x y))
  )

(defun reset-unit ()
  (reset-frapps)
  (defun user-resolve (x y) (unit-resolve x y))
  )

;; Resolves each clause in list l1 against all clauses in list l2
;; l1 and l2 are lists of id's.

(defun expand-list-pair (l1 l2)
  (dolist (x l1) (integrate-resolvents x l2))
  )

;; Resolves all elements in list l against each other.
(defun expand-list (l)
  (cond ((null l) nil)
	( 'T (integrate-resolvents (car l) l)
	     (expand-list (cdr l))
	     )))

;; Depends on "user-delete" and "user-resolve."
;; Resolve clause x against all clauses in list l
;; (clauses denoted by their ids)
(defun integrate-resolvents (x l)
  (dolist (y l)
	  (if *searching*
	      (let ((res-list (user-resolve x y)))
		   (select-and-integrate
		    (user-delete res-list))
		   ))))

;; Can implement termination condition here.
;; Integrates all resolvent-info-structures in resolvent-list.
(defun select-and-integrate (resolvent-list)
  (dolist (n resolvent-list)
	  (format t " ~D" (integrate-clause n))
	  (cond ((equal nil (get-clause *last-id*)) (format t ":{}"))
		((answer-clause-p (get-clause *last-id*))
		 (if (= 1 (length (get-clause *last-id*)))
		     (format t ":ANSWER")
		     (format t ":indefinite answer")
		 ))
		((> (get-level *last-id*) max-level)
		 (setq *searching* nil))
		)))

(defun user-delete (l) (delete-taut-resolvents l))

;; To search from the base set, just do (breadth-first *base-set*)
(defun breadth-first (start-set)
  (if (or (null start-set) (not *searching*)) 'end
      (let ((n (get-level (car start-set)) ))
	   (if (< n max-level)
	       (progn
		(format t "~%Level ~D:" (+ 1 n))
		(expand-list start-set)
		(if (not (= n 0))
		    (expand-list-pair start-set (get-ids-downto-level (- n 1)))
		    )
		(breadth-first (get-ids-at-level (+ 1 n)) ))
	       ))
      ))

(defun user-resolve (x y) (resolve x y)) ;; Set general resolution

(setq *searching* 't)

(defun load-blocks ()
  (reset-frapps)
  (defun user-resolve (x y) (unit-resolve x y))
  (defun user-delete (l) (delete-taut-resolvents l))
  (setq *searching* 't)
  (setq max-level 4)
  (load-demo "blocks"))

(defun load-alpine ()
  (reset-frapps)
  (defun user-resolve (x y) (unit-resolve x y))
  (defun user-delete (l) (delete-taut-resolvents l))
  (setq *searching* 't)
  (setq max-level 3)
  (load-demo "alpine1"))

(defun load-mystery ()
  (reset-frapps)
  (defun user-resolve (x y) (unit-resolve x y))
  (defun user-delete (l) (delete-taut-resolvents l))
  (setq *searching* 't)
  (setq max-level 5)
  (load-demo "mystery"))

(defun load-square ()
  (reset-frapps)
  (defun user-resolve (x y) (unit-resolve x y))
  (defun user-delete (l) (delete-taut-resolvents l))
  (setq *searching* 't)
  (setq max-level 6)
  (load-demo "square"))

