;; FRAPPS 91

;; Simple breadth-first search to expand to level n.
;; (expand-level x) expands the tree down to level x.

(set-breadth-costfn)	;; For more efficient breadth-first search.

(defun expand-level (max-level)
  (let ((clause-pair 'not-empty)
	(resolvent-list nil)
	(current-level 0)
	(generated 0))
       (setq clause-pair (pop-priority-queue))
       (do () ((or (not clause-pair)
		   (eq (max (get-node-level (first clause-pair))
			    (get-node-level (second clause-pair)))
		       max-level)))
	   (setq resolvent-list 
		 (resolve (car clause-pair) (cadr clause-pair)))

	   ;; count generated clauses:
	   (setq generated (+ generated (length resolvent-list)))

	   ;; NOW delete clauses:
	   ;; (setq resolvent-list (user-delete resolvent-list))
	   ;; Does not quite work for duplicate deletion!!!

	   (dolist (resolvent resolvent-list)
		   ;; Integrated clauses are implicitly counted through node-ids.
		   
		   (cond 
		    ((integrate-clause-list (user-delete (list resolvent)))
		     (if (< current-level *depth*)
			(format t "~2% Reached level ~d: " 
			      (setq current-level *depth*)))
		     (format t "~d " *last-id*))
		    (T (format t ".")) ;; prints dot for each deleted clause
		    ))
	   (force-output)
	   (setq clause-pair (pop-priority-queue)))
       (if *empty-cls-ids*
	   (format t "~% Found empty clause(s), node(s): ~d" *empty-cls-ids*))

       (format t "~2% Clauses generated: ~d" generated)
       (format t "~% Clauses integrated: ~d" (- *last-id* (length *base-set*)))
       (dotimes (x (1+ *depth*))
		(format t "~% Clauses at level ~d: ~d" x (length (gial x))))
       )
  (values))

(defun user-delete (list) list)

(defun set-duplicate ()
  (defun user-delete (list)
	 (delete-fwd-sub-resolvents list :degree 'variants)))

;; (defun set-duplicate () (defun user-delete (list)
	 ;; (delete-duplicate-rslvnts list)))

(defun set-tautology ()
  (defun user-delete (list)
	 (delete-taut-resolvents list)))

(defun set-both ()
  (defun user-delete (list)
	 (delete-fwd-sub-resolvents (delete-taut-resolvents list)
				    :degree 'variants)))

;; (defun set-both ()
  ;; (defun user-delete (list)
	 ;; (delete-duplicate-resolvents (delete-taut-resolvents list))))


(defun set-none () (defun user-delete (list) list))

(defun set-sos (&optional file)
  (setq *cost-function-single-components*
	'(sos-single-costfn cls-depth-single-costfn))
  (setq *cost-function-single-weights* '(1 1))
  (if file (load-demo file)
      (partial-reset))

  ;; set components back:
  (setq *cost-function-single-components* '(cls-depth-single-costfn))
  (setq *cost-function-single-weights* '(1))
  )

