;; Second Genesereth and Nilsson example, p. 81

(reset-frapps)

;; b0 and b1 correspond to bits 0 and 1;
;; "one", "two" and "three" are the names of the gates.

(def-clause-list
  '( ;; ((xorg X1))
     ;; ((xorg X2))
     ;; ((andg A1))
     ;; ((andg A2))
     ;; ((org O1))
     ;; Defines the 5 gates. Not part of this example

((conn (I one F1) (I one X1))) ; Defining connections between components.
((conn (I two F1) (I two X1)))
((conn (I one F1) (I one A1)))
((conn (I two F1) (I two A1)))	;; 9
((conn (I three F1) (I two X2)))
((conn (I three F1) (I one A2)))
((conn (O one X1) (I one X2)))
((conn (O one X1) (I two A2)))	;; 13
((conn (O one A2) (I one O1)))
((conn (O one A1) (i two O1)))
((conn (O one X2) (O one f1)))
((conn (O one O1) (O two f1)))	;; 17

;; Now describe the behaviour of each type of gate:

((not andg ?d) (not V (I one ?d) b1) (not V (I two ?d) b1) (V (O one ?d) b1))
((not andg ?d) (not V (I (?n ?d)) b0) (V (O one ?d) b0))	;; 19

((not org ?d) (not V (I (?n ?d)) b1) (V (O one ?d) b1))	;; 20
((not org ?d) (not V (I one ?d) b0) (not V (I two ?d) b0) (V (o one ?d) b0))

((not xorg ?d) (not V (I one ?d) ?y) (not V (I two ?d) ?z) (equal ?y ?z) (V (O one ?d) b1))	;; 22
((not xorg ?d) (not V (i one ?d) ?z) (not V (I two ?d) ?z) (V (o one ?d) bo))

((not conn ?x ?y) (not V ?x ?z) (V ?y ?z)) ;; 24

;; The zero bit is different from the one bit:

((not equal b1 b0))
((not equal b0 b1))

))

(def-clause '( (V(O one F1) b0) ) :support-set T) ;; B1

(def-clause '( (not xorg ?g) (answer-gate ?g) ) :support-set T)

