;; FRAPPS demo:

;; Alternative implementation of breadth-first search,
;; Does not use the priority queue.

;; Run with: (breadth-first-search)

(setq *queue-on* nil)
(format t "~% NOTICE: The priority queue is now turned OFF.~%")

(defun reset-general ()
  (setq *searching* 'T)
  (defun user-resolve (x y) (resolve x y))
  )

(setq *searching* 'T)
;; "Global" variable to determine if searching continues or not.

(setq max-level most-positive-fixnum)  ;; default

;; (setq generated 0) ;; This variable can be used to count how many
;; clauses are generated during the search - in general, not all of the
;; "generated" clauses are integrated into the derivation when a deletion
;; strategy is used.

;; Resolves each clause in list l1 against all clauses in list l2
;; l1 and l2 are lists of id's.

(defun expand-list-pair (l1 l2)
  (dolist (x l1) (integrate-resolvents x l2))
  )

;; Resolves all elements in list l against each other.
(defun expand-list (l)
  (cond ((null l) nil)
	( 'T (integrate-resolvents (car l) l)
	     (expand-list (cdr l))
	     )))

;; Depends on "user-delete" and "user-resolve."
;; Resolve clause x against all clauses in list l
;; Note that clauses are denoted by their ids:

(defun integrate-resolvents (x l)
  (dolist (y l)
	  (if *searching*
	      (let ((res-list (user-resolve x y)))
		   ;; (setq generated
			 ;; (+ generated (length res-list)))
		   (select-and-integrate
		    (user-delete res-list))
		   ))))

;; Can implement termination condition here.
;; Integrates all resolvent-info-structures in resolvent-list.

(defun select-and-integrate (resolvent-list)
  (dolist (n resolvent-list)
	  (format t " ~D" (integrate-clause n))
	  (let ((cls (get-node-clause *last-id*)))
	       (cond ((null cls)
		      (format t "~% Found {} at clause ~D" *last-id*)
		      (format t "~% Continue the search?")
		      (if (not (user-choice))
			  (setq *searching* nil))
		      )
		     ((answer-clause-p cls)
		      (format t "~% Found answer at clause ~D: ~d" *last-id* cls)
		      (format t "~% Continue the search?")
		      (if (not (user-choice))
			  (setq *searching* nil))
		      )
		     ))))

(defun user-delete (l) (delete-taut-resolvents l))

(defun breadth-first-search ()
  (if *queue-on*
      (progn
       (format t "~% NOTICE: This search procedure does not use the priority queue.")
       (format t "~%         Setting *queue-on* to nil.~%")
       (setq *queue-on* nil)
       ))
  (setq *searching* T)
  (if *kcl-bug* (read-line))
  (breadth-first *base-set*)
  )

(defun breadth-first (start-set)
  (if (or (null start-set) (not *searching*)) 'end
      (let ((n (get-level (car start-set)) ))
	   (format t "~% Level ~D:" (+ 1 n))
	   (expand-list start-set)
	   (if (not (= n 0))
	       (expand-list-pair start-set (get-ids-downto-level (- n 1)))
	       )
	   (if (> *depth*  max-level) 'end
	       (breadth-first (get-ids-at-level (+ 1 n)) ))
	   )))

(defun user-resolve (x y) (resolve x y)) ;; Set general resolution

;; Reset global variables and set level to be expanded:

(defun reset-sld ()
  (setq *searching* T)
  (defun user-resolve (x y) (sld-resolve x y))
  )

(defun reset-unit ()
  (setq *searching* T)
  (defun user-resolve (x y) (unit-resolve x y))
  )

