;; FRAPPS - debug.lsp

 ;;
 ;; The Framework for Resolution-Based Automated Proof Procedure Systems
 ;;                         FRAPPS Version 2.0
 ;;    Authors: Alan M. Frisch, Michael K. Mitchell and Tomas E. Uribe
 ;;               (C) 1992 The Board of Trustees of the
 ;;                       University of Illinois
 ;;                        All Rights Reserved
 ;;
 ;;                              NOTICE
 ;;
 ;;   Permission to   use,  copy,  modify,  and   distribute  this
 ;;   software  and  its  documentation for educational, research,
 ;;   and non-profit purposes  is  hereby  granted  provided  that
 ;;   the   above  copyright  notice, the original authors  names,
 ;;   and this permission notice appear in all  such  copies   and
 ;;   supporting   documentation; that no charge be  made for such
 ;;   copies; and that  the name of  the University of Illinois or
 ;;   that  of  any  of the Authors not be used for advertising or
 ;;   publicity  pertaining  to   distribution   of  the  software
 ;;   without   specific  prior  written   permission. Any  entity 
 ;;   desiring  permission to incorporate   this   software   into
 ;;   commercial  products  should  contact   Prof.  A. M. Frisch,
 ;;   Department  of Computer  Science,  University  of  Illinois,
 ;;   1304  W.  Springfield Avenue, Urbana, IL 61801. The  Univer-
 ;;   sity of  Illinois and the Authors  make  no  representations
 ;;   about   the suitability  of this  software  for any purpose.
 ;;   It is provided "as is" without  express or implied warranty.
 ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; NOTE: Some of these may now be obsolete;
;;	 they have NOT been used or maintained for a long time.

;; displays the current "state" of the FRAPPS system

(defun display-state ()
  (print-database-globals)
  (print-flags)
  (read)
  (format t "~2% ::: *level-db* ::: ~%")
  (print-hash-table-contents *level-db*)
  (read)
  (format t "~2% ::: *cls-length-db* ::: ~%")
  (print-hash-table-contents *cls-length-db*)
  (read)
  (format t "~3% ::: *node-db* ::: ~%")
  (print-hash-table-contents *node-db*)
  (read)
  (show-lit-db)
  (read)
  (show-priority-queue))

(defun show-lit-db ()
  (format t "~% -----> *LIT-DB* contains ~d entries, they are..."
          (hash-table-count *lit-db*))
  (maphash #'(lambda (key val)
               (format t "~2% ==> *lit-db* key: ~d " key)
               (format t "~%     *lit-db* val: ***** lit-args-ht *****")
               (maphash #'(lambda (key val)
                            (format t "~%                   >> key: ~d === val: ~d"
                                    key val))
                val))
           *lit-db*)
  (format t "~3% ------> *ARG-RETRV-DB* contains ~d entries, they are..."
          (hash-table-count *arg-retrv-db*))
  (maphash #'(lambda (key val)
               (format t "~2% ==> *arg-retrv-db* key: ~d === val: ~d " key val))
           *arg-retrv-db*)
  (format t "~3% -----> *ARG-DTCT-DB* contains ~d entries, they are..."
          (hash-table-count *arg-dtct-db*))
  (maphash #'(lambda (key val)
               (format t "~2% ==> *arg-dtct-db* key: ~d === val: ~d " key val))
           *arg-dtct-db*))



(defun ppq () (pop-priority-queue))

(defun r (x y) (integrate-clause-list (resolve x y)))

(defun bk1 (lit)
  (bld-lit-db-key lit))

(defun bk2 (lit)
  (bld-lit-args-ht-key lit))

(defun strip (exp)
  (strip-var-names-and-subscrs exp))


(defun al (lit cls-id)
  (update-lit-db-add lit cls-id))


(defun gccl (lit)
  (get-clauses-cont-lit lit))


(defun gla (lit)
  (get-lit-args lit))


(defun bl (lit-db-key arg-id-list)
  (bld-lit lit-db-key arg-id-list))


(defun reql (lit)
  (ret-clauses-cont-equal-lits lit))


(defun runif (lit)
  (ret-clauses-cont-unifiable-lits lit))


(defun rinst (lit)
  (ret-clauses-cont-instance-lits lit))


(defun rmgen (lit)
  (ret-clauses-cont-more-general-lits lit))

(defun sub-p (cl1 cl2)
  (subsumes-p cl1 cl2))

(defun ncp (pr-vect id-pair)
  (construct-new-clause-pair pr-vect id-pair))

(defun cpv (id1 id2)
  (compute-pr-vector id1 id2))

(defun anb (id-pair pr-vect nbp)
  (let* ((pr-vct (cpv (first id-pair) (second id-pair)))
	 (cls-pair-struct (ncp pr-vect id-pair)))
    ;;;;(format t "~2% CLS-PAIR-STRUCT: ~d" cls-pair-struct)
    ;;;;(read)
    (add-new-bkt-to-queue cls-pair-struct nbp)))


(defun acpb (id-pair pr-vect bindx)
  (let* ((cls-pair-struct (ncp pr-vect id-pair)))
    (add-cls-pair-to-bkt cls-pair-struct bindx)))


(defun add-elt (id-pair pr-vect)
  (add-elt-to-priority-queue (ncp pr-vect id-pair)))


(defun anc (id-list)
  (add-new-clauses-to-priority-queue id-list))


(defun doit1 ()
  (reset-frapps)
  (def-clause '((P) (not Q) (R)))
  (def-clause '((not P) (Q)))
  (def-clause '((not R)))
  (grs 1 2)
  (show-priority-queue))


(defun doit2 ()
  (reset-frapps)
  (def-clause '((not P ?x)))
  (def-clause '((P ?x)))
  (def-clause '((P ?x a) (Q ?x ?y)))
  (def-clause '((P a b) (not Q b ?z)))
  (def-clause '((P d) (R ?x ?y ?z) (Q ?x ?y)))
  (def-clause '((not P ?x ?z) (R a ?y c) (Q a b)))
  (show-priority-queue))
  
(defun df (rslvnts)
  (delete-fwd-sub-resolvents rslvnts))  

(defun db (rslvnts)
  (delete-back-sub-resolvents rslvnts))

(defun rnl (node-id-list)
  (dolist (id node-id-list)
	  (reactivate-node id)))

(defun dtauts (rslvnt-list)
  (delete-taut-resolvents rslvnt-list))


(defun dcomp (rslvnt-list)
  (delete-complex-resolvents rslvnt-list))


(defun dlong (rslvnt-list)
  (delete-long-resolvents rslvnt-list))


(defun br (cls)
  (construct-resolvent-info cls nil 'ud))


(defun bn (cls)
  (def-clause cls))

;; now part of prover:

;; (defun emp (cls-lst)
  ;; (empty-clause-gen-p cls-lst))

(defun uc-p (id-list)
  (unit-conflict-p id-list))


(defun inr (id-pair)
  (infer-new-resolvents id-pair))


(defun doit ()
  (search-for-refutation))

(defun start ()
  (load "init.lsp")
  (start-frapps)
  (load-prover)
  (load "ids/examples.lsp"))

;; (defun redo ()
  ;; (reset-frapps)
  ;; (reset-prover))

 
;;;;  ====> DEBUG & SCAFFOLDING FUNCTIONS (Originally in tpmisc.lsp)


;;(defun pdb ()
  ;;(print-hash-table-contents *lit-pred-db*))

;;(defun factor-db ()
  ;;(print-hash-table-contents *j-list-next-factor-node*))

;; (defun ds ()
  ;; (display-state))

;;(defun upin (res-info)
  ;;(unit-pref-integrate-node res-info))


;;(defun upinl (res-info-list)
  ;;(unit-pref-integrate-node-list res-info-list))

;;(defun get-njf (j)
  ;;(get-next-j-list-factor j))


;;(defun get-fdb-j (j)
  ;;(gethash j *j-list-next-factor-node*))


;;(defun put-fdb-j (j val)
  ;;(setf (gethash j *j-list-next-factor-node*) val))

(defun clr-clsh-db ()
  (clrhash *rslvnds-clash-lits-db*))

(defun gcal (id level)
  (let ((result nil))
       (dolist (x (get-children id))
	       (if (= (get-node-level x) level)
		   (setq result (cons x result))))
       result))
