/*
 *         Copyright (C) Argonne National Laboratory
 *
 *   Argonne does not guarantee this software in any manner and is
 *   not responsible for any damages that may result from its use.
 *   Furthermore, Argonne does not provide any formal support for this
 *   software.  This is an experimental program.  This software
 *   or any part of it may be freely copied and redistributed,
 *   provided that this paragraph is included in each source file.
 *
 */

#ifndef NULL
#define NULL		((void*) 0L)	/* Null pointer value		     */
#endif

#define COMPLEX 0
#define ATOM 1
#define VARIABLE 2
#define NAME 3

struct term {
   struct rel *farg;		/* subterm list. */
   unsigned char type;		/* COMPLEX, ATOM or VARIABLE */
   union {
	struct rel *rel;	/* superterm list */
	struct literal *lit;	/* containing literal; used for all except atoms */
	} occ;
   int fpa_id;
   short sym_num;		/* Identifier for symbol number. */
   VAR_TYPE varnum;
   unsigned char scratch;
   unsigned char scratch2;
   };

struct literal {
	struct clause *container;
	struct literal *next_lit;
	struct term *atom;
	char sign;
	};

struct clause {
	struct int_ptr *parents;
	struct list *container;
	struct clause *prev_cl, *next_cl;
	struct literal *first_lit;
	int id;
	int type;
	};

typedef struct rel {			/* relations between terms. From OTTER */
   struct term *argval;		/* first subterm */
   struct term *argof;		/* superterm */
   struct rel *narg;		/* rest of subterm list */
   struct rel *nocc;		/* rest of superterm list */
   };

struct sym_ent {		 /* symbol table entry */
    struct sym_ent *next;
    int sym_num;		/* unique identifier */
    int arity;			/* 0 for constants and variables */
    char name[MAX_NAME];
    };

struct term_ptr {
    struct term *term;
    struct term_ptr *next;
    };

struct list {
	struct clause *first_cl, *last_cl;
	};

struct int_ptr { /* for building a list of integers */
	struct int_ptr *next;
	int i;
	};

struct clause_ptr {
	struct clause *c;
	struct clause_ptr *next;
	};

