#include "header.h"

/*
 *         Copyright (C) Argonne National Laboratory
 *
 *   Argonne does not guarantee this software in any manner and is
 *   not responsible for any damages that may result from its use.
 *   Furthermore, Argonne does not provide any formal support for this
 *   software.  This is an experimental program.  This software
 *   or any part of it may be freely copied and redistributed,
 *   provided that this paragraph is included in each source file.
 *
 */

/*************
 *
 *    init() -- initialize global variables
 *
 *************/

void init()
{
    /*B
    Eq_sym_num = str_to_sn("$eq_infix", 2);
    Cons_sym_num = str_to_sn("$cons", 2);
    Nil_sym_num = str_to_sn("$nil", 0);

    Chr_sym_num = str_to_sn("$CHR", 1);

    init_options();
    clock_init();
    E*/

    /* Ignore_sym_num = str_to_sn("$IGNORE", 1); */

}  /* init */

/*************
 *
 *    read_all_input()
 *
 *************/

void read_all_input()
{
    struct list *l;
    struct term *t, *t1;
    struct clause *c;
    int rc, error, list_errors;
    struct term_ptr *tp;

    Axioms = get_list();   /* This should return a fresh list of clauses. */
    Sos = get_list();
    Passive = get_list();

    t = read_term(stdin, &rc);
    while (t != NULL || rc == 0) {
	error = 0;
	if (t == NULL)
	    error = 1;
	else if (t->type != COMPLEX)
	    error = 1;
	else if (str_ident("set", sn_to_str(t->sym_num))) {
	    /* if (change_flag(t, 1)) {
		print_term(stdout, t); printf(".\n");
		} */
	    }
	else if (str_ident("clear", sn_to_str(t->sym_num))) {
	    /* if (change_flag(t, 0)) {
		print_term(stdout, t); printf(".\n");
		} */
	    }
	else if (str_ident("assign", sn_to_str(t->sym_num))) {
	    /* if (change_parm(t)) { 
		print_term(stdout, t); printf(".\n");
		} */
	    }
	else if (str_ident("list", sn_to_str(t->sym_num))) {
	    t1 = t->farg->argval;
	    if (t1->type == COMPLEX || t->farg->narg != NULL) {
		printf("ERROR, bad argument to list: ");
		print_term(stdout, t); printf(".\n");
		Stats[INPUT_ERRORS]++;
		}
	    else if (str_ident("axioms", sn_to_str(t1->sym_num)) ||
		     str_ident("usable", sn_to_str(t1->sym_num))) {
		printf("\n;;"); print_term(stdout, t);
		printf(".\n");
		l = read_cl_list(stdin, &list_errors);
		if (list_errors != 0)
		    Stats[INPUT_ERRORS] += list_errors;
		else if (Flags[PROCESS_INPUT].val == 0) {
		    c = l->first_cl;
		    while (c != NULL) {
			cl_integrate(c);
			c = c->next_cl;
			}
		    }
		/* print_cl_list(stdout, l); */
		append_lists(Axioms,l);
		}
	    else if (str_ident("sos", sn_to_str(t1->sym_num))) {
		printf("\n;;"); print_term(stdout, t);
		printf(".\n");
		l = read_cl_list(stdin, &list_errors);
		if (list_errors != 0)
		    Stats[INPUT_ERRORS] += list_errors;
		else if (Flags[PROCESS_INPUT].val == 0) {
		    c = l->first_cl;
		    while (c != NULL) {
			cl_integrate(c);
			c = c->next_cl;
			}
		    }
		/* print_cl_list(stdout, l); */
		append_lists(Sos,l);
		}
	else if (str_ident("passive", sn_to_str(t1->sym_num))) {
                printf("\n;;");
                print_term(stdout, t);
                printf(".\n");
                l = read_cl_list(stdin, &list_errors);
                if (list_errors != 0)
                    Stats[INPUT_ERRORS] += list_errors;
                c = l->first_cl;
		while (c != NULL) {
		    cl_integrate(c);
		    c = c->next_cl;
		    }

                /* print_cl_list(stdout, l); */
                append_lists(Passive,l);
                }
	    else {
		printf("ERROR, unknown list: ");
		print_term(stdout, t); printf(".\n");
		/* Demodulators = read_cl_list(stdin, &list_errors);
		print_cl_list(stdout, Demodulators); */
		Stats[INPUT_ERRORS]++;
		}
	    }
	else if (str_ident("formula_list", sn_to_str(t->sym_num))) {
	    t1 = t->farg->argval;
	    if (t1->type == COMPLEX || t->farg->narg != NULL) {
		printf("ERROR, bad argument to list: ");
		print_term(stdout, t); printf(".\n");
		Stats[INPUT_ERRORS]++;
		}
	    else if (str_ident("axioms", sn_to_str(t1->sym_num)) ||
		     str_ident("usable", sn_to_str(t1->sym_num))) {
		printf("\n;; ");
		print_term(stdout, t);
		printf(".\n");
		tp = read_formula_list(stdin, &list_errors);
		print_formula_list(stdout,tp);
		if (list_errors != 0)
		    Stats[INPUT_ERRORS] += list_errors;
		else {
		    l = clausify_formula_list(tp);
		    if (Flags[PROCESS_INPUT].val == 0) {
			c = l->first_cl;
			while (c != NULL) {
			    cl_integrate(c);
			    c = c->next_cl;
			    }
			}
		    /* printf("\n-------> axioms clausifies to:\n\nlist(axioms).\n");
		    print_cl_list(stdout, l); */
		    append_lists(Axioms,l);
		    }
		}
	    else if (str_ident("sos", sn_to_str(t1->sym_num))) {
		printf("\n;; ");
		print_term(stdout, t);
		printf(".\n");
		tp = read_formula_list(stdin, &list_errors);
		print_formula_list(stdout,tp);

		if (list_errors != 0)
		    Stats[INPUT_ERRORS] += list_errors;
		else {
		    l = clausify_formula_list(tp); 
		    if (Flags[PROCESS_INPUT].val == 0) {
			c = l->first_cl;
			while (c != NULL) {
			    cl_integrate(c); /* Integrate clauses. */
			    c = c->next_cl;
			    }
			}
		    /* printf("\n-------> sos clausifies to:\n\nlist(sos).\n");
		    print_cl_list(stdout, l); */
		    append_lists(Sos,l);
		    }
		}
	   else if (str_ident("passive", sn_to_str(t1->sym_num))) {
                printf("\n;;");
                print_term(stdout, t);
                printf(".\n");
                tp = read_formula_list(stdin, &list_errors);
                print_formula_list(stdout,tp);
                if (list_errors != 0)
                    Stats[INPUT_ERRORS] += list_errors;
                else {
                    l = clausify_formula_list(tp);
                    /* printf("\n-------> passive clausifies to:\n\nlist(passive).\
n");
                    print_cl_list(stdout, l); */
                    append_lists(Passive,l);
                    }
                }
	    else {
		printf("ERROR, unknown formula_list: ");
		print_term(stdout, t); printf(".\n");
		/* Demodulators = read_cl_list(stdin, &list_errors);
		print_cl_list(stdout, Demodulators); */
		Stats[INPUT_ERRORS]++;
		}
	    }

	else 
	    error = 1;

	if (error) {
	    Stats[INPUT_ERRORS]++;
	    if (t != NULL) {
		printf("ERROR, command not found: ");
		print_term(stdout, t); printf(".\n");
		}
	    }
	if (t != NULL)
	    zap_term(t);
	t = read_term(stdin, &rc);
	}

}  /* read_all_input */

/*************
 *
 *    free_all_mem()
 *
 *************/

void free_all_mem()
{
    struct clause *c;

    c = extract_last_cl(Axioms);
    while (c != NULL) {
	cl_del_int(c);
	c = extract_last_cl(Axioms);
	}
    free_list(Axioms);
    Axioms = NULL;

    c = extract_last_cl(Sos);
    while (c != NULL) {
	cl_del_int(c);
	c = extract_last_cl(Sos);
	}
    free_list(Sos);
    Sos = NULL;

    c = extract_last_cl(Passive);
    while (c != NULL) {
	cl_del_int(c);
	c = extract_last_cl(Passive);
	}
    free_list(Passive);
    Passive = NULL;

    /* del_hidden_clauses(); */

    free_sym_tab();
}  /* free_all_mem */

void output_stats(fp, level)
FILE *fp;
int level;
{

}
  
/*************
 *
 *    append_lists(l1, l2) -- append l2 to l1 and free the header node l2
 *
 *************/

void append_lists(l1, l2)
struct list *l1;
struct list *l2;
{
    struct clause *c;

    if (l1->last_cl != NULL)  /* if l1 not empty */
        l1->last_cl->next_cl = l2->first_cl;
    else
	l1->first_cl = l2->first_cl;

    if (l2->first_cl != NULL) {  /* if l2 not empty */
	l2->first_cl->prev_cl = l1->last_cl;
	l1->last_cl = l2->last_cl;
	}

    c = l2->first_cl;
    while (c != NULL) {
	c->container = l1;
	c = c->next_cl;
	}

    free_list(l2);
}  /* append_lists */

/*************
 *
 *    struct term *copy_term(term) -- Return a copy of the term.
 *
 *************/

struct term *copy_term(t)
struct term *t;
{
    struct rel *r, *r2, *r3;
    struct term *t2;

    t2 = get_term();
    t2->type = t->type;
    t2->sym_num = t->sym_num;
    t2->varnum = t->varnum;
    if (t->type != COMPLEX)
	return(t2);
    else {
	r3 = NULL;
	r = t->farg;
	while (r != NULL) {
	    r2 = get_rel();
	    if (r3 == NULL)
		t2->farg = r2;
	    else 
		r3->narg = r2;
	    r2->argval = copy_term(r->argval);
	    r3 = r2;
	    r = r->narg;
	    }
	return(t2);
	}
}  /* copy_term */

struct term *copy_term_scratch(t)
struct term *t;
{
    struct rel *r, *r2, *r3;
    struct term *t2;


    t2 = get_term();
    t2->type = t->type;
    t2->sym_num = t->sym_num;
    t2->varnum = t->varnum;
    t2->scratch = t->scratch;
    t2->scratch2 = t->scratch2;
    if (t->type != COMPLEX)
        return(t2);
    else {
        r3 = NULL;
        r = t->farg;
        while (r != NULL) {
            r2 = get_rel();
            if (r3 == NULL)
                t2->farg = r2;
            else
                r3->narg = r2;
            r2->argval = copy_term_scratch(r->argval);
            r3 = r2;
            r = r->narg;
            }
        return(t2);
        }
}  /* copy_term_scratch */


/*************
 *
 *    int biggest_var(term)  --  return largest variable number (-1 if none)
 *
 *************/

int biggest_var(t)
struct term *t;
{
    struct rel *r;
    int i, j;

    if (t->type == VARIABLE)
	return(t->varnum);
    else if (t->type == NAME) 
	return(-1);
    else {
	r = t->farg;
	i = -1;
	while (r != NULL) {
	    j = biggest_var(r->argval);
	    if (j > i)
		i = j;
	    r = r->narg;
	    }
	return(i);
	}
}  /* biggest_var */

/*************
 *
 *     int occurs_in(t1, t2) -- Does t1 occur in t2?
 *
 *     term_ident is used to check identity.
 *
 *************/

int occurs_in(t1, t2)
struct term *t1;
struct term *t2;
{
    struct rel *r;

    if (term_ident(t1, t2))
	return(1);
    else if (t2->type != COMPLEX)
	return(0);
    else {
	r = t2->farg;
	while (r != NULL && occurs_in(t1, r->argval) == 0) 
	    r = r->narg;
	return(r != NULL);
	}
}  /* occurs_in */

/*************
 *
 *    int sn_occur(sn, t)
 *
 *    Is sn the sym_num of t or any subterms of t?
 *
 *************/

int sn_occur(sn, t)
int sn;
struct term *t;
{
    struct rel *r;
    int occurs;

    if (t->type != COMPLEX)
	return(t->sym_num == sn);
    else if (t->sym_num == sn)
	return(1);
    else {
	occurs = 0;
	r = t->farg;
	while (r != NULL && occurs == 0) {
	    occurs = sn_occur(sn, r->argval);
	    r = r->narg;
	    }
	return(occurs);
	}
}  /* sn_occur */

/*************
 *
 *    int ground(t) -- is a term ground?
 *
 *************/

int ground(t)
struct term *t;
{
    struct rel *r;
    int ok;

    if (t->type == NAME)
	return(1);
    else if (t->type == VARIABLE)
	return(0);
    else { /* COMPLEX */
	ok = 1;
	for (r = t->farg; r != NULL && ok; r = r->narg)
	    ok = ground(r->argval);
	return(ok);
	}
}  /* ground */

#define SHIFT_SYM 6

static long unsigned Mask_sym = (1 << SHIFT_SYM) -1;

/*************
 *
 *   int new_sym_num()
 *
 *   Return the next available symbol number.
 *
 *   The rightmost SHIFT_SYM bits will not be all zero.
 *   This is so that fpa will not map sym_nums to 0 (the
 *   code for variables).
 *
 *************/
 
int new_sym_num()
{
    static int sym_ent_count;

    sym_ent_count++;

    if ((sym_ent_count & ~ Mask_sym) == sym_ent_count)
        sym_ent_count++;

    return(sym_ent_count);

}  /* new_sym_num */


/*************
 *
 *    int term_ident(term1, term2) -- Compare two terms.
 *
 *        If identical return(1); else return(0).  The scratch
 *    areas are not checked.
 *
 *************/

int term_ident(t1, t2)
struct term *t1;
struct term *t2;
{
    struct rel *r1, *r2;

    if (t1->type != t2->type)
	return(0);
    else if (t1->sym_num != t2->sym_num)
	return(0);
    else if (t1->type == NAME)
	return(1);
    else if (t1->type == VARIABLE)
	return(t1->varnum == t2->varnum);
    else {
	r1 = t1->farg;
	r2 = t2->farg;
	/* arities are same because sym_num's are the same */
	while (r1 != NULL && term_ident(r1->argval,r2->argval)) {
	    r1 = r1->narg;
	    r2 = r2->narg;
	    }
	return(r1 == NULL);
	}
}  /* term_ident */  

