;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		Variables.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "DTP")

;;;----------------------------------------------------------------------------
;;;
;;;	Parameters

;; Tracing
(defparameter *trace-keywords*
    '(:file-load :tests :proofs :conjunct-proofs)
  "Variable *TRACE* is any subset of this list" )
(defparameter *trace-defaults* '(:file-load :tests))

;;;----------------------------------------------------------------------------
;;;
;;;	Variables

(defvar *dtp-package* (find-package "DTP"))

;; Defaults
(defvar *default-theory* 'global)

;; Display form
(defvar *display-logic-as-lists* nil)
(defvar *show-renamed-variables* nil)

;; Tracing
(defvar *trace* *trace-defaults*)
(defvar *proof-line-count*)
(defvar *depth*)
(defvar *subgoal-map*)

;; Internal
(defvar *node-id-count* 0)
(defvar *proof*)			; Dynamic variable, set to (make-proof)
(defvar *goal-node-id-count*)
(defvar *all-gensymed-variables* nil)	; So we can unintern them on reset

;;;----------------------------------------------------------------------------
;;;
;;;	Types

#-lucid
(eval-when (compile load eval)
  (declaim (type package *dtp-package*))
  (declaim (type symbol *default-theory*))
  (declaim (type list *trace-keywords*))
  (declaim (type list *trace-defaults*))
  (declaim (type list *trace*))
  (declaim (type (integer 0 *) *proof-line-count*))
  (declaim (type (integer 0 *) *depth*))
  (declaim (type proof *proof*))
  (declaim (type (integer 0 *) *node-id-count*))
  (declaim (type (integer 0 *) *goal-node-id-count*))
  (declaim (type list *all-gensymed-variables*))
  )

;;;----------------------------------------------------------------------------
