;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		Structures.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "DTP")

;;;----------------------------------------------------------------------------

(defstruct (answer
	    (:print-function print-answer) )
  (binding-list '((t . t)))
  label
  (ae-binding-lists nil) )

(defun print-answer (structure stream depth)
  (declare (ignore depth))
  (format stream "#<Answer")
  (if (answer-binding-list structure)
      (print-binding-list (answer-binding-list structure) :s stream)
    (format stream " TRUE") )
  (when (answer-label structure)
    (format stream " with label ~A"
	    (label-value (answer-label structure)) ))
  (dolist (ae-bl (answer-ae-binding-lists structure))
    (format stream " or")
    (print-binding-list ae-bl :s stream) )
  (format stream ">") )

;;;----------------------------------------------------------------------------

(defstruct (me-answer
	    (:include answer)
	    (:print-function print-me-answer) )
  "An answer derived via model elimination, so full binding list must be kept"
  )

(defun print-me-answer (structure stream depth)
  (declare (ignore depth))
  (format stream "#<Model elimination answer")
  (if (answer-binding-list structure)
      (print-binding-list (answer-binding-list structure) :s stream)
    (format stream " TRUE") )
  (when (answer-label structure)
    (format stream " with label ~A"
	    (label-value (answer-label structure)) ))
  (dolist (ae-bl (answer-ae-binding-lists structure))
    (format stream " or")
    (print-binding-list ae-bl :s stream) )
  (format stream ">") )

;;;----------------------------------------------------------------------------

(defstruct (kb-node
	    (:print-function print-kb-node) )
  id
  (clause nil) )

(defun print-kb-node (structure stream depth)
  (declare (ignore depth))
  (format stream "#<~A:~A>" (kb-node-id structure) (kb-node-clause structure)) )

;;;----------------------------------------------------------------------------

(defstruct (proof
	    (:print-function print-proof) )
  ;; Specified by user
  query
  theory
  (return-form nil)			; NIL => plug in to original query

  ;; Internal
  query-conjunctions
  subgoal-agenda
  (new-answers nil)			; Acquired by propogation, will move...
  (answers nil)				; ...to here once processed
  (subgoal-index (make-hash-table :test #'eq)) ; Map from relation -> sg list
  goal-nodes

  ;; Tracing
  (used-conjunctions nil)
  (forward-inference-conjunctions nil) )

(defun print-proof (structure stream depth)
  (declare (ignore depth))
  (format stream "#<Proof of ~A with ~D answer~:P"
	  (proof-query structure) (length (proof-answers structure)) )
  (when (null (proof-query-conjunctions structure))
    (format stream " [Complete]") )
  (format stream ">") )

;;;----------------------------------------------------------------------------
