%--------------------------------------------------------------------------
% File     : TOP019=ClsrConn-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : The closure of a connected set is connected
% Version  : [Wick & McCune, 1989] axioms : Incomplete.
% English  : 

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Problem 14 [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :  111 (  23 non-Horn)(   2 unit)
%            Number of literals          :  338 (   0 equality)
%            Number of predicate symbols :   22 (   0 propositional)
%            Number of function symbols  :   38 (   4 constant)
%            Number of variables         :  357 (  56 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            obtain a proof of this theorem it may be necessary to add
%            appropriate set theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
input_clause(problem_14_162,theorem,
    [++connected_set(a,cx,ct)]).

input_clause(problem_14_163,theorem,
    [--connected_set(closure(a,cx,ct),cx,ct)]).
%--------------------------------------------------------------------------
