%--------------------------------------------------------------------------
% File     : TOP018=LmtPtConnSet-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Propoerty of limits points and connected sets
% Version  : [Wick & McCune, 1989] axioms : Incomplete.
% English  : If limit points are added to a connected set, the result is 
%            connected.

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Problem 13 [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :  112 (  23 non-Horn)(   2 unit)
%            Number of literals          :  340 (   0 equality)
%            Number of predicate symbols :   22 (   0 propositional)
%            Number of function symbols  :   39 (   5 constant)
%            Number of variables         :  358 (  56 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            obtain a proof of this theorem it may be necessary to add
%            appropriate set theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
input_clause(problem_13_159,theorem,
    [++connected_set(a,cx,ct)]).

input_clause(problem_13_160,theorem,
    [--element_of_set(Y,b),
     ++limit_point(Y,a,cx,ct)]).

input_clause(problem_13_161,theorem,
    [--connected_set(union_of_sets(a,b),cx,ct)]).
%--------------------------------------------------------------------------
