%--------------------------------------------------------------------------
% File     : TOP017=BndyEmpty-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : If the boundary of A is empty, A is both open and closed
% Version  : [Wick & McCune, 1989] axioms : Incomplete.
% English  : 

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Problem 12 [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :  114 (  25 non-Horn)(   2 unit)
%            Number of literals          :  345 (   0 equality)
%            Number of predicate symbols :   22 (   0 propositional)
%            Number of function symbols  :   38 (   4 constant)
%            Number of variables         :  357 (  56 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            obtain a proof of this theorem it may be necessary to add
%            appropriate set theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
input_clause(problem_12_154,theorem,
    [++topological_space(cx,ct)]).

input_clause(problem_12_155,theorem,
    [++subset_sets(a,cx)]).

input_clause(problem_12_156,theorem,
    [++equal_sets(boundary(a,cx,ct),empty_set),
     ++open(a,cx,ct)]).

input_clause(problem_12_157,theorem,
    [++equal_sets(boundary(a,cx,ct),empty_set),
     ++closed(a,cx,ct)]).

input_clause(problem_12_158,theorem,
    [--equal_sets(boundary(a,cx,ct),empty_set),
     --open(a,cx,ct),
     --closed(a,cx,ct)]).
%--------------------------------------------------------------------------
