%--------------------------------------------------------------------------
% File     : TOP014=OpenIntrClsdClsr-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Properties of open & interior and closed & closure
% Version  : [Wick & McCune, 1989] axioms : Incomplete.
% English  : If A is open, the interior of A is A, and if A is closed, the 
%            closure of A is A.

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Problem 9 [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :  115 (  26 non-Horn)(   2 unit)
%            Number of literals          :  354 (   0 equality)
%            Number of predicate symbols :   22 (   0 propositional)
%            Number of function symbols  :   38 (   4 constant)
%            Number of variables         :  357 (  56 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            obtain a proof of this theorem it may be necessary to add
%            appropriate set theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
input_clause(problem_9_142,theorem,
    [++topological_space(cx,ct)]).

input_clause(problem_9_143,theorem,
    [++subset_sets(a,cx)]).

input_clause(problem_9_144,theorem,
    [++open(a,cx,ct),
     ++equal_sets(a,interior(a,cx,ct)),
     ++closed(a,cx,ct),
     ++equal_sets(a,closure(a,cx,ct))]).

input_clause(problem_9_145,theorem,
    [++open(a,cx,ct),
     ++equal_sets(a,interior(a,cx,ct)),
     --closed(a,cx,ct),
     --equal_sets(a,closure(a,cx,ct))]).

input_clause(problem_9_146,theorem,
    [--open(a,cx,ct),
     --equal_sets(a,interior(a,cx,ct)),
     ++closed(a,cx,ct),
     ++equal_sets(a,closure(a,cx,ct))]).

input_clause(problem_9_147,theorem,
    [--open(a,cx,ct),
     --equal_sets(a,interior(a,cx,ct)),
     --closed(a,cx,ct),
     --equal_sets(a,closure(a,cx,ct))]).
%--------------------------------------------------------------------------
