%--------------------------------------------------------------------------
% File     : TOP013=IntrSubSClsr-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Properties of interior and closure
% Version  : [Wick & McCune, 1989] axioms : Incomplete.
% English  : The interior of A is a subset of A, which is a subset of the 
%            closure of A.

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Problem 8 [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :  112 (  23 non-Horn)(   2 unit)
%            Number of literals          :  340 (   0 equality)
%            Number of predicate symbols :   22 (   0 propositional)
%            Number of function symbols  :   38 (   4 constant)
%            Number of variables         :  357 (  56 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            obtain a proof of this theorem it may be necessary to add
%            appropriate set theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
input_clause(problem_8_139,theorem,
    [++topological_space(cx,ct)]).

input_clause(problem_8_140,theorem,
    [++subset_sets(a,cx)]).

input_clause(problem_8_141,theorem,
    [--subset_sets(interior(a,cx,ct),a),
     --subset_sets(a,closure(a,cx,ct))]).
%--------------------------------------------------------------------------
