%--------------------------------------------------------------------------
% File     : TOP012=UnionIntscClsd-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Intersections and finite unions of closed sets are closed
% Version  : [Wick & McCune, 1989] axioms : Incomplete.
% English  : 

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Problem 7 [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :  119 (  27 non-Horn)(   1 unit)
%            Number of literals          :  376 (   0 equality)
%            Number of predicate symbols :   22 (   0 propositional)
%            Number of function symbols  :   40 (   6 constant)
%            Number of variables         :  360 (  56 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            obtain a proof of this theorem it may be necessary to add
%            appropriate set theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
input_clause(problem_7_129,theorem,
    [++topological_space(cx,ct)]).

input_clause(problem_7_130,theorem,
    [--closed(empty_set,cx,ct),
     --closed(cx,cx,ct),
     ++closed(cy1,cx,ct),
     ++subset_sets(union_of_members(f),cx)]).

input_clause(problem_7_131,theorem,
    [--closed(empty_set,cx,ct),
     --closed(cx,cx,ct),
     ++closed(cy1,cx,ct),
     --element_of_collection(V,f),
     ++closed(V,cx,ct)]).

input_clause(problem_7_132,theorem,
    [--closed(empty_set,cx,ct),
     --closed(cx,cx,ct),
     ++closed(cy1,cx,ct),
     --closed(intersection_of_members(f),cx,ct)]).

input_clause(problem_7_133,theorem,
    [--closed(empty_set,cx,ct),
     --closed(cx,cx,ct),
     ++closed(cy2,cx,ct),
     ++subset_sets(union_of_members(f),cx)]).

input_clause(problem_7_134,theorem,
    [--closed(empty_set,cx,ct),
     --closed(cx,cx,ct),
     ++closed(cy2,cx,ct),
     --element_of_collection(V,f),
     ++closed(V,cx,ct)]).

input_clause(problem_7_135,theorem,
    [--closed(empty_set,cx,ct),
     --closed(cx,cx,ct),
     ++closed(cy2,cx,ct),
     --closed(intersection_of_members(f),cx,ct)]).

input_clause(problem_7_136,theorem,
    [--closed(empty_set,cx,ct),
     --closed(cx,cx,ct),
     --closed(union_of_sets(cy1,cy2),cx,ct),
     ++subset_sets(union_of_members(f),cx)]).

input_clause(problem_7_137,theorem,
    [--closed(empty_set,cx,ct),
     --closed(cx,cx,ct),
     --closed(union_of_sets(cy1,cy2),cx,ct),
     --element_of_collection(V,f),
     ++closed(V,cx,ct)]).

input_clause(problem_7_138,theorem,
    [--closed(empty_set,cx,ct),
     --closed(cx,cx,ct),
     --closed(union_of_sets(cy1,cy2),cx,ct),
     --closed(intersection_of_members(f),cx,ct)]).
%--------------------------------------------------------------------------
