%--------------------------------------------------------------------------
% File     : TOP011=TopBasisAltDef-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : An alternative definition of top_of_basis
% Version  : [Wick & McCune, 1989] axioms : Incomplete.
% English  : 

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Problem 6 [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :  112 (  25 non-Horn)(   0 unit)
%            Number of literals          :  343 (   0 equality)
%            Number of predicate symbols :   22 (   0 propositional)
%            Number of function symbols  :   38 (   4 constant)
%            Number of variables         :  358 (  56 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            obtain a proof of this theorem it may be necessary to add
%            appropriate set theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
input_clause(problem_6_126,theorem,
    [++element_of_set(cu,top_of_basis(f)),
     ++subset_collections(g,f)]).

input_clause(problem_6_127,theorem,
    [++element_of_set(cu,top_of_basis(f)),
     ++equal_sets(cu,union_of_members(g))]).

input_clause(problem_6_128,theorem,
    [--element_of_set(cu,top_of_basis(f)),
     --subset_collections(X,f),
     --equal_sets(cu,union_of_members(X))]).
%--------------------------------------------------------------------------
