%--------------------------------------------------------------------------
% File     : TOP007=TplgEqn1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Property 1 of topological spaces
% Version  : [Wick & McCune, 1989] axioms : Incomplete.
% English  : If (cx,ct) is a topological space, A is a subset of X, and 
%            every point in A has a neighborhood U that is a subset of A, 
%            then A is open in (cx,ct).

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Problem 2 [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :  114 (  23 non-Horn)(   3 unit)
%            Number of literals          :  343 (   0 equality)
%            Number of predicate symbols :   22 (   0 propositional)
%            Number of function symbols  :   39 (   4 constant)
%            Number of variables         :  359 (  56 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            obtain a proof of this theorem it may be necessary to add
%            appropriate set theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
input_clause(problem_2_112,theorem,
    [++topological_space(cx,ct)]).

input_clause(problem_2_113,theorem,
    [++subset_sets(a,cx)]).

input_clause(problem_2_114,theorem,
    [--element_of_set(Y,a),
     ++neighborhood(f30(Y),Y,cx,ct)]).

input_clause(problem_2_115,theorem,
    [--element_of_set(Y,a),
     ++subset_sets(f30(Y),a)]).

input_clause(problem_2_116,theorem,
    [--open(a,cx,ct)]).
%--------------------------------------------------------------------------
