%--------------------------------------------------------------------------
% File     : TOP005=BasisTplgLem5-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Topology generated by a basis forms a topological space, part 5
% Version  : [Wick & McCune, 1989] axioms :
%            Incomplete > Reduced & Augmented > Incomplete.
% English  : 

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Lemma 1e [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :   12 (   2 non-Horn)(   2 unit)
%            Number of literals          :   30 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    7 (   2 constant)
%            Number of variables         :   27 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : The axioms in this version are known to be incomplete. To
%            make them complete it is be necessary to add appropriate set 
%            theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
% include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
%----Sigma (union of members). 
input_clause(union_of_members_1,axiom,
    [--element_of_set(U,union_of_members(Vf)),
     ++element_of_set(U,f1(Vf,U))]).

input_clause(union_of_members_2,axiom,
    [--element_of_set(U,union_of_members(Vf)),
     ++element_of_collection(f1(Vf,U),Vf)]).

%----Topology generated by a basis 
input_clause(topology_generated_37,axiom,
    [--element_of_collection(U,top_of_basis(Vf)),
     --element_of_set(X,U),
     ++element_of_set(X,f10(Vf,U,X))]).

input_clause(topology_generated_38,axiom,
    [--element_of_collection(U,top_of_basis(Vf)),
     --element_of_set(X,U),
     ++element_of_collection(f10(Vf,U,X),Vf)]).

input_clause(topology_generated_39,axiom,
    [--element_of_collection(U,top_of_basis(Vf)),
     --element_of_set(X,U),
     ++subset_sets(f10(Vf,U,X),U)]).

input_clause(topology_generated_40,axiom,
    [++element_of_collection(U,top_of_basis(Vf)),
     ++element_of_set(f11(Vf,U),U)]).

input_clause(topology_generated_41,axiom,
    [++element_of_collection(U,top_of_basis(Vf)),
     --element_of_set(f11(Vf,U),Uu11),
     --element_of_collection(Uu11,Vf),
     --subset_sets(Uu11,U)]).

input_clause(set_theory_19,axiom,
    [++subset_sets(X,Y),
     --element_of_set(U,X),
     ++element_of_set(U,Y)]).

input_clause(set_theory_20,axiom,
    [--subset_sets(X,Y),
     --element_of_collection(Y,Z),
     ++subset_sets(X,union_of_members(Z))]).

input_clause(set_theory_21,axiom,
    [--subset_collections(X,Y),
     --element_of_collection(U,X),
     ++element_of_collection(U,Y)]).

%----Not used in the reduced version 
% input_clause(lemma_1e_1,theorem,
%     [++basis(cx,f)]).

input_clause(lemma_1e_2,theorem,
    [++subset_collections(g,top_of_basis(f))]).

input_clause(lemma_1e_3,theorem,
    [--element_of_collection(union_of_members(g),top_of_basis(f))]).
%--------------------------------------------------------------------------
