%--------------------------------------------------------------------------
% File     : TOP005=BasisTplgLem5-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Topology generated by a basis forms a topological space, part 5
% Version  : [Wick & McCune, 1989] axioms : Incomplete.
% English  : 

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Lemma 1e [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :  112 (  23 non-Horn)(   3 unit)
%            Number of literals          :  339 (   0 equality)
%            Number of predicate symbols :   22 (   0 propositional)
%            Number of function symbols  :   38 (   4 constant)
%            Number of variables         :  357 (  56 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            obtain a proof of this theorem it may be necessary to add
%            appropriate set theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
input_clause(lemma_1e_1,theorem,
    [++basis(cx,f)]).

input_clause(lemma_1e_2,theorem,
    [++subset_collections(g,top_of_basis(f))]).

input_clause(lemma_1e_3,theorem,
    [--element_of_collection(union_of_members(g),top_of_basis(f))]).
%--------------------------------------------------------------------------
