%--------------------------------------------------------------------------
% File     : TOP004=BasisTplgLem4-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Topology generated by a basis forms a topological space, part 4
% Version  : [Wick & McCune, 1989] axioms :
%            Incomplete > Reduced & Augmented > Incomplete.
% English  : 

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Lemma 1d [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :   21 (   1 non-Horn)(   5 unit)
%            Number of literals          :   59 (   0 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :    8 (   2 constant)
%            Number of variables         :   59 (   6 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : The axioms in this version are known to be incomplete. To
%            make them complete it is be necessary to add appropriate set 
%            theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
% include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
%----Sigma (union of members). 
input_clause(union_of_members_3,axiom,
    [++element_of_set(U,union_of_members(Vf)),
     --element_of_set(U,Uu1),
     --element_of_collection(Uu1,Vf)]).

%----Basis for a topology 
input_clause(basis_for_topology_28,axiom,
    [--basis(X,Vf),
     ++equal_sets(union_of_members(Vf),X)]).

input_clause(basis_for_topology_29,axiom,
    [--basis(X,Vf),
     --element_of_set(Y,X),
     --element_of_collection(Vb1,Vf),
     --element_of_collection(Vb2,Vf),
     --element_of_set(Y,intersection_of_sets(Vb1,Vb2)),
     ++element_of_set(Y,f6(X,Vf,Y,Vb1,Vb2))]).

input_clause(basis_for_topology_30,axiom,
    [--basis(X,Vf),
     --element_of_set(Y,X),
     --element_of_collection(Vb1,Vf),
     --element_of_collection(Vb2,Vf),
     --element_of_set(Y,intersection_of_sets(Vb1,Vb2)),
     ++element_of_collection(f6(X,Vf,Y,Vb1,Vb2),Vf)]).

input_clause(basis_for_topology_31,axiom,
    [--basis(X,Vf),
     --element_of_set(Y,X),
     --element_of_collection(Vb1,Vf),
     --element_of_collection(Vb2,Vf),
     --element_of_set(Y,intersection_of_sets(Vb1,Vb2)),
     ++subset_sets(f6(X,Vf,Y,Vb1,Vb2),intersection_of_sets(Vb1,Vb2))]).

%----Topology generated by a basis 
input_clause(topology_generated_37,axiom,
    [--element_of_collection(U,top_of_basis(Vf)),
     --element_of_set(X,U),
     ++element_of_set(X,f10(Vf,U,X))]).

input_clause(topology_generated_38,axiom,
    [--element_of_collection(U,top_of_basis(Vf)),
     --element_of_set(X,U),
     ++element_of_collection(f10(Vf,U,X),Vf)]).

input_clause(topology_generated_39,axiom,
    [--element_of_collection(U,top_of_basis(Vf)),
     --element_of_set(X,U),
     ++subset_sets(f10(Vf,U,X),U)]).

input_clause(topology_generated_40,axiom,
    [++element_of_collection(U,top_of_basis(Vf)),
     ++element_of_set(f11(Vf,U),U)]).

input_clause(topology_generated_41,axiom,
    [++element_of_collection(U,top_of_basis(Vf)),
     --element_of_set(f11(Vf,U),Uu11),
     --element_of_collection(Uu11,Vf),
     --subset_sets(Uu11,U)]).

input_clause(set_theory_12,axiom,
    [--subset_sets(X,Y),
     --subset_sets(Y,Z),
     ++subset_sets(X,Z)]).

input_clause(set_theory_13,axiom,
    [--element_of_set(Z,intersection_of_sets(X,Y)),
     ++element_of_set(Z,X)]).

input_clause(set_theory_14,axiom,
    [--element_of_set(Z,intersection_of_sets(X,Y)),
     ++element_of_set(Z,Y)]).

input_clause(set_theory_15,axiom,
    [++element_of_set(Z,intersection_of_sets(X,Y)),
     --element_of_set(Z,X),
     --element_of_set(Z,Y)]).

input_clause(set_theory_16,axiom,
    [--subset_sets(X,Y),
     --subset_sets(U,V),
     ++subset_sets(intersection_of_sets(X,U),intersection_of_sets(Y,V))]).

input_clause(set_theory_17,axiom,
    [--equal_sets(X,Y),
     --element_of_set(Z,X),
     ++element_of_set(Z,Y)]).

input_clause(set_theory_18,axiom,
    [++equal_sets(intersection_of_sets(X,Y),intersection_of_sets(Y,X))]).

input_clause(lemma_1d_1,theorem,
    [++basis(cx,f)]).

input_clause(lemma_1d_2,theorem,
    [++element_of_collection(U,top_of_basis(f))]).

input_clause(lemma_1d_3,theorem,
    [++element_of_collection(V,top_of_basis(f))]).

input_clause(lemma_1d_4,theorem,
    [--element_of_collection(intersection_of_sets(U,V),top_of_basis(f))]).
%--------------------------------------------------------------------------
